/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vedi.sound.ibxm;

public class Sample {
    public static final int FP_SHIFT = 15;
    public static final int FP_ONE = 32768;
    public static final int FP_MASK = Short.MAX_VALUE;
    public static final int C2_PAL = 8287;
    public static final int C2_NTSC = 8363;
    public String name = "";
    public int volume = 0;
    public int panning = -1;
    public int relNote = 0;
    public int fineTune = 0;
    public int c2Rate = 8363;
    private int loopStart = 0;
    private int loopLength = 0;
    private short[] sampleData;
    private static final int LOG2_FILTER_TAPS = 4;
    private static final int FILTER_TAPS = 16;
    private static final int DELAY = 8;
    private static final int LOG2_TABLE_ACCURACY = 4;
    private static final int TABLE_ACCURACY = 16;
    private static final int TABLE_INTERP_SHIFT = 11;
    private static final int TABLE_INTERP_ONE = 2048;
    private static final int TABLE_INTERP_MASK = 2047;
    private static final short[] SINC_TABLE = new short[]{0, 0, 0, 0, 0, 0, 0, Short.MAX_VALUE, 0, 0, 0, 0, 0, 0, 0, 0, -1, 7, -31, 103, -279, 671, -1731, 32546, 2006, -747, 312, -118, 37, -8, 1, 0, -1, 12, -56, 190, -516, 1246, -3167, 31887, 4259, -1549, 648, -248, 78, -18, 2, 0, -1, 15, -74, 257, -707, 1714, -4299, 30808, 6722, -2375, 994, -384, 122, -29, 4, 0, -2, 17, -87, 305, -849, 2067, -5127, 29336, 9351, -3196, 1338, -520, 169, -41, 6, 0, -2, 18, -93, 334, -941, 2303, -5659, 27510, 12092, -3974, 1662, -652, 214, -53, 8, 0, -1, 17, -95, 346, -985, 2425, -5912, 25375, 14888, -4673, 1951, -771, 257, -65, 10, 0, -1, 16, -92, 341, -985, 2439, -5908, 22985, 17679, -5254, 2188, -871, 294, -76, 13, -1, -1, 15, -85, 323, -945, 2355, -5678, 20399, 20399, -5678, 2355, -945, 323, -85, 15, -1, -1, 13, -76, 294, -871, 2188, -5254, 17679, 22985, -5908, 2439, -985, 341, -92, 16, -1, 0, 10, -65, 257, -771, 1951, -4673, 14888, 25375, -5912, 2425, -985, 346, -95, 17, -1, 0, 8, -53, 214, -652, 1662, -3974, 12092, 27510, -5659, 2303, -941, 334, -93, 18, -2, 0, 6, -41, 169, -520, 1338, -3196, 9351, 29336, -5127, 2067, -849, 305, -87, 17, -2, 0, 4, -29, 122, -384, 994, -2375, 6722, 30808, -4299, 1714, -707, 257, -74, 15, -1, 0, 2, -18, 78, -248, 648, -1549, 4259, 31887, -3167, 1246, -516, 190, -56, 12, -1, 0, 1, -8, 37, -118, 312, -747, 2006, 32546, -1731, 671, -279, 103, -31, 7, -1, 0, 0, 0, 0, 0, 0, 0, 0, Short.MAX_VALUE, 0, 0, 0, 0, 0, 0, 0};

    public short[] getSampleData() {
        return this.sampleData;
    }

    public void setSampleData(short[] sampleData, int loopStart, int loopLength, boolean pingPong) {
        int idx;
        int sampleLength = sampleData.length;
        if (loopStart < 0 || loopStart > sampleLength) {
            loopStart = sampleLength;
        }
        if (loopLength < 0 || loopStart + loopLength > sampleLength) {
            loopLength = sampleLength - loopStart;
        }
        sampleLength = loopStart + loopLength;
        loopStart += 8;
        int newSampleLength = 8 + sampleLength + (pingPong ? loopLength : 0) + 16;
        short[] newSampleData = new short[newSampleLength];
        System.arraycopy(sampleData, 0, newSampleData, 8, sampleLength);
        sampleData = newSampleData;
        if (pingPong) {
            int loopEnd = loopStart + loopLength;
            for (int idx2 = 0; idx2 < loopLength; ++idx2) {
                sampleData[loopEnd + idx2] = sampleData[loopEnd - idx2 - 1];
            }
            loopLength *= 2;
        }
        int end2 = idx + 16;
        for (idx = loopStart + loopLength; idx < end2; ++idx) {
            sampleData[idx] = sampleData[idx - loopLength];
        }
        this.sampleData = sampleData;
        this.loopStart = loopStart;
        this.loopLength = loopLength;
    }

    public void resampleNearest(int sampleIdx, int sampleFrac, int step, int leftGain, int rightGain, int[] mixBuffer, int offset, int length) {
        int loopLen = this.loopLength;
        int loopEnd = this.loopStart + loopLen;
        if ((sampleIdx += 8) >= loopEnd) {
            sampleIdx = this.normaliseSampleIdx(sampleIdx);
        }
        short[] data2 = this.sampleData;
        int outIdx = offset << 1;
        int outEnd = offset + length << 1;
        while (outIdx < outEnd) {
            if (sampleIdx >= loopEnd) {
                if (loopLen < 2) break;
                while (sampleIdx >= loopEnd) {
                    sampleIdx -= loopLen;
                }
            }
            short y = data2[sampleIdx];
            int n = outIdx++;
            mixBuffer[n] = mixBuffer[n] + (y * leftGain >> 15);
            int n2 = outIdx++;
            mixBuffer[n2] = mixBuffer[n2] + (y * rightGain >> 15);
            sampleIdx += (sampleFrac += step) >> 15;
            sampleFrac &= Short.MAX_VALUE;
        }
    }

    public void resampleLinear(int sampleIdx, int sampleFrac, int step, int leftGain, int rightGain, int[] mixBuffer, int offset, int length) {
        int loopLen = this.loopLength;
        int loopEnd = this.loopStart + loopLen;
        if ((sampleIdx += 8) >= loopEnd) {
            sampleIdx = this.normaliseSampleIdx(sampleIdx);
        }
        short[] data2 = this.sampleData;
        int outIdx = offset << 1;
        int outEnd = offset + length << 1;
        while (outIdx < outEnd) {
            if (sampleIdx >= loopEnd) {
                if (loopLen < 2) break;
                while (sampleIdx >= loopEnd) {
                    sampleIdx -= loopLen;
                }
            }
            short c = data2[sampleIdx];
            int m = data2[sampleIdx + 1] - c;
            int y = (m * sampleFrac >> 15) + c;
            int n = outIdx++;
            mixBuffer[n] = mixBuffer[n] + (y * leftGain >> 15);
            int n2 = outIdx++;
            mixBuffer[n2] = mixBuffer[n2] + (y * rightGain >> 15);
            sampleIdx += (sampleFrac += step) >> 15;
            sampleFrac &= Short.MAX_VALUE;
        }
    }

    public void resampleSinc(int sampleIdx, int sampleFrac, int step, int leftGain, int rightGain, int[] mixBuffer, int offset, int length) {
        int loopLen = this.loopLength;
        int loopEnd = this.loopStart + loopLen;
        if (sampleIdx >= loopEnd) {
            sampleIdx = this.normaliseSampleIdx(sampleIdx);
        }
        short[] data2 = this.sampleData;
        int outIdx = offset << 1;
        int outEnd = offset + length << 1;
        while (outIdx < outEnd) {
            if (sampleIdx >= loopEnd) {
                if (loopLen < 2) break;
                while (sampleIdx >= loopEnd) {
                    sampleIdx -= loopLen;
                }
            }
            int tableIdx = sampleFrac >> 11 << 4;
            int a1 = 0;
            int a2 = 0;
            a1 = SINC_TABLE[tableIdx + 0] * data2[sampleIdx + 0];
            a1 += SINC_TABLE[tableIdx + 1] * data2[sampleIdx + 1];
            a1 += SINC_TABLE[tableIdx + 2] * data2[sampleIdx + 2];
            a1 += SINC_TABLE[tableIdx + 3] * data2[sampleIdx + 3];
            a1 += SINC_TABLE[tableIdx + 4] * data2[sampleIdx + 4];
            a1 += SINC_TABLE[tableIdx + 5] * data2[sampleIdx + 5];
            a1 += SINC_TABLE[tableIdx + 6] * data2[sampleIdx + 6];
            a1 += SINC_TABLE[tableIdx + 7] * data2[sampleIdx + 7];
            a1 += SINC_TABLE[tableIdx + 8] * data2[sampleIdx + 8];
            a1 += SINC_TABLE[tableIdx + 9] * data2[sampleIdx + 9];
            a1 += SINC_TABLE[tableIdx + 10] * data2[sampleIdx + 10];
            a1 += SINC_TABLE[tableIdx + 11] * data2[sampleIdx + 11];
            a1 += SINC_TABLE[tableIdx + 12] * data2[sampleIdx + 12];
            a1 += SINC_TABLE[tableIdx + 13] * data2[sampleIdx + 13];
            a1 += SINC_TABLE[tableIdx + 14] * data2[sampleIdx + 14];
            a1 += SINC_TABLE[tableIdx + 15] * data2[sampleIdx + 15];
            a2 = SINC_TABLE[tableIdx + 16] * data2[sampleIdx + 0];
            a2 += SINC_TABLE[tableIdx + 17] * data2[sampleIdx + 1];
            a2 += SINC_TABLE[tableIdx + 18] * data2[sampleIdx + 2];
            a2 += SINC_TABLE[tableIdx + 19] * data2[sampleIdx + 3];
            a2 += SINC_TABLE[tableIdx + 20] * data2[sampleIdx + 4];
            a2 += SINC_TABLE[tableIdx + 21] * data2[sampleIdx + 5];
            a2 += SINC_TABLE[tableIdx + 22] * data2[sampleIdx + 6];
            a2 += SINC_TABLE[tableIdx + 23] * data2[sampleIdx + 7];
            a2 += SINC_TABLE[tableIdx + 24] * data2[sampleIdx + 8];
            a2 += SINC_TABLE[tableIdx + 25] * data2[sampleIdx + 9];
            a2 += SINC_TABLE[tableIdx + 26] * data2[sampleIdx + 10];
            a2 += SINC_TABLE[tableIdx + 27] * data2[sampleIdx + 11];
            a2 += SINC_TABLE[tableIdx + 28] * data2[sampleIdx + 12];
            a2 += SINC_TABLE[tableIdx + 29] * data2[sampleIdx + 13];
            a2 += SINC_TABLE[tableIdx + 30] * data2[sampleIdx + 14];
            a2 += SINC_TABLE[tableIdx + 31] * data2[sampleIdx + 15];
            int y = (a1 >>= 15) + (((a2 >>= 15) - a1) * (sampleFrac & 0x7FF) >> 11);
            int n = outIdx++;
            mixBuffer[n] = mixBuffer[n] + (y * leftGain >> 15);
            int n2 = outIdx++;
            mixBuffer[n2] = mixBuffer[n2] + (y * rightGain >> 15);
            sampleIdx += (sampleFrac += step) >> 15;
            sampleFrac &= Short.MAX_VALUE;
        }
    }

    public int normaliseSampleIdx(int sampleIdx) {
        int loopOffset = sampleIdx - this.loopStart;
        if (loopOffset > 0) {
            sampleIdx = this.loopStart;
            if (this.loopLength > 1) {
                sampleIdx += loopOffset % this.loopLength;
            }
        }
        return sampleIdx;
    }

    public boolean looped() {
        return this.loopLength > 1;
    }

    public void toStringBuffer(StringBuffer out) {
        out.append("Name: " + this.name + '\n');
        out.append("Volume: " + this.volume + '\n');
        out.append("Panning: " + this.panning + '\n');
        out.append("Relative Note: " + this.relNote + '\n');
        out.append("Fine Tune: " + this.fineTune + '\n');
        out.append("Loop Start: " + this.loopStart + '\n');
        out.append("Loop Length: " + this.loopLength + '\n');
    }
}

