/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.vedi.sound.ibxm;

import de.malban.vide.vedi.sound.ibxm.IBXM;
import de.malban.vide.vedi.sound.ibxm.Module;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class WavInputStream
extends InputStream {
    private static final byte[] header = new byte[]{82, 73, 70, 70, 0, 0, 0, 0, 87, 65, 86, 69, 102, 109, 116, 32, 16, 0, 0, 0, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 16, 0, 100, 97, 116, 97, 0, 0, 0, 0};
    private static final short[] fadeTable = WavInputStream.calculateFadeTable();
    private IBXM ibxm;
    private int[] mixBuf;
    private byte[] outBuf;
    private int outIdx;
    private int outLen;
    private int remain;
    private int fadeLen;

    public WavInputStream(IBXM ibxm) {
        this(ibxm, ibxm.calculateSongDuration(), false);
    }

    public WavInputStream(IBXM ibxm, int duration, boolean fadeOut) {
        this.ibxm = ibxm;
        this.mixBuf = new int[ibxm.getMixBufferLength()];
        this.outBuf = new byte[this.mixBuf.length * 4];
        int dataLen = duration * 4;
        int samplingRate = ibxm.getSampleRate();
        System.arraycopy(header, 0, this.outBuf, 0, header.length);
        WavInputStream.writeInt32(this.outBuf, 4, dataLen + 36);
        WavInputStream.writeInt32(this.outBuf, 24, samplingRate);
        WavInputStream.writeInt32(this.outBuf, 28, samplingRate * 4);
        WavInputStream.writeInt32(this.outBuf, 40, dataLen);
        this.outIdx = 0;
        this.outLen = header.length;
        this.remain = header.length + dataLen;
        if (fadeOut) {
            this.fadeLen = samplingRate * 32;
        }
    }

    public int getBytesRemaining() {
        return this.remain;
    }

    @Override
    public int read() {
        int out = -1;
        if (this.remain > 0) {
            out = this.outBuf[this.outIdx++];
            if (this.outIdx >= this.outLen) {
                this.getAudio();
            }
            --this.remain;
        }
        return out;
    }

    @Override
    public int read(byte[] buf, int off, int len) {
        int count = -1;
        if (this.remain > 0) {
            int outRem;
            count = this.remain;
            if (count > len) {
                count = len;
            }
            if (count > (outRem = this.outLen - this.outIdx)) {
                count = outRem;
            }
            System.arraycopy(this.outBuf, this.outIdx, buf, off, count);
            this.outIdx += count;
            if (this.outIdx >= this.outLen) {
                this.getAudio();
            }
            this.remain -= count;
        }
        return count;
    }

    private void getAudio() {
        int mEnd = this.ibxm.getAudio(this.mixBuf) * 2;
        if (this.remain < this.fadeLen) {
            short gain = fadeTable[(this.fadeLen - this.remain) * fadeTable.length / this.fadeLen];
            boolean oIdx = false;
            for (int mIdx = 0; mIdx < mEnd; ++mIdx) {
                this.mixBuf[mIdx] = this.mixBuf[mIdx] * gain >> 15;
            }
        }
        int oIdx = 0;
        for (int mIdx = 0; mIdx < mEnd; ++mIdx) {
            int ampl = this.mixBuf[mIdx];
            if (ampl > Short.MAX_VALUE) {
                ampl = Short.MAX_VALUE;
            }
            if (ampl < Short.MIN_VALUE) {
                ampl = Short.MIN_VALUE;
            }
            this.outBuf[oIdx++] = (byte)ampl;
            this.outBuf[oIdx++] = (byte)(ampl >> 8);
        }
        this.outIdx = 0;
        this.outLen = mEnd * 2;
    }

    private static short[] calculateFadeTable() {
        short[] table = new short[64];
        int dx = 32768 / table.length;
        int x = 32768 - dx;
        table[0] = Short.MAX_VALUE;
        for (int idx = 1; idx < table.length; ++idx) {
            int y = (x * x >> 15) * x >> 15;
            table[idx] = (short)y;
            x -= dx;
        }
        return table;
    }

    private static void writeInt32(byte[] buf, int idx, int value) {
        buf[idx] = (byte)value;
        buf[idx + 1] = (byte)(value >> 8);
        buf[idx + 2] = (byte)(value >> 16);
        buf[idx + 3] = (byte)(value >> 24);
    }

    public static void main(String[] args) throws IOException {
        int count;
        int len;
        File modFile = null;
        File wavFile = null;
        int interpolation = 1;
        if (args.length == 3 && "int=nearest".equals(args[0])) {
            interpolation = 0;
            modFile = new File(args[1]);
            wavFile = new File(args[2]);
        } else if (args.length == 3 && "int=sinc".equals(args[0])) {
            interpolation = 2;
            modFile = new File(args[1]);
            wavFile = new File(args[2]);
        } else if (args.length == 2) {
            modFile = new File(args[0]);
            wavFile = new File(args[1]);
        } else {
            System.err.println("Mod to Wav converter for IBXM a61 (c)2011 mumart@gmail.com");
            System.err.println("Usage: java " + WavInputStream.class.getName() + " [int=nearest|sinc] modfile wavfile");
            System.exit(1);
        }
        byte[] buf = new byte[(int)modFile.length()];
        InputStream in = new FileInputStream(modFile);
        for (int idx = 0; idx < buf.length; idx += len) {
            len = in.read(buf, idx, buf.length - idx);
            if (len >= 0) continue;
            throw new IOException("Unexpected end of file.");
        }
        in.close();
        FileOutputStream out = new FileOutputStream(wavFile);
        IBXM ibxm = new IBXM(new Module(buf), 48000);
        ibxm.setInterpolation(interpolation);
        in = new WavInputStream(ibxm);
        buf = new byte[ibxm.getMixBufferLength() * 4];
        for (int remain = ((WavInputStream)in).getBytesRemaining(); remain > 0; remain -= count) {
            count = remain > buf.length ? buf.length : remain;
            count = in.read(buf, 0, count);
            ((OutputStream)out).write(buf, 0, count);
        }
        ((OutputStream)out).close();
    }
}

