/*
 * Decompiled with CFR 0.152.
 */
package de.malban.web.google;

import de.malban.Global;
import de.malban.config.Configuration;
import de.malban.gui.CSAMainFrame;
import de.malban.gui.components.ModalInternalFrame;
import de.malban.util.UtilityImage;
import de.malban.util.UtilityString;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Proxy;
import java.net.URL;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.text.html.HTMLDocument;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.DefaultHttpClient;

public class ImageSearch
extends JPanel {
    DefaultHttpClient httpclient = null;
    ResultString mPage = new ResultString();
    HttpResponse response;
    HttpEntity entity;
    List<Cookie> cookies;
    String setBaseUrl = "";
    String setProtocoll = "";
    String setPostCommands = "";
    String mSUrl = "";
    boolean randomOnly = false;
    ModalInternalFrame modelDialog;
    boolean mBuisy = false;
    Proxy proxy = Proxy.NO_PROXY;
    JButton selectedButton = null;
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabelBusy;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTextField jTextFieldSearch;

    public ImageSearch(boolean rndOnly) {
        this.initComponents();
        this.randomOnly = rndOnly;
        this.jLabelBusy.setVisible(false);
        if (!this.randomOnly) {
            ModalInternalFrame modal;
            CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
            this.modelDialog = modal = new ModalInternalFrame("Image search", frame.getRootPane(), (Component)frame, (Container)this, this.jButton2);
        }
    }

    public void setSearch(String text) {
        this.jTextFieldSearch.setText(text);
    }

    @Override
    public void setVisible(boolean v) {
        if (this.randomOnly) {
            return;
        }
        this.modelDialog.setVisible(v);
    }

    private void initComponents() {
        this.jTextFieldSearch = new JTextField();
        this.jLabel1 = new JLabel();
        this.jButton1 = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.jLabelBusy = new JLabel();
        this.jButton2 = new JButton();
        this.setPreferredSize(new Dimension(700, 700));
        this.jTextFieldSearch.setText("Amiga Battle Squadron");
        this.jLabel1.setText("Search string");
        this.jButton1.setText("Search");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageSearch.this.jButton1ActionPerformed(evt);
            }
        });
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jScrollPane1.setVerticalScrollBarPolicy(21);
        this.jScrollPane1.setHorizontalScrollBar(null);
        this.jScrollPane1.setPreferredSize(new Dimension(600, 600));
        this.jPanel1.setPreferredSize(new Dimension(700, 700));
        this.jPanel1.setSize(new Dimension(700, 700));
        this.jPanel1.setLayout(null);
        this.jScrollPane1.setViewportView(this.jPanel1);
        this.jLabelBusy.setText("busy");
        this.jButton2.setText("Done");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageSearch.this.jButton2ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(1, 1, 1).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldSearch, -2, 171, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelBusy).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButton2)).addComponent(this.jScrollPane1, -1, 769, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldSearch, -2, -1, -2).addComponent(this.jLabel1).addComponent(this.jButton1).addComponent(this.jLabelBusy).addComponent(this.jButton2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 722, Short.MAX_VALUE)));
    }

    void buisy(boolean b) {
        this.mBuisy = b;
        this.jLabelBusy.setVisible(this.mBuisy);
        this.jLabelBusy.invalidate();
        this.jLabelBusy.validate();
        this.jLabelBusy.repaint();
        this.jLabelBusy.paintImmediately(0, 0, this.jLabelBusy.getWidth(), this.jLabelBusy.getHeight());
        this.jPanel1.invalidate();
        this.jPanel1.validate();
        this.jPanel1.repaint();
        this.jPanel1.paintImmediately(0, 0, this.jPanel1.getWidth(), this.jPanel1.getHeight());
    }

    private void buildClient() {
        this.httpclient = new DefaultHttpClient();
        this.httpclient.getParams().setParameter("http.protocol.allow-circular-redirects", (Object)Boolean.TRUE);
    }

    void buildUrl() {
        String search = this.jTextFieldSearch.getText();
        search = UtilityString.replace(search, " ", "+");
        search = UtilityString.toXML(search);
        this.setProtocoll = "http://";
        this.setBaseUrl = "www.google.de/search?q=" + search + "&biw=2110&bih=1149&tbm=isch&source=lnms&sa=X&tbs=itp:photo,isz:m&tbm=isch&sout=1";
        this.mSUrl = this.setProtocoll + this.setBaseUrl + this.setPostCommands;
        this.httpclient.getParams().setParameter("http.useragent", (Object)"httpclient/4.02 (Java 1.6; 0;0) Java Engine");
    }

    private void doGet(HttpGet httpget) throws IOException {
        this.response = this.httpclient.execute((HttpUriRequest)httpget);
        if (this.response.getStatusLine().getStatusCode() != 200) {
            // empty if block
        }
    }

    public void setProxy(Proxy p) {
        this.proxy = p;
    }

    private void jImageClickedActionPerformed(ActionEvent evt) {
        this.selectedButton = (JButton)evt.getSource();
        this.setVisible(false);
    }

    public BufferedImage getSelectedImage() {
        if (this.selectedButton == null) {
            return null;
        }
        ImageIcon icon = (ImageIcon)this.selectedButton.getIcon();
        return UtilityImage.toBufferedImage(icon.getImage());
    }

    public BufferedImage getRandomImage() {
        this.doIt();
        Component[] c = this.jPanel1.getComponents();
        int count = c.length;
        if (c.length == 0) {
            return null;
        }
        Random ran = Global.getRand();
        int sel = ran.nextInt(count);
        this.selectedButton = (JButton)c[sel];
        ImageIcon icon = (ImageIcon)this.selectedButton.getIcon();
        return UtilityImage.toBufferedImage(icon.getImage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doIt() {
        if (this.mBuisy) {
            return;
        }
        this.buisy(true);
        try {
            if (this.httpclient == null) {
                this.buildClient();
            }
            this.buildUrl();
            HTMLDocument d = new HTMLDocument();
            d.setBase(new URL(this.setProtocoll + this.setBaseUrl));
            HttpGet httpget = new HttpGet(this.mSUrl);
            this.doGet(httpget);
            this.entity = this.response.getEntity();
            this.mPage.reset();
            this.response.getEntity().writeTo((OutputStream)this.mPage);
            Thread thread = Thread.currentThread();
            synchronized (thread) {
                Thread.currentThread().wait(10L);
            }
            this.mPage.addListerner(new Listener(){

                @Override
                public void charChanged(char c) {
                    ImageSearch.this.setHTMLText(ImageSearch.this.mPage.text);
                }
            });
            this.setHTMLText(this.mPage.text);
            if (this.entity != null) {
                this.entity.consumeContent();
            }
            this.cookies = this.httpclient.getCookieStore().getCookies();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        int pos = 0;
        boolean imageUrlFound = false;
        Vector<String> urls = new Vector<String>();
        do {
            imageUrlFound = false;
            int spos = this.mPage.text.indexOf("<a href=\"/url?q", pos) + "<a href=\"/url?q".length();
            if (spos - "<a href=\"/url?q".length() == -1) continue;
            imageUrlFound = true;
            spos = this.mPage.text.indexOf("src=\"", spos) + "src=\"".length();
            int epos = this.mPage.text.indexOf("\"", spos);
            String oneUrl = this.mPage.text.substring(spos, epos);
            urls.addElement(oneUrl);
            pos = epos + 1;
        } while (imageUrlFound);
        int x = 0;
        int y = 0;
        int maxH = 0;
        this.jPanel1.removeAll();
        for (int i = 0; i < urls.size(); ++i) {
            String urlS = (String)urls.elementAt(i);
            try {
                BufferedInputStream in = new BufferedInputStream(new URL(urlS).openConnection(this.proxy).getInputStream());
                BufferedImage currentImage = ImageIO.read(in);
                while (((Image)currentImage).getHeight(null) == -1) {
                }
                ImageIcon icon = new ImageIcon(currentImage);
                JButton label = new JButton();
                label.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        ImageSearch.this.jImageClickedActionPerformed(evt);
                    }
                });
                label.setIcon(icon);
                label.setBounds(x, y, ((Image)currentImage).getWidth(null), ((Image)currentImage).getHeight(null));
                x += icon.getIconWidth() + 5;
                if (maxH < ((Image)currentImage).getHeight(null)) {
                    maxH = ((Image)currentImage).getHeight(null);
                }
                if (x > 500) {
                    x = 0;
                    y += maxH + 5;
                    maxH = 0;
                }
                this.jPanel1.add(label);
                this.jPanel1.invalidate();
                this.jPanel1.validate();
                this.jPanel1.repaint();
                this.jPanel1.paintImmediately(0, 0, this.jPanel1.getWidth(), this.jPanel1.getHeight());
                in.close();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.jPanel1.invalidate();
        this.jPanel1.validate();
        this.jPanel1.repaint();
        this.invalidate();
        this.validate();
        this.repaint();
        this.buisy(false);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.doIt();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.modelDialog.setVisible(false);
    }

    void setHTMLText(String text) {
        String newText = text;
        int headEnd = newText.indexOf("</HEAD>");
        if (headEnd != -1) {
            newText = text.substring(headEnd + "</HEAD>".length());
        } else {
            headEnd = newText.indexOf("</head>");
            if (headEnd != -1) {
                newText = text.substring(headEnd + "</head>".length());
            }
        }
        newText = UtilityString.replace(newText, "</HTML>", "");
        newText = UtilityString.replace(newText, "</html>", "");
    }

    class ResultString
    extends OutputStream {
        private Vector<Listener> mListener = new Vector();
        public String text = "";
        public OutputStream out = this;

        ResultString() {
        }

        void reset() {
            this.text = "";
            this.mListener = new Vector();
        }

        @Override
        public void write(int b) {
            this.text = this.text + (char)b;
            this.fireCharAdded((char)b);
        }

        public void fireCharAdded(char b) {
            for (int i = 0; i < this.mListener.size(); ++i) {
                this.mListener.elementAt(i).charChanged(b);
            }
        }

        public void addListerner(Listener listener) {
            this.mListener.removeElement(listener);
            this.mListener.addElement(listener);
        }

        public void removeListerner(Listener listener) {
            this.mListener.removeElement(listener);
        }
    }

    static interface Listener {
        public void charChanged(char var1);
    }
}

