/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.TinyComboBoxButton;
import de.muntjak.tinylookandfeel.TinyComboBoxEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicComboBoxUI;

public class TinyComboBoxUI
extends BasicComboBoxUI {
    static final int COMBO_BUTTON_WIDTH = 18;
    protected boolean isDisplaySizeDirty = true;
    protected Dimension cachedDisplaySize = new Dimension(0, 0);
    private static final Insets DEFAULT_INSETS = new Insets(0, 0, 0, 0);

    public static ComponentUI createUI(JComponent c) {
        return new TinyComboBoxUI();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
    }

    @Override
    protected ComboBoxEditor createEditor() {
        return new TinyComboBoxEditor.UIResource();
    }

    @Override
    protected JButton createArrowButton() {
        TinyComboBoxButton button = new TinyComboBoxButton(this.comboBox, null, this.comboBox.isEditable(), this.currentValuePane, this.listBox);
        button.setMargin(DEFAULT_INSETS);
        button.putClientProperty("isComboBoxButton", Boolean.TRUE);
        return button;
    }

    @Override
    protected void installComponents() {
        super.installComponents();
        if (this.arrowButton != null) {
            this.arrowButton.setFocusable(false);
        }
    }

    @Override
    public PropertyChangeListener createPropertyChangeListener() {
        return new TinyPropertyChangeListener();
    }

    protected void editablePropertyChanged(PropertyChangeEvent e) {
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new TinyComboBoxLayoutManager();
    }

    protected Rectangle rectangleForCurrentValue2() {
        int width = this.comboBox.getWidth();
        int height = this.comboBox.getHeight();
        Insets insets = this.getInsets();
        int buttonSize = height - (insets.top + insets.bottom);
        if (this.arrowButton != null) {
            buttonSize = 18;
        }
        if (this.comboBox.getComponentOrientation().isLeftToRight()) {
            return new Rectangle(insets.left, insets.top, width - (insets.left + insets.right + buttonSize), height - (insets.top + insets.bottom));
        }
        return new Rectangle(insets.left + buttonSize, insets.top, width - (insets.left + insets.right + buttonSize), height - (insets.top + insets.bottom));
    }

    protected void removeListeners() {
        if (this.propertyChangeListener != null) {
            this.comboBox.removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        if (!this.isMinimumSizeDirty) {
            this.isDisplaySizeDirty = true;
            return new Dimension(this.cachedMinimumSize);
        }
        InsetsUIResource insets = Theme.comboInsets;
        Dimension size = this.getDisplaySize();
        size.width += 18;
        size.width += insets.left + insets.right;
        size.height += insets.top + insets.bottom;
        this.cachedMinimumSize.setSize(size.width, size.height);
        this.isMinimumSizeDirty = false;
        return new Dimension(this.cachedMinimumSize);
    }

    @Override
    protected Dimension getDisplaySize() {
        Object prototypeValue;
        if (!this.isDisplaySizeDirty) {
            return new Dimension(this.cachedDisplaySize);
        }
        Dimension result = new Dimension();
        DefaultListCellRenderer renderer = this.comboBox.getRenderer();
        if (renderer == null) {
            renderer = new DefaultListCellRenderer();
        }
        if ((prototypeValue = this.comboBox.getPrototypeDisplayValue()) != null) {
            result = this.getSizeForComponent(renderer.getListCellRendererComponent(this.listBox, prototypeValue, -1, false, false));
        } else {
            ComboBoxModel model = this.comboBox.getModel();
            int modelSize = model.getSize();
            if (modelSize > 0) {
                for (int i = 0; i < modelSize; ++i) {
                    Dimension d = this.getSizeForComponent(renderer.getListCellRendererComponent(this.listBox, model.getElementAt(i), -1, false, false));
                    result.width = Math.max(result.width, d.width);
                    result.height = Math.max(result.height, d.height);
                }
            } else {
                result = this.getDefaultSize();
                if (this.comboBox.isEditable()) {
                    result.width = 100;
                }
            }
        }
        if (this.comboBox.isEditable()) {
            Dimension d = this.editor.getPreferredSize();
            result.width = Math.max(result.width, d.width);
            result.height = Math.max(result.height, d.height);
        }
        this.cachedDisplaySize.setSize(result.width, result.height);
        this.isDisplaySizeDirty = false;
        return result;
    }

    @Override
    protected Dimension getSizeForComponent(Component comp) {
        this.currentValuePane.add(comp);
        comp.setFont(this.comboBox.getFont());
        Dimension d = comp.getPreferredSize();
        this.currentValuePane.remove(comp);
        return d;
    }

    public class TinyComboBoxLayoutManager
    implements LayoutManager {
        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            JComboBox cb = (JComboBox)parent;
            return parent.getPreferredSize();
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            JComboBox cb = (JComboBox)parent;
            return parent.getMinimumSize();
        }

        @Override
        public void layoutContainer(Container parent) {
            JComboBox cb = (JComboBox)parent;
            int width = cb.getWidth();
            int height = cb.getHeight();
            if (TinyComboBoxUI.this.comboBox.isEditable()) {
                if (TinyComboBoxUI.this.arrowButton != null) {
                    TinyComboBoxUI.this.arrowButton.setBounds(width - 18, 0, 18, height);
                }
                if (TinyComboBoxUI.this.editor != null) {
                    Rectangle cvb = TinyComboBoxUI.this.rectangleForCurrentValue2();
                    TinyComboBoxUI.this.editor.setBounds(cvb);
                }
            } else {
                TinyComboBoxUI.this.arrowButton.setBounds(0, 0, width, height);
            }
        }
    }

    public class TinyPropertyChangeListener
    extends BasicComboBoxUI.PropertyChangeHandler {
        public TinyPropertyChangeListener() {
            super(TinyComboBoxUI.this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            super.propertyChange(e);
            String propertyName = e.getPropertyName();
            if (propertyName.equals("editable")) {
                TinyComboBoxButton button = (TinyComboBoxButton)TinyComboBoxUI.this.arrowButton;
                button.setIconOnly(TinyComboBoxUI.this.comboBox.isEditable());
                TinyComboBoxUI.this.isMinimumSizeDirty = true;
                TinyComboBoxUI.this.isDisplaySizeDirty = true;
                TinyComboBoxUI.this.comboBox.revalidate();
            } else if (propertyName.equals("background")) {
                Color color = (Color)e.getNewValue();
                TinyComboBoxUI.this.listBox.setBackground(color);
            } else if (propertyName.equals("foreground")) {
                Color color = (Color)e.getNewValue();
                TinyComboBoxUI.this.listBox.setForeground(color);
            }
        }
    }
}

