/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.MenuItemIconFactory;
import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.TinyButtonUI;
import de.muntjak.tinylookandfeel.TinyCheckBoxIcon;
import de.muntjak.tinylookandfeel.TinyComboBoxButton;
import de.muntjak.tinylookandfeel.TinyDefaultTheme;
import de.muntjak.tinylookandfeel.TinyMenuUI;
import de.muntjak.tinylookandfeel.TinyPopupFactory;
import de.muntjak.tinylookandfeel.TinyProgressBarUI;
import de.muntjak.tinylookandfeel.TinyRadioButtonIcon;
import de.muntjak.tinylookandfeel.TinyScrollBarUI;
import de.muntjak.tinylookandfeel.TinyScrollButton;
import de.muntjak.tinylookandfeel.TinySpinnerButtonUI;
import de.muntjak.tinylookandfeel.TinyTitlePane;
import de.muntjak.tinylookandfeel.TinyUtils;
import de.muntjak.tinylookandfeel.TinyWindowButtonUI;
import de.muntjak.tinylookandfeel.borders.TinyButtonBorder;
import de.muntjak.tinylookandfeel.borders.TinyFrameBorder;
import de.muntjak.tinylookandfeel.borders.TinyInternalFrameBorder;
import de.muntjak.tinylookandfeel.borders.TinyMenuBarBorder;
import de.muntjak.tinylookandfeel.borders.TinyPopupMenuBorder;
import de.muntjak.tinylookandfeel.borders.TinyProgressBarBorder;
import de.muntjak.tinylookandfeel.borders.TinyScrollPaneBorder;
import de.muntjak.tinylookandfeel.borders.TinySpinnerBorder;
import de.muntjak.tinylookandfeel.borders.TinyTableHeaderBorder;
import de.muntjak.tinylookandfeel.borders.TinyTableHeaderRolloverBorder;
import de.muntjak.tinylookandfeel.borders.TinyTableScrollPaneBorder;
import de.muntjak.tinylookandfeel.borders.TinyTextFieldBorder;
import de.muntjak.tinylookandfeel.borders.TinyToolBarBorder;
import de.muntjak.tinylookandfeel.borders.TinyToolTipBorder;
import java.awt.Color;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Robot;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class TinyLookAndFeel
extends MetalLookAndFeel {
    public static boolean controlPanelInstantiated = false;
    public static final boolean PRINT_CACHE_SIZES = false;
    static final int MINIMUM_FRAME_WIDTH = 104;
    static final int MINIMUM_INTERNAL_FRAME_WIDTH = 32;
    public static final String VERSION_STRING = "1.4.0";
    public static final String DATE_STRING = "2009/8/25";
    private static boolean isInstalled = false;
    public static Robot ROBOT;

    @Override
    public void initialize() {
        super.initialize();
        if (!isInstalled) {
            isInstalled = true;
            this.searchDefaultTheme();
            UIManager.installLookAndFeel(new UIManager.LookAndFeelInfo("TinyLookAndFeel", "de.muntjak.tinylookandfeel.TinyLookAndFeel"));
        }
        TinyPopupFactory.install();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(TinyMenuUI.ALT_PROCESSOR);
        TinyLookAndFeel.clearAllCaches();
    }

    public static void clearAllCaches() {
        TinyTitlePane.clearCache();
        TinyInternalFrameBorder.clearCache();
        TinyButtonUI.clearCache();
        TinyCheckBoxIcon.clearCache();
        TinyComboBoxButton.clearCache();
        TinyProgressBarUI.clearCache();
        TinyRadioButtonIcon.clearCache();
        TinyScrollBarUI.clearCache();
        TinyScrollButton.clearCache();
        TinySpinnerButtonUI.clearCache();
        TinyWindowButtonUI.clearCache();
        MenuItemIconFactory.clearCache();
    }

    @Override
    public void uninitialize() {
        super.uninitialize();
        TinyPopupFactory.uninstall();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventPostProcessor(TinyMenuUI.ALT_PROCESSOR);
    }

    private void searchDefaultTheme() {
        if (controlPanelInstantiated) {
            return;
        }
        String loadedFrom = null;
        URL defaultURL = TinyLookAndFeel.class.getResource("/Default.theme");
        if (Theme.loadTheme(defaultURL)) {
            loadedFrom = defaultURL.toExternalForm();
        } else {
            defaultURL = Thread.currentThread().getContextClassLoader().getResource("Default.theme");
            if (Theme.loadTheme(defaultURL)) {
                loadedFrom = defaultURL.toExternalForm();
            } else {
                try {
                    defaultURL = new File(TinyUtils.getSystemProperty("user.home"), "Default.theme").toURI().toURL();
                    if (Theme.loadTheme(defaultURL)) {
                        loadedFrom = defaultURL.toExternalForm();
                    } else {
                        defaultURL = new File(TinyUtils.getSystemProperty("user.dir"), "Default.theme").toURI().toURL();
                        if (Theme.loadTheme(defaultURL)) {
                            loadedFrom = defaultURL.toExternalForm();
                        }
                    }
                }
                catch (MalformedURLException malformedURLException) {
                }
                catch (AccessControlException accessControlException) {
                    // empty catch block
                }
            }
        }
        String info = "TinyLaF v1.4.0\n";
        if (loadedFrom == null) {
            System.out.println(info + "'Default.theme' not found - using YQ default theme.");
        } else {
            System.out.println(info + "Theme: " + loadedFrom);
        }
    }

    @Override
    public String getID() {
        return "TinyLookAndFeel";
    }

    @Override
    public String getName() {
        return "TinyLookAndFeel";
    }

    @Override
    public String getDescription() {
        return "TinyLookAndFeel";
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return false;
    }

    @Override
    public final boolean isSupportedLookAndFeel() {
        return true;
    }

    @Override
    public boolean getSupportsWindowDecorations() {
        return true;
    }

    @Override
    protected void initClassDefaults(UIDefaults table) {
        super.initClassDefaults(table);
        table.putDefaults(new Object[]{"ButtonUI", "de.muntjak.tinylookandfeel.TinyButtonUI", "CheckBoxUI", "de.muntjak.tinylookandfeel.TinyCheckBoxUI", "TextFieldUI", "de.muntjak.tinylookandfeel.TinyTextFieldUI", "TextAreaUI", "de.muntjak.tinylookandfeel.TinyTextAreaUI", "FormattedTextFieldUI", "de.muntjak.tinylookandfeel.TinyFormattedTextFieldUI", "PasswordFieldUI", "de.muntjak.tinylookandfeel.TinyPasswordFieldUI", "EditorPaneUI", "de.muntjak.tinylookandfeel.TinyEditorPaneUI", "TextPaneUI", "de.muntjak.tinylookandfeel.TinyTextPaneUI", "SliderUI", "de.muntjak.tinylookandfeel.TinySliderUI", "SpinnerUI", "de.muntjak.tinylookandfeel.TinySpinnerUI", "ToolBarUI", "de.muntjak.tinylookandfeel.TinyToolBarUI", "ToolBarSeparatorUI", "de.muntjak.tinylookandfeel.TinyToolBarSeparatorUI", "MenuBarUI", "de.muntjak.tinylookandfeel.TinyMenuBarUI", "MenuUI", "de.muntjak.tinylookandfeel.TinyMenuUI", "MenuItemUI", "de.muntjak.tinylookandfeel.TinyMenuItemUI", "CheckBoxMenuItemUI", "de.muntjak.tinylookandfeel.TinyCheckBoxMenuItemUI", "RadioButtonMenuItemUI", "de.muntjak.tinylookandfeel.TinyRadioButtonMenuItemUI", "ScrollBarUI", "de.muntjak.tinylookandfeel.TinyScrollBarUI", "TabbedPaneUI", "de.muntjak.tinylookandfeel.TinyTabbedPaneUI", "ToggleButtonUI", "de.muntjak.tinylookandfeel.TinyButtonUI", "ScrollPaneUI", "de.muntjak.tinylookandfeel.TinyScrollPaneUI", "ProgressBarUI", "de.muntjak.tinylookandfeel.TinyProgressBarUI", "InternalFrameUI", "de.muntjak.tinylookandfeel.TinyInternalFrameUI", "RadioButtonUI", "de.muntjak.tinylookandfeel.TinyRadioButtonUI", "ComboBoxUI", "de.muntjak.tinylookandfeel.TinyComboBoxUI", "PopupMenuSeparatorUI", "de.muntjak.tinylookandfeel.TinyPopupMenuSeparatorUI", "SeparatorUI", "de.muntjak.tinylookandfeel.TinySeparatorUI", "SplitPaneUI", "de.muntjak.tinylookandfeel.TinySplitPaneUI", "FileChooserUI", "de.muntjak.tinylookandfeel.TinyFileChooserUI", "ListUI", "de.muntjak.tinylookandfeel.TinyListUI", "TreeUI", "de.muntjak.tinylookandfeel.TinyTreeUI", "LabelUI", "de.muntjak.tinylookandfeel.TinyLabelUI", "TableUI", "de.muntjak.tinylookandfeel.TinyTableUI", "TableHeaderUI", "de.muntjak.tinylookandfeel.TinyTableHeaderUI", "ToolTipUI", "de.muntjak.tinylookandfeel.TinyToolTipUI", "RootPaneUI", "de.muntjak.tinylookandfeel.TinyRootPaneUI", "DesktopPaneUI", "de.muntjak.tinylookandfeel.TinyDesktopPaneUI"});
    }

    @Override
    protected void createDefaultTheme() {
        TinyLookAndFeel.setCurrentTheme(new TinyDefaultTheme());
    }

    @Override
    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        AbstractBorder border = new EmptyBorder(0, 0, 0, 0);
        table.put("Button.border", new TinyButtonBorder.CompoundBorderUIResource(new TinyButtonBorder(), new BasicBorders.MarginBorder()));
        TinyTextFieldBorder textFieldBorder = new TinyTextFieldBorder();
        table.put("FormattedTextField.border", textFieldBorder);
        table.put("TextField.border", textFieldBorder);
        table.put("PasswordField.border", textFieldBorder);
        table.put("ComboBox.border", border);
        table.put("Table.scrollPaneBorder", new TinyTableScrollPaneBorder());
        table.put("TableHeader.cellBorder", new TinyTableHeaderBorder());
        table.put("TableHeader.cellRolloverBorder", new TinyTableHeaderRolloverBorder());
        table.put("Table.alternateRowColor", new ColorUIResource(228, 230, 236));
        table.put("Spinner.border", new TinySpinnerBorder());
        table.put("ProgressBar.border", new TinyProgressBarBorder());
        table.put("ToolBar.border", new TinyToolBarBorder());
        table.put("ToolTip.border", new BorderUIResource(new TinyToolTipBorder(true)));
        table.put("ToolTip.borderInactive", new BorderUIResource(new TinyToolTipBorder(false)));
        border = new TinyInternalFrameBorder();
        table.put("InternalFrame.border", border);
        table.put("InternalFrame.paletteBorder", border);
        table.put("InternalFrame.optionDialogBorder", border);
        table.put("MenuBar.border", new TinyMenuBarBorder());
        border = new EmptyBorder(2, 4, 2, 4);
        table.put("Menu.border", new EmptyBorder(2, 5, 2, 6));
        table.put("MenuItem.border", border);
        table.put("CheckBoxMenuItem.border", border);
        table.put("RadioButtonMenuItem.border", border);
        table.put("PopupMenu.border", new TinyPopupMenuBorder());
        table.put("ScrollPane.border", new TinyScrollPaneBorder());
        table.put("Slider.trackWidth", new Integer(4));
        table.put("CheckBox.border", new BasicBorders.MarginBorder());
        table.put("RadioButton.border", new BasicBorders.MarginBorder());
        table.put("RadioButton.margin", new InsetsUIResource(2, 2, 2, 2));
        table.put("CheckBox.margin", new InsetsUIResource(2, 2, 2, 2));
        table.put("SplitPane.dividerSize", new Integer(7));
        if (TinyUtils.isOSLinux()) {
            table.put("FileChooser.readOnly", Boolean.TRUE);
        }
        table.put("TabbedPane.tabInsets", new Insets(1, 6, 4, 6));
        table.put("TabbedPane.selectedTabPadInsets", new Insets(2, 2, 1, 2));
        table.put("TabbedPane.tabAreaInsets", new Insets(6, 2, 0, 0));
        table.put("TabbedPane.contentBorderInsets", new Insets(1, 1, 3, 3));
        table.put("PopupMenu.foreground", new Color(255, 0, 0));
        table.put("RootPane.colorChooserDialogBorder", TinyFrameBorder.getInstance());
        table.put("RootPane.errorDialogBorder", TinyFrameBorder.getInstance());
        table.put("RootPane.fileChooserDialogBorder", TinyFrameBorder.getInstance());
        table.put("RootPane.frameBorder", TinyFrameBorder.getInstance());
        table.put("RootPane.informationDialogBorder", TinyFrameBorder.getInstance());
        table.put("RootPane.plainDialogBorder", TinyFrameBorder.getInstance());
        table.put("RootPane.questionDialogBorder", TinyFrameBorder.getInstance());
        table.put("RootPane.warningDialogBorder", TinyFrameBorder.getInstance());
        table.put("CheckBoxMenuItem.checkIcon", MenuItemIconFactory.getCheckBoxMenuItemIcon());
        table.put("RadioButtonMenuItem.checkIcon", MenuItemIconFactory.getRadioButtonMenuItemIcon());
        table.put("Menu.arrowIcon", MenuItemIconFactory.getMenuArrowIcon());
        table.put("InternalFrame.frameTitleHeight", new Integer(25));
        table.put("InternalFrame.paletteTitleHeight", new Integer(16));
        table.put("InternalFrame.icon", TinyLookAndFeel.loadIcon("InternalFrameIcon.png"));
        table.put("Tree.expandedIcon", TinyLookAndFeel.loadIcon("TreeMinusIcon.png"));
        table.put("Tree.collapsedIcon", TinyLookAndFeel.loadIcon("TreePlusIcon.png"));
        table.put("Tree.openIcon", TinyLookAndFeel.loadIcon("TreeFolderOpenedIcon.png"));
        table.put("Tree.closedIcon", TinyLookAndFeel.loadIcon("TreeFolderClosedIcon.png"));
        table.put("Tree.leafIcon", TinyLookAndFeel.loadIcon("TreeLeafIcon.png"));
        table.put("FileView.directoryIcon", TinyLookAndFeel.loadIcon("DirectoryIcon.png"));
        table.put("FileView.computerIcon", TinyLookAndFeel.loadIcon("ComputerIcon.png"));
        table.put("FileView.fileIcon", TinyLookAndFeel.loadIcon("FileIcon.png"));
        table.put("FileView.floppyDriveIcon", TinyLookAndFeel.loadIcon("FloppyIcon.png"));
        table.put("FileView.hardDriveIcon", TinyLookAndFeel.loadIcon("HarddiskIcon.png"));
        table.put("FileChooser.detailsViewIcon", TinyLookAndFeel.loadIcon("FileDetailsIcon.png"));
        table.put("FileChooser.homeFolderIcon", TinyLookAndFeel.loadIcon("HomeFolderIcon.png"));
        table.put("FileChooser.listViewIcon", TinyLookAndFeel.loadIcon("FileListIcon.png"));
        table.put("FileChooser.newFolderIcon", TinyLookAndFeel.loadIcon("NewFolderIcon.png"));
        table.put("FileChooser.upFolderIcon", TinyLookAndFeel.loadIcon("ParentDirectoryIcon.png"));
        table.put("OptionPane.errorIcon", TinyLookAndFeel.loadIcon("ErrorIcon.png"));
        table.put("OptionPane.informationIcon", TinyLookAndFeel.loadIcon("InformationIcon.png"));
        table.put("OptionPane.warningIcon", TinyLookAndFeel.loadIcon("WarningIcon.png"));
        table.put("OptionPane.questionIcon", TinyLookAndFeel.loadIcon("QuestionIcon.png"));
    }

    public static Icon getUncolorizedSystemIcon(int index) {
        switch (index) {
            case 0: {
                return TinyLookAndFeel.loadIcon("InternalFrameIcon.png");
            }
            case 1: {
                return TinyLookAndFeel.loadIcon("TreeFolderClosedIcon.png");
            }
            case 2: {
                return TinyLookAndFeel.loadIcon("TreeFolderOpenedIcon.png");
            }
            case 3: {
                return TinyLookAndFeel.loadIcon("TreeLeafIcon.png");
            }
            case 4: {
                return TinyLookAndFeel.loadIcon("TreeMinusIcon.png");
            }
            case 5: {
                return TinyLookAndFeel.loadIcon("TreePlusIcon.png");
            }
            case 6: {
                return TinyLookAndFeel.loadIcon("ComputerIcon.png");
            }
            case 7: {
                return TinyLookAndFeel.loadIcon("FloppyIcon.png");
            }
            case 8: {
                return TinyLookAndFeel.loadIcon("HarddiskIcon.png");
            }
            case 9: {
                return TinyLookAndFeel.loadIcon("DirectoryIcon.png");
            }
            case 10: {
                return TinyLookAndFeel.loadIcon("FileIcon.png");
            }
            case 11: {
                return TinyLookAndFeel.loadIcon("ParentDirectoryIcon.png");
            }
            case 12: {
                return TinyLookAndFeel.loadIcon("HomeFolderIcon.png");
            }
            case 13: {
                return TinyLookAndFeel.loadIcon("NewFolderIcon.png");
            }
            case 14: {
                return TinyLookAndFeel.loadIcon("FileListIcon.png");
            }
            case 15: {
                return TinyLookAndFeel.loadIcon("FileDetailsIcon.png");
            }
            case 16: {
                return TinyLookAndFeel.loadIcon("InformationIcon.png");
            }
            case 17: {
                return TinyLookAndFeel.loadIcon("QuestionIcon.png");
            }
            case 18: {
                return TinyLookAndFeel.loadIcon("WarningIcon.png");
            }
        }
        return TinyLookAndFeel.loadIcon("ErrorIcon.png");
    }

    public static String getSystemIconName(int index) {
        switch (index) {
            case 0: {
                return "InternalFrame.icon";
            }
            case 1: {
                return "Tree.closedIcon";
            }
            case 2: {
                return "Tree.openIcon";
            }
            case 3: {
                return "Tree.leafIcon";
            }
            case 4: {
                return "Tree.expandedIcon";
            }
            case 5: {
                return "Tree.collapsedIcon";
            }
            case 6: {
                return "FileView.computerIcon";
            }
            case 7: {
                return "FileView.floppyDriveIcon";
            }
            case 8: {
                return "FileView.hardDriveIcon";
            }
            case 9: {
                return "FileView.directoryIcon";
            }
            case 10: {
                return "FileView.fileIcon";
            }
            case 11: {
                return "FileChooser.upFolderIcon";
            }
            case 12: {
                return "FileChooser.homeFolderIcon";
            }
            case 13: {
                return "FileChooser.newFolderIcon";
            }
            case 14: {
                return "FileChooser.listViewIcon";
            }
            case 15: {
                return "FileChooser.detailsViewIcon";
            }
            case 16: {
                return "OptionPane.informationIcon";
            }
            case 17: {
                return "OptionPane.questionIcon";
            }
            case 18: {
                return "OptionPane.warningIcon";
            }
        }
        return "OptionPane.errorIcon";
    }

    public static ImageIcon loadIcon(String fileName) {
        URL url = null;
        url = fileName.indexOf("/") != -1 ? Thread.currentThread().getContextClassLoader().getResource("de/muntjak/tinylookandfeel/" + fileName) : Thread.currentThread().getContextClassLoader().getResource("de/muntjak/tinylookandfeel/icons/" + fileName);
        if (url == null && (url = fileName.indexOf("/") != -1 ? TinyLookAndFeel.class.getResource("/de/muntjak/tinylookandfeel/" + fileName) : TinyLookAndFeel.class.getResource("/de/muntjak/tinylookandfeel/icons/" + fileName)) == null) {
            System.err.println("TinyLaF: Icon directory could not be resolved. fileName argument:\"" + fileName + "\"");
            return null;
        }
        return new ImageIcon(url);
    }

    static {
        if (ROBOT == null) {
            try {
                ROBOT = new Robot();
            }
            catch (Exception ignore) {
                ROBOT = null;
            }
        }
    }
}

