/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.TinyLookAndFeel;
import de.muntjak.tinylookandfeel.TinyScrollButton;
import de.muntjak.tinylookandfeel.util.ColorRoutines;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class TinyScrollBarUI
extends BasicScrollBarUI {
    private static final HashMap cache = new HashMap();
    static final int ALPHA = 92;
    protected boolean isRollover = false;
    protected boolean wasRollover = false;
    private boolean freeStanding = false;
    private int scrollBarWidth;
    private boolean buttonsEnabled = true;

    public static void clearCache() {
        cache.clear();
    }

    private void calculateButtonsEnabled() {
        float extent = this.scrollbar.getVisibleAmount();
        float range = this.scrollbar.getMaximum() - this.scrollbar.getMinimum();
        this.buttonsEnabled = range > extent;
    }

    @Override
    protected void layoutVScrollbar(JScrollBar sb) {
        super.layoutVScrollbar(sb);
        this.calculateButtonsEnabled();
    }

    @Override
    protected void layoutHScrollbar(JScrollBar sb) {
        super.layoutHScrollbar(sb);
        this.calculateButtonsEnabled();
    }

    @Override
    protected void installDefaults() {
        this.scrollBarWidth = Theme.scrollSize.getValue();
        super.installDefaults();
        this.scrollbar.setBorder(null);
        this.minimumThumbSize = new Dimension(17, 17);
    }

    public static ComponentUI createUI(JComponent c) {
        return new TinyScrollBarUI();
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        return new TinyScrollButton(orientation, this);
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        return new TinyScrollButton(orientation, this);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        if (this.scrollbar.getOrientation() == 1) {
            return new Dimension(this.scrollBarWidth, this.scrollBarWidth * 3 + 10);
        }
        return new Dimension(this.scrollBarWidth * 3 + 10, this.scrollBarWidth);
    }

    @Override
    public void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        this.drawXpTrack(g, trackBounds);
    }

    private void drawXpTrack(Graphics g, Rectangle t) {
        if (this.isThumbVisible()) {
            g.setColor(Theme.scrollTrackColor.getColor());
            g.fillRect(t.x, t.y, t.width, t.height);
            g.setColor(Theme.scrollTrackBorderColor.getColor());
        } else {
            g.setColor(Theme.scrollTrackDisabledColor.getColor());
            g.fillRect(t.x, t.y, t.width, t.height);
            g.setColor(Theme.scrollTrackBorderDisabledColor.getColor());
        }
        if (this.scrollbar.getOrientation() == 1) {
            g.drawLine(t.x, t.y, t.x, t.y + t.height - 1);
            g.drawLine(t.x + t.width - 1, t.y, t.x + t.width - 1, t.y + t.height - 1);
        } else {
            g.drawLine(t.x, t.y, t.x + t.width - 1, t.y);
            g.drawLine(t.x, t.y + t.height - 1, t.x + t.width - 1, t.y + t.height - 1);
        }
    }

    @Override
    public void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        if (thumbBounds.isEmpty() || !this.scrollbar.isEnabled()) {
            return;
        }
        if (TinyLookAndFeel.controlPanelInstantiated) {
            this.drawXpThumbNoCache(g, c, thumbBounds);
        } else {
            this.drawXpThumb(g, c, thumbBounds);
        }
    }

    private void drawXpThumb(Graphics g, JComponent comp, Rectangle t) {
        int spread1 = Theme.scrollSpreadLight.getValue();
        int spread2 = Theme.scrollSpreadDark.getValue();
        ColorUIResource c = null;
        c = this.isDragging && this.isRollover ? Theme.scrollThumbPressedColor.getColor() : (this.isRollover && Theme.scrollRollover.getValue() ? Theme.scrollThumbRolloverColor.getColor() : Theme.scrollThumbColor.getColor());
        ThumbKey key = new ThumbKey(c, spread1, spread2, this.scrollbar.getOrientation() == 1, t.getSize());
        Object value = cache.get(key);
        if (value != null) {
            g.drawImage((Image)value, t.x, t.y, comp);
            return;
        }
        BufferedImage img = new BufferedImage(t.width, t.height, 2);
        Graphics imgGraphics = ((Image)img).getGraphics();
        imgGraphics.setColor(c);
        int x1 = 0;
        int y1 = 0;
        int x2 = t.width - 1;
        int y2 = t.height - 1;
        float spreadStep1 = 10.0f * (float)spread1 / 10.0f;
        float spreadStep2 = 10.0f * (float)spread2 / 10.0f;
        switch (this.scrollbar.getOrientation()) {
            case 1: {
                int yd;
                int h = t.width - 2;
                int halfY = t.width * 3 / 8;
                for (int y = 1; y < h; ++y) {
                    if (y < halfY) {
                        yd = halfY - y;
                        imgGraphics.setColor(ColorRoutines.lighten(c, (int)((float)yd * spreadStep1)));
                    } else if (y == halfY) {
                        imgGraphics.setColor(c);
                    } else {
                        yd = y - halfY;
                        imgGraphics.setColor(ColorRoutines.darken(c, (int)((float)yd * spreadStep2)));
                    }
                    imgGraphics.drawLine(x1 + y, y1 + 2, x1 + y, y2 - 1);
                }
                imgGraphics.setColor(Theme.scrollBorderLightColor.getColor());
                imgGraphics.drawLine(x1 + 3, y1 + 1, x1 + t.width - 3, y1 + 1);
                imgGraphics.drawLine(x1 + t.width - 2, y1 + 2, x1 + t.width - 2, y2 - 2);
                imgGraphics.setColor(Theme.scrollBorderColor.getColor());
                imgGraphics.drawRect(x1 + 1, y1, x1 + t.width - 2, y2 - y1);
                ColorUIResource a = Theme.scrollBorderColor.getColor();
                imgGraphics.setColor(new Color(a.getRed(), a.getGreen(), a.getBlue(), 92));
                imgGraphics.drawLine(x1 + 2, y1 + 1, x1 + 2, y1 + 1);
                imgGraphics.drawLine(x1 + t.width - 2, y1 + 1, x1 + t.width - 2, y1 + 1);
                imgGraphics.drawLine(x1 + 2, y2 - 1, x1 + 2, y2 - 1);
                imgGraphics.drawLine(x1 + t.width - 2, y2 - 1, x1 + t.width - 2, y2 - 1);
                a = Theme.scrollBorderLightColor.getColor();
                imgGraphics.setColor(new Color(a.getRed(), a.getGreen(), a.getBlue(), 92));
                imgGraphics.drawLine(x1 + 1, y1, x1 + 1, y1);
                imgGraphics.drawLine(x1 + t.width - 1, y1, x1 + t.width - 1, y1);
                imgGraphics.drawLine(x1 + 1, y2, x1 + 1, y2);
                imgGraphics.drawLine(x1 + t.width - 1, y2, x1 + t.width - 1, y2);
                break;
            }
            case 0: {
                int yd;
                int h = t.height - 2;
                int halfY = t.height * 3 / 8;
                for (int y = 1; y < h; ++y) {
                    if (y < halfY) {
                        yd = halfY - y;
                        imgGraphics.setColor(ColorRoutines.lighten(c, (int)((float)yd * spreadStep1)));
                    } else if (y == halfY) {
                        imgGraphics.setColor(c);
                    } else {
                        yd = y - halfY;
                        imgGraphics.setColor(ColorRoutines.darken(c, (int)((float)yd * spreadStep2)));
                    }
                    imgGraphics.drawLine(x1 + 1, y1 + y, x2 - 2, y1 + y);
                }
                imgGraphics.setColor(Theme.scrollBorderLightColor.getColor());
                imgGraphics.drawLine(x1 + 2, y1 + t.height - 2, x2 - 2, y1 + t.height - 2);
                imgGraphics.drawLine(x2 - 1, y1 + 3, x2 - 1, y1 + 14);
                imgGraphics.setColor(Theme.scrollBorderColor.getColor());
                imgGraphics.drawRect(x1, y1 + 1, x2 - x1, y1 + t.height - 2);
                imgGraphics.setColor(Theme.scrollTrackBorderColor.getColor());
                imgGraphics.drawLine(x1, y1, x2, y1);
                ColorUIResource a = Theme.scrollBorderColor.getColor();
                imgGraphics.setColor(new Color(a.getRed(), a.getGreen(), a.getBlue(), 92));
                imgGraphics.drawLine(x1 + 1, y1 + 2, x1 + 1, y1 + 2);
                imgGraphics.drawLine(x1 + 1, y1 + t.height - 2, x1 + 1, y1 + t.height - 2);
                imgGraphics.drawLine(x2 - 1, y1 + 2, x2 - 1, y1 + 2);
                imgGraphics.drawLine(x2 - 1, y1 + t.height - 2, x2 - 1, y1 + t.height - 2);
                a = Theme.scrollBorderLightColor.getColor();
                imgGraphics.setColor(new Color(a.getRed(), a.getGreen(), a.getBlue(), 92));
                imgGraphics.drawLine(x1, y1 + 1, x1, y1 + 1);
                imgGraphics.drawLine(x1, y1 + t.height - 1, x1, y1 + t.height - 1);
                imgGraphics.drawLine(x2, y1 + 1, x2, y1 + 1);
                imgGraphics.drawLine(x2, y1 + t.height - 1, x2, y1 + t.height - 1);
            }
        }
        if (t.height < 13) {
            return;
        }
        if (this.scrollbar.getOrientation() == 1) {
            int y;
            y1 = t.height / 2 - 4;
            y2 = Math.min(y1 + 8, t.height - 3);
            x1 = t.width / 4 + 1;
            x2 = t.width - t.width / 4 - 2;
            imgGraphics.setColor(ColorRoutines.getAdjustedColor(c, Theme.scrollGripLightColor.getSaturation(), Theme.scrollGripLightColor.getBrightness()));
            for (y = y1 + 1; y < y2; y += 2) {
                imgGraphics.drawLine(x1, y, x2, y);
            }
            x1 = t.width / 4 + 2;
            x2 = t.width - t.width / 4 - 1;
            imgGraphics.setColor(ColorRoutines.getAdjustedColor(c, Theme.scrollGripDarkColor.getSaturation(), Theme.scrollGripDarkColor.getBrightness()));
            for (y = y1; y < y2; y += 2) {
                imgGraphics.drawLine(x1, y, x2, y);
            }
        } else {
            int x;
            x1 = t.width / 2 - 4;
            x2 = Math.min(x1 + 8, t.width - 3);
            y1 = t.height / 4 + 1;
            y2 = t.height - t.height / 4 - 2;
            imgGraphics.setColor(ColorRoutines.getAdjustedColor(c, Theme.scrollGripLightColor.getSaturation(), Theme.scrollGripLightColor.getBrightness()));
            for (x = x1 + 1; x < x2; x += 2) {
                imgGraphics.drawLine(x, y1, x, y2);
            }
            y1 = t.height / 4 + 2;
            y2 = t.height - t.height / 4 - 1;
            imgGraphics.setColor(ColorRoutines.getAdjustedColor(c, Theme.scrollGripDarkColor.getSaturation(), Theme.scrollGripDarkColor.getBrightness()));
            for (x = x1; x < x2; x += 2) {
                imgGraphics.drawLine(x, y1, x, y2);
            }
        }
        imgGraphics.dispose();
        g.drawImage(img, t.x, t.y, comp);
        cache.put(key, img);
    }

    private void drawXpThumbNoCache(Graphics g, JComponent comp, Rectangle t) {
        ColorUIResource c = null;
        c = this.isDragging && this.isRollover ? Theme.scrollThumbPressedColor.getColor() : (this.isRollover && Theme.scrollRollover.getValue() ? Theme.scrollThumbRolloverColor.getColor() : Theme.scrollThumbColor.getColor());
        g.setColor(c);
        int x2 = t.x + t.width - 1;
        int y2 = t.y + t.height - 1;
        int spread1 = Theme.scrollSpreadLight.getValue();
        int spread2 = Theme.scrollSpreadDark.getValue();
        float spreadStep1 = 10.0f * (float)spread1 / 10.0f;
        float spreadStep2 = 10.0f * (float)spread2 / 10.0f;
        switch (this.scrollbar.getOrientation()) {
            case 1: {
                int yd;
                int h = t.width - 2;
                int halfY = t.width * 3 / 8;
                for (int y = 1; y < h; ++y) {
                    if (y < halfY) {
                        yd = halfY - y;
                        g.setColor(ColorRoutines.lighten(c, (int)((float)yd * spreadStep1)));
                    } else if (y == halfY) {
                        g.setColor(c);
                    } else {
                        yd = y - halfY;
                        g.setColor(ColorRoutines.darken(c, (int)((float)yd * spreadStep2)));
                    }
                    g.drawLine(t.x + y, t.y + 2, t.x + y, y2 - 1);
                }
                g.setColor(Theme.scrollBorderLightColor.getColor());
                g.drawLine(t.x + 3, t.y + 1, t.x + t.width - 3, t.y + 1);
                g.drawLine(t.x + t.width - 2, t.y + 2, t.x + t.width - 2, y2 - 2);
                g.setColor(Theme.scrollBorderColor.getColor());
                g.drawRect(t.x + 1, t.y, t.x + t.width - 2, y2 - t.y);
                ColorUIResource a = Theme.scrollBorderColor.getColor();
                g.setColor(new Color(a.getRed(), a.getGreen(), a.getBlue(), 92));
                g.drawLine(t.x + 2, t.y + 1, t.x + 2, t.y + 1);
                g.drawLine(t.x + t.width - 2, t.y + 1, t.x + t.width - 2, t.y + 1);
                g.drawLine(t.x + 2, y2 - 1, t.x + 2, y2 - 1);
                g.drawLine(t.x + t.width - 2, y2 - 1, t.x + t.width - 2, y2 - 1);
                a = Theme.scrollBorderLightColor.getColor();
                g.setColor(new Color(a.getRed(), a.getGreen(), a.getBlue(), 92));
                g.drawLine(t.x + 1, t.y, t.x + 1, t.y);
                g.drawLine(t.x + t.width - 1, t.y, t.x + t.width - 1, t.y);
                g.drawLine(t.x + 1, y2, t.x + 1, y2);
                g.drawLine(t.x + t.width - 1, y2, t.x + t.width - 1, y2);
                break;
            }
            case 0: {
                int yd;
                int h = t.height - 2;
                int halfY = t.height * 3 / 8;
                for (int y = 1; y < h; ++y) {
                    if (y < halfY) {
                        yd = halfY - y;
                        g.setColor(ColorRoutines.lighten(c, (int)((float)yd * spreadStep1)));
                    } else if (y == halfY) {
                        g.setColor(c);
                    } else {
                        yd = y - halfY;
                        g.setColor(ColorRoutines.darken(c, (int)((float)yd * spreadStep2)));
                    }
                    g.drawLine(t.x + 1, t.y + y, x2 - 2, t.y + y);
                }
                g.setColor(Theme.scrollBorderLightColor.getColor());
                g.drawLine(t.x + 2, t.y + t.height - 2, x2 - 2, t.y + t.height - 2);
                g.drawLine(x2 - 1, t.y + 3, x2 - 1, t.y + 14);
                g.setColor(Theme.scrollBorderColor.getColor());
                g.drawRect(t.x, t.y + 1, x2 - t.x, t.y + t.height - 2);
                g.setColor(Theme.scrollTrackBorderColor.getColor());
                g.drawLine(t.x, t.y, x2, t.y);
                ColorUIResource a = Theme.scrollBorderColor.getColor();
                g.setColor(new Color(a.getRed(), a.getGreen(), a.getBlue(), 92));
                g.drawLine(t.x + 1, t.y + 2, t.x + 1, t.y + 2);
                g.drawLine(t.x + 1, t.y + t.height - 2, t.x + 1, t.y + t.height - 2);
                g.drawLine(x2 - 1, t.y + 2, x2 - 1, t.y + 2);
                g.drawLine(x2 - 1, t.y + t.height - 2, x2 - 1, t.y + t.height - 2);
                a = Theme.scrollBorderLightColor.getColor();
                g.setColor(new Color(a.getRed(), a.getGreen(), a.getBlue(), 92));
                g.drawLine(t.x, t.y + 1, t.x, t.y + 1);
                g.drawLine(t.x, t.y + t.height - 1, t.x, t.y + t.height - 1);
                g.drawLine(x2, t.y + 1, x2, t.y + 1);
                g.drawLine(x2, t.y + t.height - 1, x2, t.y + t.height - 1);
            }
        }
        if (t.height < 13) {
            return;
        }
        if (this.scrollbar.getOrientation() == 1) {
            int y;
            int y1 = t.y + t.height / 2 - 4;
            y2 = Math.min(y1 + 8, t.y + t.height - 3);
            int x1 = t.x + t.width / 4 + 1;
            x2 = t.x + t.width - t.width / 4 - 2;
            g.setColor(ColorRoutines.getAdjustedColor(c, Theme.scrollGripLightColor.getSaturation(), Theme.scrollGripLightColor.getBrightness()));
            for (y = y1 + 1; y < y2; y += 2) {
                g.drawLine(x1, y, x2, y);
            }
            x1 = t.x + t.width / 4 + 2;
            x2 = t.x + t.width - t.width / 4 - 1;
            g.setColor(ColorRoutines.getAdjustedColor(c, Theme.scrollGripDarkColor.getSaturation(), Theme.scrollGripDarkColor.getBrightness()));
            for (y = y1; y < y2; y += 2) {
                g.drawLine(x1, y, x2, y);
            }
        } else {
            int x;
            int x1 = t.x + t.width / 2 - 4;
            x2 = Math.min(x1 + 8, t.x + t.width - 3);
            int y1 = t.y + t.height / 4 + 1;
            y2 = t.y + t.height - t.height / 4 - 2;
            g.setColor(ColorRoutines.getAdjustedColor(c, Theme.scrollGripLightColor.getSaturation(), Theme.scrollGripLightColor.getBrightness()));
            for (x = x1 + 1; x < x2; x += 2) {
                g.drawLine(x, y1, x, y2);
            }
            y1 = t.y + t.height / 4 + 2;
            y2 = t.y + t.height - t.height / 4 - 1;
            g.setColor(ColorRoutines.getAdjustedColor(c, Theme.scrollGripDarkColor.getSaturation(), Theme.scrollGripDarkColor.getBrightness()));
            for (x = x1; x < x2; x += 2) {
                g.drawLine(x, y1, x, y2);
            }
        }
    }

    public boolean isThumbVisible() {
        return this.buttonsEnabled;
    }

    @Override
    protected BasicScrollBarUI.TrackListener createTrackListener() {
        return new MyTrackListener();
    }

    private static class ThumbKey {
        private Color c;
        private int spread1;
        private int spread2;
        private Dimension size;
        private boolean vertical;

        ThumbKey(Color c, int spread1, int spread2, boolean vertical, Dimension size) {
            this.c = c;
            this.spread1 = spread1;
            this.spread2 = spread2;
            this.vertical = vertical;
            this.size = size;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof ThumbKey)) {
                return false;
            }
            ThumbKey other = (ThumbKey)o;
            return this.spread1 == other.spread1 && this.spread2 == other.spread2 && this.vertical == other.vertical && this.size.equals(other.size) && this.c.equals(other.c);
        }

        public int hashCode() {
            return this.c.hashCode() * this.size.hashCode() * (this.vertical ? 1 : 2) * this.spread1 * this.spread2;
        }
    }

    protected class OrientationChangeListener
    implements PropertyChangeListener {
        protected OrientationChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            Integer orient = (Integer)e.getNewValue();
            if (TinyScrollBarUI.this.scrollbar.getComponentOrientation().isLeftToRight()) {
                if (TinyScrollBarUI.this.incrButton instanceof TinyScrollButton) {
                    ((TinyScrollButton)TinyScrollBarUI.this.incrButton).setDirection(orient == 0 ? 3 : 5);
                }
                if (TinyScrollBarUI.this.decrButton instanceof TinyScrollButton) {
                    ((TinyScrollButton)TinyScrollBarUI.this.decrButton).setDirection(orient == 0 ? 7 : 1);
                }
            } else {
                if (TinyScrollBarUI.this.incrButton instanceof TinyScrollButton) {
                    ((TinyScrollButton)TinyScrollBarUI.this.incrButton).setDirection(orient == 0 ? 7 : 5);
                }
                if (TinyScrollBarUI.this.decrButton instanceof TinyScrollButton) {
                    ((TinyScrollButton)TinyScrollBarUI.this.decrButton).setDirection(orient == 0 ? 3 : 1);
                }
            }
        }
    }

    protected class MyTrackListener
    extends BasicScrollBarUI.TrackListener {
        protected MyTrackListener() {
            super(TinyScrollBarUI.this);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            TinyScrollBarUI.this.scrollbar.repaint();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            TinyScrollBarUI.this.scrollbar.repaint();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            TinyScrollBarUI.this.isRollover = false;
            TinyScrollBarUI.this.wasRollover = false;
            if (TinyScrollBarUI.this.getThumbBounds().contains(e.getPoint())) {
                TinyScrollBarUI.this.wasRollover = TinyScrollBarUI.this.isRollover = true;
                TinyScrollBarUI.this.scrollbar.repaint();
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            TinyScrollBarUI.this.isRollover = false;
            if (TinyScrollBarUI.this.isRollover != TinyScrollBarUI.this.wasRollover) {
                TinyScrollBarUI.this.wasRollover = TinyScrollBarUI.this.isRollover;
                TinyScrollBarUI.this.scrollbar.repaint();
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (TinyScrollBarUI.this.getThumbBounds().contains(e.getPoint())) {
                TinyScrollBarUI.this.isDragging = true;
            }
            super.mouseDragged(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (TinyScrollBarUI.this.getThumbBounds().contains(e.getPoint())) {
                TinyScrollBarUI.this.isRollover = true;
                if (TinyScrollBarUI.this.isRollover != TinyScrollBarUI.this.wasRollover) {
                    TinyScrollBarUI.this.scrollbar.repaint();
                    TinyScrollBarUI.this.wasRollover = TinyScrollBarUI.this.isRollover;
                }
            } else {
                TinyScrollBarUI.this.isRollover = false;
                if (TinyScrollBarUI.this.isRollover != TinyScrollBarUI.this.wasRollover) {
                    TinyScrollBarUI.this.scrollbar.repaint();
                    TinyScrollBarUI.this.wasRollover = TinyScrollBarUI.this.isRollover;
                }
            }
        }
    }
}

