/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.TinyLookAndFeel;
import de.muntjak.tinylookandfeel.TinyScrollBarUI;
import de.muntjak.tinylookandfeel.util.ColorRoutines;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.basic.BasicArrowButton;

public class TinyScrollButton
extends BasicArrowButton {
    private static final HashMap cache = new HashMap();
    private boolean isRollover;
    private TinyScrollBarUI scrollbarUI;

    public static void clearCache() {
        cache.clear();
    }

    public TinyScrollButton(int direction, TinyScrollBarUI scrollbarUI) {
        super(direction);
        this.scrollbarUI = scrollbarUI;
        this.setBorder(null);
        this.setRolloverEnabled(true);
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setSize(this.getPreferredSize());
    }

    @Override
    public void paint(Graphics g) {
        boolean enabled = this.scrollbarUI.isThumbVisible();
        this.isRollover = false;
        ColorUIResource c = null;
        if (!enabled) {
            c = Theme.scrollButtDisabledColor.getColor();
        } else if (this.getModel().isPressed()) {
            c = Theme.scrollButtPressedColor.getColor();
        } else if (this.getModel().isRollover() && Theme.scrollRollover.getValue()) {
            c = Theme.scrollButtRolloverColor.getColor();
            this.isRollover = true;
        } else {
            c = Theme.scrollButtColor.getColor();
        }
        g.setColor(c);
        if (TinyLookAndFeel.controlPanelInstantiated) {
            this.drawXpButtonNoCache(g, this.getSize(), c);
        } else {
            this.drawXpButton(g, this.getSize(), c);
        }
        if (!enabled) {
            g.setColor(Theme.scrollArrowDisabledColor.getColor());
        } else {
            g.setColor(Theme.scrollArrowColor.getColor());
        }
        this.drawXpArrow(g, this.getSize());
    }

    private void drawXpButton(Graphics g, Dimension size, Color c) {
        boolean rollover;
        boolean pressed;
        boolean enabled = this.scrollbarUI.isThumbVisible();
        ScrollButtonKey key = new ScrollButtonKey(size, this.direction == 1 || this.direction == 5, c, pressed = this.getModel().isPressed(), enabled, rollover = this.getModel().isRollover() && Theme.scrollRollover.getValue());
        Object value = cache.get(key);
        if (value != null) {
            g.drawImage((Image)value, 0, 0, this);
            return;
        }
        BufferedImage img = new BufferedImage(size.width, size.height, 2);
        Graphics imgGraphics = ((Image)img).getGraphics();
        int h = size.height;
        int w = size.width;
        int spread1 = Theme.scrollSpreadLight.getValue();
        int spread2 = Theme.scrollSpreadDark.getValue();
        if (!enabled) {
            spread1 = Theme.scrollSpreadLightDisabled.getValue();
            spread2 = Theme.scrollSpreadDarkDisabled.getValue();
        }
        switch (this.direction) {
            case 1: 
            case 5: {
                float spreadStep1 = 10.0f * (float)spread1 / 10.0f;
                float spreadStep2 = 10.0f * (float)spread2 / 10.0f;
                int halfY = h * 3 / 8;
                for (int y = 1; y < h - 1; ++y) {
                    int yd;
                    if (y < halfY) {
                        yd = halfY - y;
                        imgGraphics.setColor(ColorRoutines.lighten(c, (int)((float)yd * spreadStep1)));
                    } else if (y == halfY) {
                        imgGraphics.setColor(c);
                    } else {
                        yd = y - halfY;
                        imgGraphics.setColor(ColorRoutines.darken(c, (int)((float)yd * spreadStep2)));
                    }
                    imgGraphics.drawLine(3, y, w - 3, y);
                }
                imgGraphics.setColor(Theme.scrollTrackBorderColor.getColor());
                imgGraphics.drawLine(0, 0, 0, h - 1);
                c = !enabled ? Theme.scrollLightDisabledColor.getColor() : Theme.scrollBorderLightColor.getColor();
                imgGraphics.setColor(c);
                imgGraphics.drawLine(2, 1, 2, h - 2);
                imgGraphics.drawLine(w - 2, 1, w - 2, h - 2);
                Color lightAlpha = new Color(c.getRed(), c.getGreen(), c.getBlue(), 92);
                c = !enabled ? Theme.scrollBorderDisabledColor.getColor() : Theme.scrollBorderColor.getColor();
                imgGraphics.setColor(c);
                imgGraphics.drawRect(1, 0, w - 2, h - 1);
                imgGraphics.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), 92));
                imgGraphics.drawLine(2, 1, 2, 1);
                imgGraphics.drawLine(w - 2, 1, w - 2, 1);
                imgGraphics.drawLine(2, h - 2, 2, h - 2);
                imgGraphics.drawLine(w - 2, h - 2, w - 2, h - 2);
                imgGraphics.setColor(lightAlpha);
                imgGraphics.drawLine(1, 0, 1, 0);
                imgGraphics.drawLine(1, h - 1, 1, h - 1);
                imgGraphics.drawLine(w - 1, 0, w - 1, 0);
                imgGraphics.drawLine(w - 1, h - 1, w - 1, h - 1);
                break;
            }
            case 3: 
            case 7: {
                float spreadStep1 = 10.0f * (float)spread1 / 10.0f;
                float spreadStep2 = 10.0f * (float)spread2 / 10.0f;
                int halfY = h / 2;
                for (int y = 1; y < w - 1; ++y) {
                    int yd;
                    if (y < halfY) {
                        yd = halfY - y;
                        imgGraphics.setColor(ColorRoutines.lighten(c, (int)((float)yd * spreadStep1)));
                    } else if (y == halfY) {
                        imgGraphics.setColor(c);
                    } else {
                        yd = y - halfY;
                        imgGraphics.setColor(ColorRoutines.darken(c, (int)((float)yd * spreadStep2)));
                    }
                    imgGraphics.drawLine(2, y + 1, w - 3, y + 1);
                }
                imgGraphics.setColor(Theme.scrollTrackBorderColor.getColor());
                imgGraphics.drawLine(0, 0, w - 1, 0);
                c = !enabled ? Theme.scrollLightDisabledColor.getColor() : Theme.scrollBorderLightColor.getColor();
                imgGraphics.setColor(c);
                imgGraphics.drawLine(1, 2, 1, h - 2);
                imgGraphics.drawLine(w - 2, 2, w - 2, h - 2);
                Color lightAlpha = new Color(c.getRed(), c.getGreen(), c.getBlue(), 92);
                c = !enabled ? Theme.scrollBorderDisabledColor.getColor() : Theme.scrollBorderColor.getColor();
                imgGraphics.setColor(c);
                imgGraphics.drawRect(0, 1, w - 1, h - 2);
                imgGraphics.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), 92));
                imgGraphics.drawLine(1, 2, 1, 2);
                imgGraphics.drawLine(w - 2, 2, w - 2, 2);
                imgGraphics.drawLine(1, h - 2, 1, h - 2);
                imgGraphics.drawLine(w - 2, h - 2, w - 2, h - 2);
                imgGraphics.setColor(lightAlpha);
                imgGraphics.drawLine(0, 1, 0, 1);
                imgGraphics.drawLine(w - 1, 1, w - 1, 1);
                imgGraphics.drawLine(0, h - 1, 0, h - 1);
                imgGraphics.drawLine(w - 1, h - 1, w - 1, h - 1);
            }
        }
        imgGraphics.dispose();
        g.drawImage(img, 0, 0, this);
        cache.put(key, img);
    }

    private void drawXpButtonNoCache(Graphics g, Dimension size, Color c) {
        boolean enabled = this.scrollbarUI.isThumbVisible();
        int h = size.height;
        int w = size.width;
        int spread1 = Theme.scrollSpreadLight.getValue();
        int spread2 = Theme.scrollSpreadDark.getValue();
        if (!enabled) {
            spread1 = Theme.scrollSpreadLightDisabled.getValue();
            spread2 = Theme.scrollSpreadDarkDisabled.getValue();
        }
        switch (this.direction) {
            case 1: 
            case 5: {
                float spreadStep1 = 10.0f * (float)spread1 / 10.0f;
                float spreadStep2 = 10.0f * (float)spread2 / 10.0f;
                int halfY = h * 3 / 8;
                for (int y = 1; y < h - 1; ++y) {
                    int yd;
                    if (y < halfY) {
                        yd = halfY - y;
                        g.setColor(ColorRoutines.lighten(c, (int)((float)yd * spreadStep1)));
                    } else if (y == halfY) {
                        g.setColor(c);
                    } else {
                        yd = y - halfY;
                        g.setColor(ColorRoutines.darken(c, (int)((float)yd * spreadStep2)));
                    }
                    g.drawLine(3, y, w - 3, y);
                }
                g.setColor(Theme.scrollTrackBorderColor.getColor());
                g.drawLine(0, 0, 0, h - 1);
                c = !enabled ? Theme.scrollLightDisabledColor.getColor() : Theme.scrollBorderLightColor.getColor();
                g.setColor(c);
                g.drawLine(2, 1, 2, h - 2);
                g.drawLine(w - 2, 1, w - 2, h - 2);
                Color lightAlpha = new Color(c.getRed(), c.getGreen(), c.getBlue(), 92);
                c = !enabled ? Theme.scrollBorderDisabledColor.getColor() : Theme.scrollBorderColor.getColor();
                g.setColor(c);
                g.drawRect(1, 0, w - 2, h - 1);
                g.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), 92));
                g.drawLine(2, 1, 2, 1);
                g.drawLine(w - 2, 1, w - 2, 1);
                g.drawLine(2, h - 2, 2, h - 2);
                g.drawLine(w - 2, h - 2, w - 2, h - 2);
                g.setColor(lightAlpha);
                g.drawLine(1, 0, 1, 0);
                g.drawLine(1, h - 1, 1, h - 1);
                g.drawLine(w - 1, 0, w - 1, 0);
                g.drawLine(w - 1, h - 1, w - 1, h - 1);
                break;
            }
            case 3: 
            case 7: {
                float spreadStep1 = 10.0f * (float)spread1 / 10.0f;
                float spreadStep2 = 10.0f * (float)spread2 / 10.0f;
                int halfY = h / 2;
                for (int y = 1; y < w - 1; ++y) {
                    int yd;
                    if (y < halfY) {
                        yd = halfY - y;
                        g.setColor(ColorRoutines.lighten(c, (int)((float)yd * spreadStep1)));
                    } else if (y == halfY) {
                        g.setColor(c);
                    } else {
                        yd = y - halfY;
                        g.setColor(ColorRoutines.darken(c, (int)((float)yd * spreadStep2)));
                    }
                    g.drawLine(2, y + 1, w - 3, y + 1);
                }
                g.setColor(Theme.scrollTrackBorderColor.getColor());
                g.drawLine(0, 0, w - 1, 0);
                c = !enabled ? Theme.scrollLightDisabledColor.getColor() : Theme.scrollBorderLightColor.getColor();
                g.setColor(c);
                g.drawLine(1, 2, 1, h - 2);
                g.drawLine(w - 2, 2, w - 2, h - 2);
                Color lightAlpha = new Color(c.getRed(), c.getGreen(), c.getBlue(), 92);
                c = !enabled ? Theme.scrollBorderDisabledColor.getColor() : Theme.scrollBorderColor.getColor();
                g.setColor(c);
                g.drawRect(0, 1, w - 1, h - 2);
                g.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), 92));
                g.drawLine(1, 2, 1, 2);
                g.drawLine(w - 2, 2, w - 2, 2);
                g.drawLine(1, h - 2, 1, h - 2);
                g.drawLine(w - 2, h - 2, w - 2, h - 2);
                g.setColor(lightAlpha);
                g.drawLine(0, 1, 0, 1);
                g.drawLine(w - 1, 1, w - 1, 1);
                g.drawLine(0, h - 1, 0, h - 1);
                g.drawLine(w - 1, h - 1, w - 1, h - 1);
            }
        }
    }

    private void drawXpArrow(Graphics g, Dimension size) {
        int x = 0;
        int y = 0;
        switch (this.direction) {
            case 1: {
                x = (size.width - 8) / 2;
                y = (size.height - 5) / 2;
                g.translate(x, y);
                g.drawLine(4, 0, 4, 0);
                g.drawLine(3, 1, 5, 1);
                g.drawLine(2, 2, 6, 2);
                g.drawLine(1, 3, 3, 3);
                g.drawLine(5, 3, 7, 3);
                g.drawLine(0, 4, 2, 4);
                g.drawLine(6, 4, 8, 4);
                g.drawLine(1, 5, 1, 5);
                g.drawLine(7, 5, 7, 5);
                break;
            }
            case 5: {
                x = (size.width - 8) / 2;
                y = (size.height - 5) / 2;
                g.translate(x, y);
                g.drawLine(1, 0, 1, 0);
                g.drawLine(7, 0, 7, 0);
                g.drawLine(0, 1, 2, 1);
                g.drawLine(6, 1, 8, 1);
                g.drawLine(1, 2, 3, 2);
                g.drawLine(5, 2, 7, 2);
                g.drawLine(2, 3, 6, 3);
                g.drawLine(3, 4, 5, 4);
                g.drawLine(4, 5, 4, 5);
                break;
            }
            case 3: {
                x = (size.width - 5) / 2;
                y = (size.height - 8) / 2;
                g.translate(x, y);
                g.drawLine(0, 1, 0, 1);
                g.drawLine(0, 7, 0, 7);
                g.drawLine(1, 0, 1, 2);
                g.drawLine(1, 6, 1, 8);
                g.drawLine(2, 1, 2, 3);
                g.drawLine(2, 5, 2, 7);
                g.drawLine(3, 2, 3, 6);
                g.drawLine(4, 3, 4, 5);
                g.drawLine(5, 4, 5, 4);
                break;
            }
            case 7: {
                x = (size.width - 5) / 2;
                y = (size.height - 8) / 2;
                g.translate(x, y);
                g.drawLine(0, 4, 0, 4);
                g.drawLine(1, 3, 1, 5);
                g.drawLine(2, 2, 2, 6);
                g.drawLine(3, 1, 3, 3);
                g.drawLine(3, 5, 3, 7);
                g.drawLine(4, 0, 4, 2);
                g.drawLine(4, 6, 4, 8);
                g.drawLine(5, 1, 5, 1);
                g.drawLine(5, 7, 5, 7);
            }
        }
        g.translate(-x, -y);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(Theme.scrollSize.getValue(), Theme.scrollSize.getValue());
    }

    private static class ScrollButtonKey {
        private Dimension size;
        private Color c;
        private boolean vertical;
        private boolean pressed;
        private boolean enabled;
        private boolean rollover;

        private ScrollButtonKey(Dimension size, boolean vertical, Color c, boolean pressed, boolean enabled, boolean rollover) {
            this.size = size;
            this.vertical = vertical;
            this.c = c;
            this.pressed = pressed;
            this.enabled = enabled;
            this.rollover = rollover;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof ScrollButtonKey)) {
                return false;
            }
            ScrollButtonKey other = (ScrollButtonKey)o;
            return this.size.equals(other.size) && this.vertical == other.vertical && this.pressed == other.pressed && this.enabled == other.enabled && this.rollover == other.rollover && this.c.equals(other.c);
        }

        public int hashCode() {
            return this.size.hashCode() * this.c.hashCode() * (this.pressed ? 1 : 2) * (this.enabled ? 4 : 8) * (this.rollover ? 16 : 32) * (this.vertical ? 64 : 128);
        }
    }
}

