/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.controlpanel.TinyTableModel;
import de.muntjak.tinylookandfeel.table.SortableTableData;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class TinyTableHeaderUI
extends BasicTableHeaderUI {
    private static final String ROLLOVER_COLUMN_KEY = "rolloverColumn";
    private static final String SORTED_COLUMN_KEY = "sortedColumn";
    private static final String SORTING_DIRECTION_KEY = "sortingDirection";
    private static final int ADD_COLUMN = 0;
    private static final int REMOVE_COLUMN = 1;
    private static final int REPLACE_COLUMN = 2;
    private static final int MINIMUM_DRAG_DISTANCE = 5;
    private static final HashMap sortingCache = new HashMap();
    private static final String DEFAULT_RENDERER_KEY = "defaultRenderer";
    protected SortableTableHandler handler;
    protected TinyTableHeaderRenderer headerRenderer;
    protected boolean rendererInstalled = false;

    public static ComponentUI createUI(JComponent header) {
        return new TinyTableHeaderUI();
    }

    @Override
    protected void installListeners() {
        SortingInformation sortingInfo;
        super.installListeners();
        this.handler = new SortableTableHandler();
        this.header.addMouseListener(this.handler);
        this.header.addMouseMotionListener(this.handler);
        this.header.getColumnModel().addColumnModelListener(this.handler);
        if (this.header.getTable() != null) {
            this.handler.getTableModel(this.header);
            this.header.getTable().addPropertyChangeListener("model", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (TinyTableHeaderUI.this.header == null) {
                        return;
                    }
                    TableModel model = (TableModel)e.getNewValue();
                    if (TinyTableHeaderUI.this.rendererInstalled && (model == null || !(model instanceof SortableTableData))) {
                        TinyTableHeaderUI.this.rendererInstalled = false;
                        TableCellRenderer defaultRenderer = (TableCellRenderer)TinyTableHeaderUI.this.header.getClientProperty(TinyTableHeaderUI.DEFAULT_RENDERER_KEY);
                        TinyTableHeaderUI.this.header.setDefaultRenderer(defaultRenderer);
                    } else if (!TinyTableHeaderUI.this.rendererInstalled && model != null && model instanceof SortableTableData) {
                        TinyTableHeaderUI.this.rendererInstalled = true;
                        TableCellRenderer defaultRenderer = (TableCellRenderer)TinyTableHeaderUI.this.header.getClientProperty(TinyTableHeaderUI.DEFAULT_RENDERER_KEY);
                        if (defaultRenderer == null) {
                            defaultRenderer = TinyTableHeaderUI.this.header.getDefaultRenderer();
                            TinyTableHeaderUI.this.header.putClientProperty(TinyTableHeaderUI.DEFAULT_RENDERER_KEY, defaultRenderer);
                        }
                        if (TinyTableHeaderUI.this.headerRenderer == null) {
                            TinyTableHeaderUI.this.headerRenderer = new TinyTableHeaderRenderer();
                        }
                        TinyTableHeaderUI.this.header.setDefaultRenderer(TinyTableHeaderUI.this.headerRenderer);
                    }
                }
            });
        }
        if ((sortingInfo = (SortingInformation)sortingCache.get(this.header)) != null) {
            this.handler.restoreSortingInformation(this.header, sortingInfo);
        }
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.handler.removeSortingInformation();
        this.header.removeMouseListener(this.handler);
        this.header.removeMouseMotionListener(this.handler);
        this.header.getColumnModel().removeColumnModelListener(this.handler);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension d = super.getPreferredSize(c);
        d.height = Math.max(16, d.height);
        return d;
    }

    public void sortColumns(int[] columns, int[] sortingDirections, JTable table) {
        if (this.handler == null) {
            return;
        }
        this.handler.sortColumns(columns, sortingDirections, table);
    }

    public void setHorizontalAlignments(int[] alignments) {
        if (this.headerRenderer == null || !this.rendererInstalled) {
            return;
        }
        if (this.handler != null) {
            if (alignments == null) {
                SortableTableHandler.access$902(this.handler, null);
            } else {
                SortableTableHandler.access$902(this.handler, new int[alignments.length]);
                System.arraycopy(alignments, 0, this.handler.alignments, 0, alignments.length);
            }
        }
        this.headerRenderer.setHorizontalAlignments(alignments);
    }

    static class TinyTableHeaderRenderer
    extends DefaultTableCellRenderer
    implements UIResource {
        private static final Icon arrowNo = new Arrow(true, -1);
        private static final Icon[][] arrows = new Icon[2][4];
        private int[] horizontalAlignments;

        public TinyTableHeaderRenderer() {
            this.setHorizontalAlignment(0);
            this.setHorizontalTextPosition(2);
        }

        public void setHorizontalAlignments(int[] alignments) {
            this.horizontalAlignments = alignments;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            LookAndFeel laf = UIManager.getLookAndFeel();
            if (laf == null || !"TinyLookAndFeel".equals(laf.getName())) {
                JTableHeader header;
                if (table != null && (header = table.getTableHeader()) != null) {
                    this.setBackground(header.getBackground());
                    this.setForeground(header.getForeground());
                    this.setFont(header.getFont());
                }
                this.setIcon(null);
                this.setText(value == null ? "" : value.toString());
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                return this;
            }
            boolean isRolloverColumn = false;
            Icon icon = arrowNo;
            int sortingDirection = 1;
            int priority = -1;
            boolean paintArrow = false;
            if (table != null) {
                int modelColumn;
                TableModel model;
                JTableHeader header = table.getTableHeader();
                if (header != null) {
                    int rolloverColumn;
                    Object o = header.getClientProperty(TinyTableHeaderUI.ROLLOVER_COLUMN_KEY);
                    if (o != null && (rolloverColumn = ((Integer)o).intValue()) == column) {
                        isRolloverColumn = true;
                    }
                    if ((o = header.getClientProperty(TinyTableHeaderUI.SORTED_COLUMN_KEY)) != null) {
                        int[] sc = (int[])o;
                        priority = -1;
                        for (int i = 0; i < sc.length; ++i) {
                            if (sc[i] != column) continue;
                            priority = i;
                        }
                        if (priority > -1) {
                            paintArrow = true;
                            o = header.getClientProperty(TinyTableHeaderUI.SORTING_DIRECTION_KEY);
                            if (o != null) {
                                int[] sd = (int[])o;
                                sortingDirection = sd[priority];
                            }
                        }
                    }
                    if (isRolloverColumn) {
                        this.setBackground(Theme.tableHeaderRolloverBackColor.getColor());
                    } else {
                        this.setBackground(header.getBackground());
                    }
                    this.setForeground(header.getForeground());
                    this.setFont(header.getFont());
                }
                if ((model = table.getModel()) instanceof SortableTableData) {
                    if (paintArrow) {
                        int pri = Math.min(3, priority);
                        if (sortingDirection == 1) {
                            if (arrows[0][pri] == null) {
                                TinyTableHeaderRenderer.arrows[0][pri] = new Arrow(false, priority);
                            }
                            icon = arrows[0][pri];
                        } else {
                            if (arrows[1][pri] == null) {
                                TinyTableHeaderRenderer.arrows[1][pri] = new Arrow(true, priority);
                            }
                            icon = arrows[1][pri];
                        }
                    } else if (column >= 0 && !((SortableTableData)((Object)model)).isColumnSortable(modelColumn = table.getColumnModel().getColumn(column).getModelIndex())) {
                        icon = null;
                    }
                } else {
                    icon = null;
                    this.setToolTipText(null);
                }
                if (column >= 0) {
                    modelColumn = table.getColumnModel().getColumn(column).getModelIndex();
                    if (this.horizontalAlignments != null && this.horizontalAlignments.length > modelColumn) {
                        this.setHorizontalAlignment(this.horizontalAlignments[modelColumn]);
                    }
                }
            }
            this.setIcon(icon);
            this.setText(value == null ? "" : value.toString());
            if (isRolloverColumn) {
                this.setBorder(UIManager.getBorder("TableHeader.cellRolloverBorder"));
            } else {
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            }
            return this;
        }

        private static class Arrow
        implements Icon {
            private static final int height = 11;
            private boolean descending;
            private int priority;

            public Arrow(boolean descending, int priority) {
                this.descending = descending;
                this.priority = Math.min(3, priority);
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                if (this.priority == -1) {
                    return;
                }
                int dx = this.priority;
                int dy = (6 + this.priority) / 2;
                g.translate(x + dx, y + dy);
                g.setColor(Theme.tableHeaderArrowColor.getColor());
                if (this.descending) {
                    switch (this.priority) {
                        case 0: {
                            g.drawLine(4, 4, 4, 4);
                            g.drawLine(3, 3, 5, 3);
                            g.drawLine(2, 2, 6, 2);
                            g.drawLine(1, 1, 7, 1);
                            g.drawLine(0, 0, 8, 0);
                            break;
                        }
                        case 1: {
                            g.drawLine(3, 3, 3, 3);
                            g.drawLine(2, 2, 4, 2);
                            g.drawLine(1, 1, 5, 1);
                            g.drawLine(0, 0, 6, 0);
                            break;
                        }
                        case 2: {
                            g.drawLine(2, 2, 2, 2);
                            g.drawLine(1, 1, 3, 1);
                            g.drawLine(0, 0, 4, 0);
                            break;
                        }
                        default: {
                            g.drawLine(1, 1, 1, 1);
                            g.drawLine(0, 0, 2, 0);
                            break;
                        }
                    }
                } else {
                    switch (this.priority) {
                        case 0: {
                            g.drawLine(4, 0, 4, 0);
                            g.drawLine(3, 1, 5, 1);
                            g.drawLine(2, 2, 6, 2);
                            g.drawLine(1, 3, 7, 3);
                            g.drawLine(0, 4, 8, 4);
                            break;
                        }
                        case 1: {
                            g.drawLine(3, 0, 3, 0);
                            g.drawLine(2, 1, 4, 1);
                            g.drawLine(1, 2, 5, 2);
                            g.drawLine(0, 3, 6, 3);
                            break;
                        }
                        case 2: {
                            g.drawLine(2, 0, 2, 0);
                            g.drawLine(1, 1, 3, 1);
                            g.drawLine(0, 2, 4, 2);
                            break;
                        }
                        default: {
                            g.drawLine(1, 0, 1, 0);
                            g.drawLine(0, 1, 2, 1);
                        }
                    }
                }
                g.translate(-(x + dx), -(y + dy));
            }

            @Override
            public int getIconWidth() {
                return 9;
            }

            @Override
            public int getIconHeight() {
                return 11;
            }
        }
    }

    private class SortableTableHandler
    implements MouseListener,
    MouseMotionListener,
    TableColumnModelListener {
        private int[] alignments;
        private int rolloverColumn = -1;
        private int pressedColumn = -1;
        private Vector sortedViewColumns = new Vector();
        private Vector sortedModelColumns = new Vector();
        private Vector sortingDirections = new Vector();
        private boolean mouseInside = false;
        private boolean mouseDragged = false;
        private boolean inDrag = false;
        private Point pressedPoint;

        private SortableTableHandler() {
        }

        void sortColumns(int[] columns, int[] directions, JTable table) {
            if (columns == null) {
                throw new IllegalArgumentException("columns argument may not be null");
            }
            if (directions == null) {
                throw new IllegalArgumentException("directions argument may not be null");
            }
            if (table == null) {
                throw new IllegalArgumentException("table argument may not be null");
            }
            if (columns.length != directions.length) {
                throw new IllegalArgumentException("columns argument and directions argument must be of equal length");
            }
            JTableHeader header = table.getTableHeader();
            SortableTableData model = this.getTableModel(header);
            if (model == null) {
                return;
            }
            this.sortedViewColumns.clear();
            this.sortedModelColumns.clear();
            this.sortingDirections.clear();
            for (int i = 0; i < columns.length; ++i) {
                this.sortedViewColumns.add(new Integer(columns[i]));
                this.sortedModelColumns.add(new Integer(this.getModelColumn(header, columns[i])));
                this.sortingDirections.add(new Integer(directions[i]));
            }
            header.putClientProperty(TinyTableHeaderUI.SORTED_COLUMN_KEY, this.vectorToIntArray(this.sortedViewColumns));
            header.putClientProperty(TinyTableHeaderUI.SORTING_DIRECTION_KEY, this.vectorToIntArray(this.sortingDirections));
            model.sortColumns(this.vectorToIntArray(this.sortedModelColumns), this.vectorToIntArray(this.sortingDirections), table);
            header.repaint();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.mouseInside = true;
            if (this.mouseDragged) {
                return;
            }
            SortableTableData model = this.getTableModel(e.getSource());
            if (model == null) {
                return;
            }
            JTableHeader header = (JTableHeader)e.getSource();
            int viewColumn = header.columnAtPoint(e.getPoint());
            int modelColumn = this.getModelColumnAt(e);
            if (!model.isColumnSortable(modelColumn)) {
                if (this.rolloverColumn != -1) {
                    this.rolloverColumn = -1;
                    header.putClientProperty(TinyTableHeaderUI.ROLLOVER_COLUMN_KEY, null);
                }
            } else {
                this.rolloverColumn = viewColumn;
                header.putClientProperty(TinyTableHeaderUI.ROLLOVER_COLUMN_KEY, new Integer(this.rolloverColumn));
            }
            header.repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.mouseInside = false;
            JTableHeader header = (JTableHeader)e.getSource();
            if (this.inDrag && header.getReorderingAllowed()) {
                return;
            }
            SortableTableData model = this.getTableModel(e.getSource());
            if (model == null) {
                return;
            }
            if (this.rolloverColumn != -1) {
                this.rolloverColumn = -1;
                header.putClientProperty(TinyTableHeaderUI.ROLLOVER_COLUMN_KEY, null);
                header.repaint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.inDrag = false;
            if (e.isPopupTrigger()) {
                return;
            }
            if (!this.mouseInside) {
                this.mouseDragged = false;
                return;
            }
            SortableTableData model = this.getTableModel(e.getSource());
            if (model == null) {
                this.mouseDragged = false;
                return;
            }
            JTableHeader header = (JTableHeader)e.getSource();
            int viewColumn = header.columnAtPoint(e.getPoint());
            if (viewColumn == -1) {
                this.mouseDragged = false;
                return;
            }
            int modelColumn = this.getModelColumnAt(e);
            if (!model.isColumnSortable(modelColumn)) {
                if (this.rolloverColumn != -1) {
                    this.rolloverColumn = -1;
                    header.putClientProperty(TinyTableHeaderUI.ROLLOVER_COLUMN_KEY, null);
                }
            } else {
                this.rolloverColumn = viewColumn;
                header.putClientProperty(TinyTableHeaderUI.ROLLOVER_COLUMN_KEY, new Integer(this.rolloverColumn));
            }
            if (this.mouseDragged) {
                this.mouseDragged = false;
                return;
            }
            if (!model.isColumnSortable(modelColumn)) {
                return;
            }
            if (this.pressedColumn != viewColumn) {
                return;
            }
            Integer vc = new Integer(viewColumn);
            if (this.sortedViewColumns.contains(vc)) {
                int index = this.sortedViewColumns.indexOf(vc);
                if (e.isAltDown()) {
                    this.sortedViewColumns.remove(index);
                    this.sortedModelColumns.remove(index);
                    this.sortingDirections.remove(index);
                } else if (e.isControlDown() && model.supportsMultiColumnSort() || this.sortedModelColumns.size() == 1) {
                    int sortingDirection = (Integer)this.sortingDirections.get(index);
                    sortingDirection = sortingDirection != 2 ? 2 : 1;
                    this.sortingDirections.remove(index);
                    this.sortingDirections.add(index, new Integer(sortingDirection));
                } else {
                    int sortingDirection = (Integer)this.sortingDirections.get(index);
                    sortingDirection = sortingDirection != 2 ? 2 : 1;
                    this.sortedViewColumns.clear();
                    this.sortedModelColumns.clear();
                    this.sortingDirections.clear();
                    this.sortedViewColumns.add(vc);
                    this.sortedModelColumns.add(new Integer(this.getModelColumn(e, viewColumn)));
                    this.sortingDirections.add(new Integer(sortingDirection));
                }
            } else {
                if (e.isAltDown()) {
                    return;
                }
                if (e.isControlDown() && model.supportsMultiColumnSort()) {
                    this.sortedViewColumns.add(vc);
                    this.sortedModelColumns.add(new Integer(this.getModelColumn(e, viewColumn)));
                    this.sortingDirections.add(new Integer(1));
                } else {
                    this.sortedViewColumns.clear();
                    this.sortedModelColumns.clear();
                    this.sortingDirections.clear();
                    this.sortedViewColumns.add(vc);
                    this.sortedModelColumns.add(new Integer(this.getModelColumn(e, viewColumn)));
                    this.sortingDirections.add(new Integer(1));
                }
            }
            header.putClientProperty(TinyTableHeaderUI.SORTED_COLUMN_KEY, this.vectorToIntArray(this.sortedViewColumns));
            header.putClientProperty(TinyTableHeaderUI.SORTING_DIRECTION_KEY, this.vectorToIntArray(this.sortingDirections));
            model.sortColumns(this.vectorToIntArray(this.sortedModelColumns), this.vectorToIntArray(this.sortingDirections), header.getTable());
            header.repaint();
        }

        private int[] vectorToIntArray(Vector v) {
            int[] ret = new int[v.size()];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (Integer)v.get(i);
            }
            return ret;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                return;
            }
            JTableHeader header = (JTableHeader)e.getSource();
            this.pressedPoint = e.getPoint();
            this.pressedColumn = header.columnAtPoint(this.pressedPoint);
            this.mouseDragged = false;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int modelColumn;
            SortableTableData model = this.getTableModel(e.getSource());
            if (model == null) {
                return;
            }
            this.inDrag = true;
            JTableHeader header = (JTableHeader)e.getSource();
            if (header.getResizingColumn() != null && !this.mouseDragged) {
                this.mouseDragged = true;
            }
            if (!header.getReorderingAllowed() && !model.isColumnSortable(modelColumn = this.getModelColumnAt(e))) {
                header.putClientProperty(TinyTableHeaderUI.ROLLOVER_COLUMN_KEY, null);
                header.repaint();
                return;
            }
            if (!this.mouseDragged && this.isMouseDragged(e.getPoint(), this.pressedPoint)) {
                this.mouseDragged = true;
            }
            if (!this.mouseInside) {
                header.putClientProperty(TinyTableHeaderUI.ROLLOVER_COLUMN_KEY, null);
            } else {
                int viewColumn;
                if (!header.getReorderingAllowed() && (viewColumn = header.columnAtPoint(e.getPoint())) != this.rolloverColumn) {
                    this.rolloverColumn = viewColumn;
                }
                if (this.rolloverColumn != -1) {
                    header.putClientProperty(TinyTableHeaderUI.ROLLOVER_COLUMN_KEY, new Integer(this.rolloverColumn));
                }
            }
            header.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!this.mouseInside) {
                return;
            }
            JTableHeader header = (JTableHeader)e.getSource();
            int viewColumn = header.columnAtPoint(e.getPoint());
            if (viewColumn == -1) {
                return;
            }
            SortableTableData model = this.getTableModel(e.getSource());
            if (model == null) {
                return;
            }
            int modelColumn = this.getModelColumnAt(e);
            if (!model.isColumnSortable(modelColumn)) {
                if (this.rolloverColumn != -1) {
                    this.rolloverColumn = -1;
                    header.putClientProperty(TinyTableHeaderUI.ROLLOVER_COLUMN_KEY, null);
                    header.repaint();
                }
                return;
            }
            if (viewColumn != this.rolloverColumn) {
                this.rolloverColumn = viewColumn;
                header.putClientProperty(TinyTableHeaderUI.ROLLOVER_COLUMN_KEY, new Integer(this.rolloverColumn));
                header.repaint();
            }
        }

        @Override
        public void columnAdded(TableColumnModelEvent e) {
            this.removeSorting();
        }

        @Override
        public void columnMoved(TableColumnModelEvent e) {
            int i;
            if (e.getFromIndex() == e.getToIndex()) {
                return;
            }
            if (TinyTableHeaderUI.this.header == null) {
                return;
            }
            if (this.rolloverColumn == e.getFromIndex()) {
                this.rolloverColumn = e.getToIndex();
                if (this.mouseInside) {
                    TinyTableHeaderUI.this.header.putClientProperty(TinyTableHeaderUI.ROLLOVER_COLUMN_KEY, new Integer(this.rolloverColumn));
                }
            }
            int[] sc = this.vectorToIntArray(this.sortedViewColumns);
            boolean changed = false;
            for (i = 0; i < sc.length; ++i) {
                if (sc[i] == e.getFromIndex()) {
                    sc[i] = e.getToIndex();
                    changed = true;
                    continue;
                }
                if (sc[i] != e.getToIndex()) continue;
                sc[i] = e.getFromIndex();
                changed = true;
            }
            if (changed) {
                this.sortedViewColumns.clear();
                for (i = 0; i < sc.length; ++i) {
                    this.sortedViewColumns.add(new Integer(sc[i]));
                }
                TinyTableHeaderUI.this.header.putClientProperty(TinyTableHeaderUI.SORTED_COLUMN_KEY, this.vectorToIntArray(this.sortedViewColumns));
            }
        }

        @Override
        public void columnRemoved(TableColumnModelEvent e) {
            this.removeSorting();
        }

        @Override
        public void columnMarginChanged(ChangeEvent e) {
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent e) {
        }

        private void removeSorting() {
            if (TinyTableHeaderUI.this.header == null) {
                return;
            }
            if (this.rolloverColumn != -1) {
                this.rolloverColumn = -1;
                TinyTableHeaderUI.this.header.putClientProperty(TinyTableHeaderUI.ROLLOVER_COLUMN_KEY, new Integer(this.rolloverColumn));
            }
            this.sortedModelColumns.clear();
            this.sortedViewColumns.clear();
            this.sortingDirections.clear();
            TinyTableHeaderUI.this.header.putClientProperty(TinyTableHeaderUI.SORTING_DIRECTION_KEY, null);
            TinyTableHeaderUI.this.header.putClientProperty(TinyTableHeaderUI.SORTED_COLUMN_KEY, null);
            TinyTableHeaderUI.this.header.repaint();
        }

        void removeSortingInformation() {
            if (TinyTableHeaderUI.this.header == null) {
                return;
            }
            SortableTableData model = this.getTableModel(TinyTableHeaderUI.this.header);
            if (model == null) {
                return;
            }
            sortingCache.put(TinyTableHeaderUI.this.header, new SortingInformation(this.sortedViewColumns, this.sortedModelColumns, this.sortingDirections, this.alignments));
            model.sortColumns(new int[0], new int[0], TinyTableHeaderUI.this.header.getTable());
            TinyTableHeaderUI.this.header.repaint();
        }

        void restoreSortingInformation(JTableHeader header, SortingInformation sortingInfo) {
            if (header == null) {
                return;
            }
            SortableTableData model = this.getTableModel(header);
            if (model == null) {
                return;
            }
            this.sortedViewColumns = sortingInfo.sortedViewColumns;
            this.sortedModelColumns = sortingInfo.sortedModelColumns;
            this.sortingDirections = sortingInfo.sortingDirections;
            this.alignments = sortingInfo.alignments;
            if (this.alignments != null && this.alignments.length > 0) {
                TinyTableHeaderUI.this.setHorizontalAlignments(this.alignments);
            }
            model.sortColumns(this.vectorToIntArray(this.sortedModelColumns), this.vectorToIntArray(this.sortingDirections), header.getTable());
            header.repaint();
        }

        private SortableTableData getTableModel(Object source) {
            return this.getTableModel((JTableHeader)source);
        }

        private SortableTableData getTableModel(JTableHeader header) {
            JTable table = header.getTable();
            if (table == null) {
                return null;
            }
            TableModel model = table.getModel();
            if (model == null || !(model instanceof SortableTableData)) {
                return null;
            }
            if (!TinyTableHeaderUI.this.rendererInstalled) {
                TinyTableHeaderUI.this.rendererInstalled = true;
                TableCellRenderer defaultRenderer = (TableCellRenderer)header.getClientProperty(TinyTableHeaderUI.DEFAULT_RENDERER_KEY);
                if (defaultRenderer == null) {
                    defaultRenderer = header.getDefaultRenderer();
                    header.putClientProperty(TinyTableHeaderUI.DEFAULT_RENDERER_KEY, defaultRenderer);
                }
                if (TinyTableHeaderUI.this.headerRenderer == null) {
                    TinyTableHeaderUI.this.headerRenderer = new TinyTableHeaderRenderer();
                }
                header.setDefaultRenderer(TinyTableHeaderUI.this.headerRenderer);
            }
            return (SortableTableData)((Object)model);
        }

        private int getModelColumnAt(MouseEvent e) {
            JTableHeader header = (JTableHeader)e.getSource();
            int viewColumn = header.columnAtPoint(e.getPoint());
            if (viewColumn == -1) {
                return -1;
            }
            return header.getColumnModel().getColumn(viewColumn).getModelIndex();
        }

        private int getModelColumn(MouseEvent e, int viewColumn) {
            if (viewColumn == -1) {
                return -1;
            }
            JTableHeader header = (JTableHeader)e.getSource();
            return this.getModelColumn(header, viewColumn);
        }

        private int getModelColumn(JTableHeader header, int viewColumn) {
            return header.getColumnModel().getColumn(viewColumn).getModelIndex();
        }

        private boolean isMouseDragged(Point p1, Point p2) {
            return Math.abs(p1.x - p2.x) >= 5;
        }

        private void showHeaderPopup(MouseEvent e) {
            final SortableTableData model = this.getTableModel(e.getSource());
            if (model == null) {
                return;
            }
            JTableHeader header = (JTableHeader)e.getSource();
            final int viewColumn = header.columnAtPoint(e.getPoint());
            JPopupMenu menu = new JPopupMenu();
            JMenu sub = new JMenu("Add");
            JMenuItem item = new JMenuItem("Double Column");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((TinyTableModel)model).addColumn(Double.class, viewColumn);
                }
            });
            sub.add(item);
            item = new JMenuItem("Icon Column");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((TinyTableModel)model).addColumn(Icon.class, viewColumn);
                }
            });
            sub.add(item);
            item = new JMenuItem("Integer Column");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((TinyTableModel)model).addColumn(Integer.class, viewColumn);
                }
            });
            sub.add(item);
            item = new JMenuItem("String Column");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((TinyTableModel)model).addColumn(String.class, viewColumn);
                }
            });
            sub.add(item);
            menu.add(sub);
            menu.addSeparator();
            item = new JMenuItem("Remove Column");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((TinyTableModel)model).removeColumn(viewColumn);
                }
            });
            if (((TinyTableModel)model).getColumnCount() < 2) {
                item.setEnabled(false);
            }
            menu.add(item);
            menu.addSeparator();
            item = new JMenuItem("Remove all Rows");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((TinyTableModel)model).removeAllRows();
                }
            });
            if (((TinyTableModel)model).getRowCount() == 0) {
                item.setEnabled(false);
            }
            menu.add(item);
            menu.addSeparator();
            item = new JMenuItem("Create new Data");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((TinyTableModel)model).createNewData();
                }
            });
            if (((TinyTableModel)model).getRowCount() > 0) {
                item.setEnabled(false);
            }
            menu.add(item);
            menu.show(header, e.getX(), 0);
        }

        static /* synthetic */ int[] access$902(SortableTableHandler x0, int[] x1) {
            x0.alignments = x1;
            return x1;
        }
    }

    private class SortingInformation {
        private Vector sortedViewColumns;
        private Vector sortedModelColumns;
        private Vector sortingDirections;
        private int[] alignments;

        SortingInformation(Vector sortedViewColumns, Vector sortedModelColumns, Vector sortingDirections, int[] alignments) {
            this.sortedViewColumns = sortedViewColumns;
            this.sortedModelColumns = sortedModelColumns;
            this.sortingDirections = sortingDirections;
            this.alignments = alignments;
        }
    }
}

