/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel.controlpanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;

public class CheckForUpdatesDialog
extends JDialog {
    private static final String CHECK_UPDATES_URL = "http://www.muntjak.de/hans/java/tinylaf/checkforupdate.html";

    private CheckForUpdatesDialog(Frame parent) {
        super(parent, "Check for Updates", true);
        this.setupUI(parent);
    }

    static void showDialog(Frame parent) {
        new CheckForUpdatesDialog(parent);
    }

    private void setupUI(Frame frame) {
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        JPanel p = new JPanel(new BorderLayout(0, 12));
        JLabel l = new JLabel("<html>When checking for updates, TinyLaF will connect to <b>muntjak.de</b><br>via HTTP. No personal data will be transmitted.");
        l.setBorder(new EmptyBorder(8, 8, 0, 8));
        p.add((Component)l, "North");
        JButton b = new JButton("Check for updates now");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String msg = CheckForUpdatesDialog.this.checkForUpdates();
                int index = msg.indexOf("Exception was: ");
                if (index != -1) {
                    String title2 = msg.substring(index + 15);
                    JOptionPane.showMessageDialog(CheckForUpdatesDialog.this, msg, title2, -1);
                } else if (msg.startsWith("No ")) {
                    JOptionPane.showMessageDialog(CheckForUpdatesDialog.this, msg, "Update Information", -1);
                } else {
                    new UpdateDialog(CheckForUpdatesDialog.this, msg);
                }
            }
        });
        JPanel flow = new JPanel(new FlowLayout(1, 0, 8));
        flow.add(b);
        p.add((Component)flow, "Center");
        p.add((Component)new JSeparator(), "South");
        this.getContentPane().add((Component)p, "Center");
        b = new JButton("Close");
        this.getRootPane().setDefaultButton(b);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckForUpdatesDialog.this.dispose();
            }
        });
        flow = new JPanel(new FlowLayout(1, 0, 8));
        flow.add(b);
        this.getContentPane().add((Component)flow, "South");
        this.pack();
        Dimension size = this.getSize();
        this.setLocation(frame.getLocationOnScreen().x + (frame.getWidth() - size.width) / 2, frame.getLocationOnScreen().y + (frame.getHeight() - size.height) / 2);
        this.setVisible(true);
    }

    private String checkForUpdates() {
        String expectedVersion;
        String answer = this.checkForUpdate();
        if (answer.indexOf("Exception") != -1) {
            return answer;
        }
        if (!answer.matches("TinyLaF \\d+\\.\\d+\\.\\d+\\s\\(\\d\\d\\d\\d/\\d+/\\d+\\)")) {
            System.out.println("? Invalid response format: '" + answer + "'");
            return "An exception occured while checking for updates.\n\nException was: Invalid response.";
        }
        String version2 = answer.substring(8);
        if (!version2.equals(expectedVersion = "1.4.0 (2009/8/25)")) {
            return answer;
        }
        return "No updated version of TinyLaF available.";
    }

    private String checkForUpdate() {
        InputStream is = null;
        try {
            URL url = new URL(CHECK_UPDATES_URL);
            try {
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestProperty("User-Agent", "TinyLaF");
                Object content = conn.getContent();
                if (!(content instanceof InputStream)) {
                    return "An exception occured while checking for updates.\n\nException was: Content is no InputStream";
                }
                is = (InputStream)content;
            }
            catch (IOException ex) {
                return "An exception occured while checking for updates.\n\nException was: " + ex.getClass().getName();
            }
        }
        catch (MalformedURLException ex) {
            return "An exception occured while checking for updates.\n\nException was: " + ex.getClass().getName();
        }
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(is));
            StringBuffer buff = new StringBuffer();
            while ((line = in.readLine()) != null) {
                buff.append(line);
            }
            in.close();
            return buff.toString();
        }
        catch (IOException ex) {
            return "An exception occured while checking for updates.\n\nException was: " + ex.getClass().getName();
        }
    }

    private class UpdateDialog
    extends JDialog {
        UpdateDialog(Dialog owner, String version2) {
            super(CheckForUpdatesDialog.this, "Update Information", true);
            this.setDefaultCloseOperation(2);
            this.getContentPane().setLayout(new BorderLayout());
            String msg = "<html>An updated version of TinyLaF is available:<br>" + version2 + "<br>It can be downloaded at www.muntjak.de/hans/java/tinylaf/.";
            JPanel p = new JPanel(new FlowLayout(1, 12, 8));
            p.add(new JLabel(msg));
            this.getContentPane().add((Component)p, "Center");
            p = new JPanel(new FlowLayout(1, 8, 10));
            JButton b = new JButton("Copy Link");
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
                    if (cb == null) {
                        JOptionPane.showMessageDialog(UpdateDialog.this, "System Clipboard not available.", "Error", 0);
                    } else {
                        StringSelection ss = new StringSelection("http://www.muntjak.de/hans/java/tinylaf/");
                        cb.setContents(ss, ss);
                    }
                }
            });
            p.add(b);
            b = new JButton("Close");
            this.getRootPane().setDefaultButton(b);
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UpdateDialog.this.dispose();
                }
            });
            p.add(b);
            this.getContentPane().add((Component)p, "South");
            this.pack();
            Point loc = owner.getLocationOnScreen();
            loc.x += (owner.getWidth() - this.getWidth()) / 2;
            loc.y += (owner.getHeight() - this.getHeight()) / 2;
            this.setLocation(loc);
            this.setVisible(true);
        }
    }
}

