/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel.controlpanel;

import de.muntjak.tinylookandfeel.controlpanel.ControlPanel;
import de.muntjak.tinylookandfeel.controlpanel.UndoManager;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.InsetsUIResource;

public class InsetsControl
extends JSpinner
implements ChangeListener {
    public static final int TOP = 1;
    public static final int LEFT = 2;
    public static final int BOTTOM = 3;
    public static final int RIGHT = 4;
    private static final Vector armedControls = new Vector();
    private InsetsUIResource ref;
    private int position;
    private int oldValue;
    boolean changeState = true;

    public InsetsControl(SpinnerModel model, InsetsUIResource ref, int position) {
        super(model);
        this.ref = ref;
        this.position = position;
        this.oldValue = (Integer)model.getValue();
        this.addChangeListener(this);
    }

    public String getPositionString() {
        if (this.position == 1) {
            return "top";
        }
        if (this.position == 2) {
            return "left";
        }
        if (this.position == 3) {
            return "bottom";
        }
        return "right";
    }

    public int getIntValue() {
        return (Integer)this.getValue();
    }

    public void setValue(int value) {
        this.changeState = false;
        this.oldValue = value;
        super.setValue(new Integer(value));
        this.changeState = true;
    }

    public void commitValue(int value) {
        this.changeState = false;
        this.oldValue = value;
        super.setValue(new Integer(value));
        this.updateInsets();
        this.changeState = true;
    }

    static void confirmChanges() {
        if (armedControls.isEmpty()) {
            return;
        }
        Iterator ii = armedControls.iterator();
        while (ii.hasNext()) {
            ((InsetsControl)ii.next()).confirmChange();
        }
        armedControls.clear();
    }

    private void confirmChange() {
        UndoManager.storeUndoData(this, this.oldValue);
        this.oldValue = (Integer)this.getValue();
        this.updateInsets();
    }

    private void updateInsets() {
        switch (this.position) {
            case 1: {
                this.ref.top = this.oldValue;
                break;
            }
            case 2: {
                this.ref.left = this.oldValue;
                break;
            }
            case 3: {
                this.ref.bottom = this.oldValue;
                break;
            }
            case 4: {
                this.ref.right = this.oldValue;
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (!this.changeState) {
            return;
        }
        if (!armedControls.contains(this)) {
            armedControls.add(this);
        }
        if (!ControlPanel.instance.applySettingsButton.isEnabled()) {
            ControlPanel.instance.applySettingsButton.setEnabled(true);
        }
    }
}

