/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel.controlpanel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.controlpanel.ControlPanel;
import de.muntjak.tinylookandfeel.controlpanel.IntControl;
import de.muntjak.tinylookandfeel.controlpanel.ParameterSetGenerator;
import de.muntjak.tinylookandfeel.controlpanel.SBControl;
import de.muntjak.tinylookandfeel.util.BooleanReference;
import de.muntjak.tinylookandfeel.util.ColoredFont;
import de.muntjak.tinylookandfeel.util.HSBReference;
import de.muntjak.tinylookandfeel.util.IntReference;
import de.muntjak.tinylookandfeel.util.SBReference;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.InsetsUIResource;

public class ParameterSet {
    static ControlPanel controlPanel;
    private ParameterSetGenerator generator;
    private Vector references;
    private Vector values;
    private Vector referenceColors;
    private String name;

    ParameterSet(ParameterSetGenerator generator, String name) {
        this.generator = generator;
        this.name = name;
        this.values = new Vector();
        this.references = new Vector();
        this.referenceColors = this.getReferenceColors();
    }

    private Vector getReferenceColors() {
        Vector<ColorUIResource> v = new Vector<ColorUIResource>();
        v.add(Theme.mainColor.getColor());
        v.add(Theme.backColor.getColor());
        v.add(Theme.disColor.getColor());
        v.add(Theme.frameColor.getColor());
        v.add(Theme.sub1Color.getColor());
        v.add(Theme.sub2Color.getColor());
        v.add(Theme.sub3Color.getColor());
        v.add(Theme.sub4Color.getColor());
        v.add(Theme.sub5Color.getColor());
        v.add(Theme.sub6Color.getColor());
        v.add(Theme.sub7Color.getColor());
        v.add(Theme.sub8Color.getColor());
        return v;
    }

    public void updateReferenceColors() {
        this.referenceColors = this.getReferenceColors();
    }

    public ParameterSet(ParameterSet ps) {
        this.generator = ps.generator;
        this.name = ps.name;
        this.references = (Vector)ps.references.clone();
        this.values = (Vector)ps.values.clone();
        this.referenceColors = this.getReferenceColors();
    }

    public ParameterSetGenerator getGenerator() {
        return this.generator;
    }

    public String getUndoString() {
        return "Paste " + this.name + " Parameters";
    }

    public void updateValues(ParameterSet other) {
        this.values = (Vector)other.values.clone();
    }

    public void updateValues() {
        Vector<Object> temp = new Vector<Object>(this.values.size());
        int end2 = this.values.size();
        for (int i = 0; i < end2; ++i) {
            Object value = this.values.get(i);
            Object reference = this.references.get(i);
            if (reference instanceof BooleanReference) {
                temp.add(new Boolean(((BooleanReference)reference).getValue()));
                continue;
            }
            if (reference instanceof HSBReference) {
                temp.add(new HSBReference((HSBReference)reference));
                continue;
            }
            if (reference instanceof SBReference) {
                temp.add(new SBReference((SBReference)reference));
                continue;
            }
            if (reference instanceof IntReference) {
                temp.add(new Integer(((IntReference)reference).getValue()));
                continue;
            }
            if (reference instanceof InsetsUIResource) {
                InsetsUIResource r = (InsetsUIResource)reference;
                temp.add(new Insets(r.top, r.left, r.bottom, r.right));
                continue;
            }
            if (!(reference instanceof ColoredFont)) continue;
            temp.add(new ColoredFont((ColoredFont)reference));
        }
        this.values = temp;
    }

    void addParameter(boolean value, BooleanReference reference) {
        this.values.add(new Boolean(value));
        this.references.add(reference);
    }

    void addParameter(SBControl control) {
        if (control.getSBReference().isReferenceColor()) {
            if (control.getSBReference().isAbsoluteColor()) {
                this.values.add(0, new SBReference(control.getSBReference()));
                this.references.add(0, control.getSBReference());
            } else {
                int end2 = this.values.size();
                int index = 0;
                for (int i = 0; i < end2; ++i) {
                    Object value = this.values.get(i);
                    if (value instanceof SBReference) {
                        if (((SBReference)value).isReferenceColor()) continue;
                        index = i;
                        break;
                    }
                    index = i;
                    break;
                }
                this.values.add(index, new SBReference(control.getSBReference()));
                this.references.add(index, control.getSBReference());
            }
        } else {
            this.values.add(new SBReference(control.getSBReference()));
            this.references.add(control.getSBReference());
        }
    }

    void addParameter(ControlPanel.SpreadControl control) {
        this.values.add(new Integer(control.getValue()));
        this.references.add(control.getIntReference());
    }

    void addParameter(IntControl control) {
        this.values.add(control.getValue());
        this.references.add(control.getIntReference());
    }

    void addParameter(Insets value, InsetsUIResource reference) {
        this.values.add(value);
        this.references.add(reference);
    }

    void addParameter(ControlPanel.HSBControl control) {
        this.values.add(new HSBReference(control.getHSBReference()));
        this.references.add(control.getHSBReference());
    }

    void addParameter(ColoredFont cf) {
        this.values.add(new ColoredFont(cf));
        this.references.add(cf);
    }

    public void pasteParameters(boolean storeUndoData) {
        if (storeUndoData) {
            ControlPanel.instance.storeUndoData(this);
        }
        int end2 = this.values.size();
        for (int i = 0; i < end2; ++i) {
            Object value = this.values.get(i);
            Object reference = this.references.get(i);
            if (reference instanceof BooleanReference) {
                ((BooleanReference)reference).setValue((Boolean)value);
                continue;
            }
            if (reference instanceof HSBReference) {
                ((HSBReference)reference).update((HSBReference)value, this.referenceColors);
                continue;
            }
            if (reference instanceof SBReference) {
                ((SBReference)reference).update((SBReference)value, this.referenceColors);
                continue;
            }
            if (reference instanceof IntReference) {
                ((IntReference)reference).setValue((Integer)value);
                continue;
            }
            if (reference instanceof InsetsUIResource) {
                InsetsUIResource r = (InsetsUIResource)reference;
                Insets v = (Insets)value;
                r.top = v.top;
                r.left = v.left;
                r.bottom = v.bottom;
                r.right = v.right;
                continue;
            }
            if (!(reference instanceof ColoredFont)) continue;
            ((ColoredFont)reference).update((ColoredFont)value, this.referenceColors);
        }
        this.generator.init(true);
        ControlPanel.instance.initPanels();
        ControlPanel.instance.setTheme();
    }

    public String toString() {
        StringBuffer buff = new StringBuffer("ParameterSet:");
        int end2 = this.values.size();
        for (int i = 0; i < end2; ++i) {
            Object value = this.values.get(i);
            Object reference = this.references.get(i);
            buff.append("\n  reference: " + reference);
            buff.append("\n      value: " + value);
        }
        return buff.toString();
    }
}

