/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel.controlpanel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.controlpanel.ControlPanel;
import de.muntjak.tinylookandfeel.controlpanel.PSColorChooser;
import de.muntjak.tinylookandfeel.controlpanel.SBChooser;
import de.muntjak.tinylookandfeel.controlpanel.Selectable;
import de.muntjak.tinylookandfeel.util.SBReference;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.plaf.ColorUIResource;

public class SBControl
extends JPanel
implements Selectable {
    protected static final ControlPanel cp = ControlPanel.instance;
    protected final int cpSize = 10;
    protected boolean forceUpdate = false;
    protected Dimension size = new Dimension(64, 20);
    protected SBReference sbReference;
    protected int controlMode = 22;
    private boolean selected = false;

    SBControl(SBReference ref, int controlMode) {
        this(ref, false, controlMode);
    }

    SBControl(SBReference ref, boolean forceUpdate, int controlMode) {
        this.sbReference = ref;
        this.forceUpdate = forceUpdate;
        this.controlMode = controlMode;
        if (ref == null) {
            return;
        }
        this.update();
        this.addMouseListener(new Mousey());
    }

    SBControl(SBReference ref) {
        this.sbReference = ref;
        this.forceUpdate = true;
        this.size.height = 24;
        if (ref == null) {
            return;
        }
        this.update();
        this.addMouseListener(new Mousey());
    }

    public SBReference getSBReference() {
        return this.sbReference;
    }

    public Color getColor() {
        return this.sbReference.getColor();
    }

    public boolean isLocked() {
        return this.sbReference != null && this.sbReference.isLocked();
    }

    @Override
    public void setBackground(Color bg) {
        if (this.sbReference == null) {
            super.setBackground(bg);
        } else {
            super.setBackground(this.sbReference.getColor());
        }
    }

    public void update() {
        if (this.sbReference != null) {
            this.setBackground(this.sbReference.update());
        }
        this.repaint();
        this.updateTTT();
    }

    public void updateTTT() {
        if (this.sbReference == null) {
            this.setToolTipText(null);
            return;
        }
        ColorUIResource c = this.sbReference.getColor();
        StringBuffer buff = new StringBuffer("<html>");
        if (this.sbReference.isAbsoluteColor()) {
            buff.append("R:" + c.getRed());
            buff.append(" G:" + c.getGreen());
            buff.append(" B:" + c.getBlue());
        } else {
            buff.append("S:" + this.sbReference.getSaturation());
            buff.append(" B:" + this.sbReference.getBrightness());
            buff.append(" (" + this.sbReference.getReferenceString() + ")");
            buff.append(" R:" + c.getRed());
            buff.append(" G:" + c.getGreen());
            buff.append(" B:" + c.getBlue());
        }
        if (this.sbReference.equals(Theme.mainColor)) {
            buff.append("<br>References: " + SBReference.getNumReferences(2));
        } else if (this.sbReference.equals(Theme.backColor)) {
            buff.append("<br>References: " + SBReference.getNumReferences(3));
        } else if (this.sbReference.equals(Theme.disColor)) {
            buff.append("<br>References: " + SBReference.getNumReferences(4));
        } else if (this.sbReference.equals(Theme.frameColor)) {
            buff.append("<br>References: " + SBReference.getNumReferences(5));
        } else if (this.sbReference.equals(Theme.sub1Color)) {
            buff.append("<br>References: " + SBReference.getNumReferences(6));
        } else if (this.sbReference.equals(Theme.sub2Color)) {
            buff.append("<br>References: " + SBReference.getNumReferences(7));
        } else if (this.sbReference.equals(Theme.sub3Color)) {
            buff.append("<br>References: " + SBReference.getNumReferences(8));
        } else if (this.sbReference.equals(Theme.sub4Color)) {
            buff.append("<br>References: " + SBReference.getNumReferences(9));
        } else if (this.sbReference.equals(Theme.sub5Color)) {
            buff.append("<br>References: " + SBReference.getNumReferences(10));
        } else if (this.sbReference.equals(Theme.sub6Color)) {
            buff.append("<br>References: " + SBReference.getNumReferences(11));
        } else if (this.sbReference.equals(Theme.sub7Color)) {
            buff.append("<br>References: " + SBReference.getNumReferences(12));
        } else if (this.sbReference.equals(Theme.sub8Color)) {
            buff.append("<br>References: " + SBReference.getNumReferences(13));
        }
        this.setToolTipText(buff.toString());
    }

    public void setSBReference(SBReference ref) {
        this.sbReference = ref;
        this.update();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.size;
    }

    @Override
    public void paint(Graphics g) {
        if (this.sbReference == null) {
            g.setColor(Theme.backColor.getColor());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            return;
        }
        g.setColor(this.getBackground());
        g.fillRect(2, 2, this.getWidth() - 3, this.getHeight() - 3);
        if (this.selected) {
            g.setColor(Color.DARK_GRAY);
            g.drawRect(1, 1, this.getWidth() - 3, this.getHeight() - 3);
            g.setColor(Color.RED);
            g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        } else {
            g.setColor(Color.DARK_GRAY);
            g.drawRect(1, 1, this.getWidth() - 3, this.getHeight() - 3);
            g.setColor(Theme.backColor.getColor());
            g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
        if (this.sbReference == null || this.sbReference.isLocked()) {
            return;
        }
        g.setColor(Color.LIGHT_GRAY);
        g.fillRect(2, 2, 10, this.getHeight() - 4);
        g.setColor(Color.BLACK);
        g.fillRect(12, 2, 1, this.getHeight() - 4);
        if (this.sbReference.isAbsoluteColor()) {
            int x = this.getWidth() - 20;
            float hue = 0.0f;
            g.drawLine(x - 1, 2, x - 1, this.getHeight() - 3);
            for (int i = 0; i < 18; ++i) {
                g.setColor(Color.getHSBColor(hue, 0.5f, 1.0f));
                g.drawLine(x + i, 2, x + i, this.getHeight() - 3);
                hue = (float)((double)hue + 0.05263157894736842);
            }
        } else {
            int x = this.getWidth() - 20;
            int grey = 255;
            g.drawLine(x - 1, 2, x - 1, this.getHeight() - 3);
            for (int i = 0; i < 18; ++i) {
                g.setColor(new Color(grey, grey, grey));
                g.drawLine(x + i, 2, x + i, this.getHeight() - 3);
                grey -= 14;
            }
        }
    }

    void updateTargets(boolean activateApplyButton) {
        if (this.forceUpdate) {
            if (activateApplyButton) {
                SBControl.cp.examplePanel.update(true);
            } else {
                cp.initPanels();
                cp.setTheme();
            }
        } else {
            cp.repaintTargets(this.controlMode);
        }
    }

    @Override
    public String toString() {
        return "SBField[ref=" + this.sbReference + "]";
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean selected) {
        if (this.selected == selected) {
            return;
        }
        this.selected = selected;
        this.repaint();
    }

    class Mousey
    extends MouseAdapter {
        Mousey() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger() && !SBControl.this.sbReference.isLocked()) {
                if (e.getX() <= 10) {
                    cp.showCPSBPopup(SBControl.this);
                } else {
                    cp.showSBPopup(SBControl.this);
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (SBControl.this.sbReference == null) {
                return;
            }
            SBControl.this.requestFocusInWindow();
            if (e.isControlDown()) {
                if (!SBControl.this.selected) {
                    ControlPanel.selection.add(SBControl.this);
                }
                return;
            }
            if (e.isAltDown()) {
                if (SBControl.this.selected) {
                    ControlPanel.selection.remove(SBControl.this);
                }
                return;
            }
            if (e.getX() <= 10) {
                cp.showCPSBPopup(SBControl.this);
                return;
            }
            if (e.isPopupTrigger() && !SBControl.this.sbReference.isLocked()) {
                cp.showSBPopup(SBControl.this);
                return;
            }
            if (e.getX() > SBControl.this.getWidth() - 19 && !SBControl.this.sbReference.isLocked()) {
                cp.showSBPopup(SBControl.this);
                return;
            }
            if (e.getButton() != 1) {
                return;
            }
            Color newColor = null;
            if (SBControl.this.sbReference.isAbsoluteColor()) {
                newColor = PSColorChooser.showColorChooser(SBControl.cp.theFrame, SBControl.this.getColor());
                if (newColor == null) {
                    return;
                }
                if (newColor.equals(SBControl.this.sbReference.getColor())) {
                    return;
                }
                cp.storeUndoData(SBControl.this);
                SBControl.this.sbReference.setColor(newColor);
            } else {
                newColor = SBChooser.showSBChooser(SBControl.cp.theFrame, SBControl.this);
                if (newColor == null) {
                    return;
                }
                if (SBControl.this.sbReference.getBrightness() == SBChooser.getBrightness() && SBControl.this.sbReference.getSaturation() == SBChooser.getSaturation()) {
                    return;
                }
                cp.storeUndoData(SBControl.this);
                SBControl.this.sbReference.setColor(SBChooser.getSaturation(), SBChooser.getBrightness());
            }
            SBControl.this.update();
            cp.initPanels();
            SBControl.this.updateTargets(true);
        }
    }
}

