/*
 * Decompiled with CFR 0.152.
 */
package resid;

import resid.ISIDDefs;

public class ExternalFilter {
    protected boolean enabled;
    protected int mixer_DC;
    protected int Vlp;
    protected int Vhp;
    protected int Vo;
    protected int w0lp;
    protected int w0hp;

    public void clock(int Vi) {
        if (!this.enabled) {
            this.Vhp = 0;
            this.Vlp = 0;
            this.Vo = Vi - this.mixer_DC;
            return;
        }
        int dVlp = (this.w0lp >> 8) * (Vi - this.Vlp) >> 12;
        int dVhp = this.w0hp * (this.Vlp - this.Vhp) >> 20;
        this.Vo = this.Vlp - this.Vhp;
        this.Vlp += dVlp;
        this.Vhp += dVhp;
    }

    public void clock(int delta_t, int Vi) {
        if (!this.enabled) {
            this.Vhp = 0;
            this.Vlp = 0;
            this.Vo = Vi - this.mixer_DC;
            return;
        }
        int delta_t_flt = 8;
        while (delta_t != 0) {
            if (delta_t < delta_t_flt) {
                delta_t_flt = delta_t;
            }
            int dVlp = (this.w0lp * delta_t_flt >> 8) * (Vi - this.Vlp) >> 12;
            int dVhp = this.w0hp * delta_t_flt * (this.Vlp - this.Vhp) >> 20;
            this.Vo = this.Vlp - this.Vhp;
            this.Vlp += dVlp;
            this.Vhp += dVhp;
            delta_t -= delta_t_flt;
        }
    }

    public int output() {
        return this.Vo;
    }

    public ExternalFilter() {
        this.reset();
        this.enable_filter(true);
        this.set_sampling_parameter(15915.6);
        this.set_chip_model(ISIDDefs.chip_model.MOS6581);
    }

    public void enable_filter(boolean enable) {
        this.enabled = enable;
    }

    public void set_sampling_parameter(double pass_freq) {
        double pi = Math.PI;
        this.w0hp = 105;
        this.w0lp = (int)(pass_freq * 6.588397316661141);
        if (this.w0lp > 104858) {
            this.w0lp = 104858;
        }
    }

    public void set_chip_model(ISIDDefs.chip_model model) {
        this.mixer_DC = model == ISIDDefs.chip_model.MOS6581 ? 280065 : 0;
    }

    public void reset() {
        this.Vlp = 0;
        this.Vhp = 0;
        this.Vo = 0;
    }
}

