/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;

public class BitDepthProcessor
implements AudioProcessor {
    int bitDepth = 16;

    public void setBitDepth(int newBitDepth) {
        this.bitDepth = newBitDepth;
    }

    public int getBitDepth() {
        return this.bitDepth;
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        float[] buffer = audioEvent.getFloatBuffer();
        float factor = (float)Math.pow(2.0, this.bitDepth) / 2.0f - 1.0f;
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = (float)((int)(buffer[i] * factor)) / factor;
        }
        return true;
    }

    @Override
    public void processingFinished() {
    }
}

