/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;
import be.tarsos.dsp.util.fft.FFT;

public class ConstantQ
implements AudioProcessor {
    private final float minimumFrequency;
    private final float maximumFreqency;
    private int fftLength;
    private final float[] frequencies;
    private final float[][] qKernel;
    private final int[][] qKernel_indexes;
    private final float[] coefficients;
    private final float[] magnitudes;
    private int binsPerOctave;
    private FFT fft;

    public ConstantQ(float sampleRate, float minFreq, float maxFreq, float binsPerOctave) {
        this(sampleRate, minFreq, maxFreq, binsPerOctave, 0.001f, 1.0f);
    }

    public ConstantQ(float sampleRate, float minFreq, float maxFreq, float binsPerOctave, float threshold, float spread) {
        this.minimumFrequency = minFreq;
        this.maximumFreqency = maxFreq;
        this.binsPerOctave = (int)binsPerOctave;
        double q = 1.0 / (Math.pow(2.0, 1.0 / (double)binsPerOctave) - 1.0) / (double)spread;
        int numberOfBins = (int)Math.ceil((double)binsPerOctave * Math.log(this.maximumFreqency / this.minimumFrequency) / Math.log(2.0));
        this.coefficients = new float[numberOfBins * 2];
        this.magnitudes = new float[numberOfBins];
        float calc_fftlen = (float)Math.ceil(q * (double)sampleRate / (double)this.minimumFrequency);
        this.fftLength = (int)calc_fftlen;
        this.fftLength = (int)Math.pow(2.0, Math.ceil(Math.log(calc_fftlen) / Math.log(2.0)));
        this.fft = new FFT(this.fftLength);
        this.qKernel = new float[numberOfBins][];
        this.qKernel_indexes = new int[numberOfBins][];
        this.frequencies = new float[numberOfBins];
        float[] temp = new float[this.fftLength * 2];
        float[] ctemp = new float[this.fftLength * 2];
        int[] cindexes = new int[this.fftLength];
        for (int i = 0; i < numberOfBins; ++i) {
            int j;
            int j2;
            float[] sKernel = temp;
            this.frequencies[i] = (float)((double)this.minimumFrequency * Math.pow(2.0, (float)i / binsPerOctave));
            int len = (int)Math.min(Math.ceil(q * (double)sampleRate / (double)this.frequencies[i]), (double)this.fftLength);
            for (j2 = 0; j2 < len; ++j2) {
                double window = -0.5 * Math.cos(Math.PI * 2 * (double)j2 / (double)len) + 0.5;
                double x = Math.PI * 2 * q * (double)j2 / (double)len;
                sKernel[j2 * 2] = (float)((window /= (double)len) * Math.cos(x));
                sKernel[j2 * 2 + 1] = (float)(window * Math.sin(x));
            }
            for (j2 = len * 2; j2 < this.fftLength * 2; ++j2) {
                sKernel[j2] = 0.0f;
            }
            this.fft.complexForwardTransform(sKernel);
            float[] cKernel = ctemp;
            int k = 0;
            int j3 = 0;
            int j22 = sKernel.length - 2;
            while (j3 < sKernel.length / 2) {
                double absval = Math.sqrt(sKernel[j3] * sKernel[j3] + sKernel[j3 + 1] * sKernel[j3 + 1]);
                if ((absval += Math.sqrt(sKernel[j22] * sKernel[j22] + sKernel[j22 + 1] * sKernel[j22 + 1])) > (double)threshold) {
                    cindexes[k] = j3;
                    cKernel[2 * k] = sKernel[j3] + sKernel[j22];
                    cKernel[2 * k + 1] = sKernel[j3 + 1] + sKernel[j22 + 1];
                    ++k;
                }
                j3 += 2;
                j22 -= 2;
            }
            sKernel = new float[k * 2];
            int[] indexes = new int[k];
            for (j = 0; j < k * 2; ++j) {
                sKernel[j] = cKernel[j];
            }
            for (j = 0; j < k; ++j) {
                indexes[j] = cindexes[j];
            }
            j = 0;
            while (j < sKernel.length) {
                int n = j++;
                sKernel[n] = sKernel[n] / (float)this.fftLength;
            }
            for (j = 1; j < sKernel.length; j += 2) {
                sKernel[j] = -sKernel[j];
            }
            for (j = 0; j < sKernel.length; ++j) {
                sKernel[j] = -sKernel[j];
            }
            this.qKernel_indexes[i] = indexes;
            this.qKernel[i] = sKernel;
        }
    }

    public void calculate(float[] inputBuffer) {
        this.fft.forwardTransform(inputBuffer);
        for (int i = 0; i < this.qKernel.length; ++i) {
            float[] kernel = this.qKernel[i];
            int[] indexes = this.qKernel_indexes[i];
            float t_r = 0.0f;
            float t_i = 0.0f;
            int j = 0;
            int l = 0;
            while (j < kernel.length) {
                int jj = indexes[l];
                float b_r = inputBuffer[jj];
                float b_i = inputBuffer[jj + 1];
                float k_r = kernel[j];
                float k_i = kernel[j + 1];
                t_r += b_r * k_r - b_i * k_i;
                t_i += b_r * k_i + b_i * k_r;
                j += 2;
                ++l;
            }
            this.coefficients[i * 2] = t_r;
            this.coefficients[i * 2 + 1] = t_i;
        }
    }

    public void calculateMagintudes(float[] inputBuffer) {
        this.calculate(inputBuffer);
        for (int i = 0; i < this.magnitudes.length; ++i) {
            this.magnitudes[i] = (float)Math.sqrt(this.coefficients[i * 2] * this.coefficients[i * 2] + this.coefficients[i * 2 + 1] * this.coefficients[i * 2 + 1]);
        }
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        float[] audioBuffer = (float[])audioEvent.getFloatBuffer().clone();
        if (audioBuffer.length != this.getFFTlength()) {
            throw new IllegalArgumentException(String.format("The length of the fft (%d) should be the same as the length of the audio buffer (%d)", this.getFFTlength(), audioBuffer.length));
        }
        this.calculateMagintudes(audioBuffer);
        return true;
    }

    @Override
    public void processingFinished() {
    }

    public float[] getFreqencies() {
        return this.frequencies;
    }

    public float[] getMagnitudes() {
        return this.magnitudes;
    }

    public float[] getCoefficients() {
        return this.coefficients;
    }

    public int getNumberOfOutputBands() {
        return this.frequencies.length;
    }

    public int getFFTlength() {
        return this.fftLength;
    }

    public int getBinsPerOctave() {
        return this.binsPerOctave;
    }
}

