/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;

public class EnvelopeFollower
implements AudioProcessor {
    private static final double DEFAULT_ATTACK_TIME = 2.0E-4;
    private static final double DEFAULT_RELEASE_TIME = 4.0E-4;
    float gainAttack;
    float gainRelease;
    float envelopeOut = 0.0f;

    public EnvelopeFollower(double sampleRate) {
        this(sampleRate, 2.0E-4, 4.0E-4);
    }

    public EnvelopeFollower(double sampleRate, double attackTime, double releaseTime) {
        this.gainAttack = (float)Math.exp(-1.0 / (sampleRate * attackTime));
        this.gainRelease = (float)Math.exp(-1.0 / (sampleRate * releaseTime));
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        float[] buffer = audioEvent.getFloatBuffer();
        this.calculateEnvelope(buffer);
        return true;
    }

    public void calculateEnvelope(float[] buffer) {
        for (int i = 0; i < buffer.length; ++i) {
            float envelopeIn = Math.abs(buffer[i]);
            this.envelopeOut = this.envelopeOut < envelopeIn ? envelopeIn + this.gainAttack * (this.envelopeOut - envelopeIn) : envelopeIn + this.gainRelease * (this.envelopeOut - envelopeIn);
            buffer[i] = this.envelopeOut;
        }
    }

    @Override
    public void processingFinished() {
    }
}

