/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;
import be.tarsos.dsp.GainProcessor;

public class FadeOut
implements AudioProcessor {
    private double duration;
    private double firstTime = -1.0;
    private double time;
    private boolean isFadeOut = false;
    private GainProcessor gp = new GainProcessor(0.9);

    public FadeOut(double d) {
        this.duration = d;
    }

    public void startFadeOut() {
        this.isFadeOut = true;
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        if (this.isFadeOut) {
            if (this.firstTime == -1.0) {
                this.firstTime = audioEvent.getTimeStamp();
            }
            this.time = audioEvent.getTimeStamp() - this.firstTime;
            this.gp.setGain(1.0 - this.time / this.duration);
            this.gp.process(audioEvent);
        }
        return true;
    }

    @Override
    public void processingFinished() {
        this.gp.processingFinished();
    }
}

