/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;
import be.tarsos.dsp.util.fft.FFT;

public class PitchShifter
implements AudioProcessor {
    private final FFT fft;
    private final int size;
    private final float[] currentMagnitudes;
    private final float[] currentPhase;
    private final float[] currentFrequencies;
    private final float[] outputAccumulator;
    private final float[] summedPhase;
    private float[] previousPhase;
    private double pitchShiftRatio = 0.0;
    private final double sampleRate;
    private long osamp;
    private double excpt;

    public PitchShifter(double factor, double sampleRate, int size, int overlap) {
        this.pitchShiftRatio = factor;
        this.size = size;
        this.sampleRate = sampleRate;
        this.osamp = size / (size - overlap);
        this.excpt = Math.PI * 2 * (double)(size - overlap) / (double)size;
        this.fft = new FFT(size);
        this.currentMagnitudes = new float[size / 2];
        this.currentFrequencies = new float[size / 2];
        this.currentPhase = new float[size / 2];
        this.previousPhase = new float[size / 2];
        this.summedPhase = new float[size / 2];
        this.outputAccumulator = new float[size * 2];
    }

    public void setPitchShiftFactor(float newPitchShiftFactor) {
        this.pitchShiftRatio = newPitchShiftFactor;
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        int i;
        float[] fftData = (float[])audioEvent.getFloatBuffer().clone();
        for (int i2 = 0; i2 < this.size; ++i2) {
            float window = (float)(-0.5 * Math.cos(Math.PI * 2 * (double)i2 / (double)this.size) + 0.5);
            fftData[i2] = window * fftData[i2];
        }
        this.fft.forwardTransform(fftData);
        this.fft.powerAndPhaseFromFFT(fftData, this.currentMagnitudes, this.currentPhase);
        float freqPerBin = (float)(this.sampleRate / (double)this.size);
        for (int i3 = 0; i3 < this.size / 2; ++i3) {
            float phase = this.currentPhase[i3];
            double tmp = phase - this.previousPhase[i3];
            this.previousPhase[i3] = phase;
            long qpd = (long)((tmp -= (double)i3 * this.excpt) / Math.PI);
            qpd = qpd >= 0L ? (qpd += qpd & 1L) : (qpd -= qpd & 1L);
            tmp -= Math.PI * (double)qpd;
            tmp = (double)this.osamp * tmp / (Math.PI * 2);
            tmp = (double)i3 * (double)freqPerBin + tmp * (double)freqPerBin;
            this.currentFrequencies[i3] = (float)tmp;
        }
        float[] newMagnitudes = new float[this.size / 2];
        float[] newFrequencies = new float[this.size / 2];
        for (int i4 = 0; i4 < this.size / 2; ++i4) {
            int index = (int)((double)i4 * this.pitchShiftRatio);
            if (index >= this.size / 2) continue;
            int n = index;
            newMagnitudes[n] = newMagnitudes[n] + this.currentMagnitudes[i4];
            newFrequencies[index] = (float)((double)this.currentFrequencies[i4] * this.pitchShiftRatio);
        }
        float[] newFFTData = new float[this.size];
        for (i = 0; i < this.size / 2; ++i) {
            float magn = newMagnitudes[i];
            double tmp = newFrequencies[i];
            tmp -= (double)i * (double)freqPerBin;
            tmp /= (double)freqPerBin;
            tmp = Math.PI * 2 * tmp / (double)this.osamp;
            int n = i;
            this.summedPhase[n] = (float)((double)this.summedPhase[n] + (tmp += (double)i * this.excpt));
            float phase = this.summedPhase[i];
            newFFTData[2 * i] = (float)((double)magn * Math.cos(phase));
            newFFTData[2 * i + 1] = (float)((double)magn * Math.sin(phase));
        }
        for (i = this.size / 2 + 2; i < this.size; ++i) {
            newFFTData[i] = 0.0f;
        }
        this.fft.backwardsTransform(newFFTData);
        for (i = 0; i < newFFTData.length; ++i) {
            float window = (float)(-0.5 * Math.cos(Math.PI * 2 * (double)i / (double)this.size) + 0.5);
            int n = i;
            this.outputAccumulator[n] = this.outputAccumulator[n] + window * newFFTData[i] / (float)this.osamp;
            if (!((double)this.outputAccumulator[i] > 1.0) && !((double)this.outputAccumulator[i] < -1.0)) continue;
            System.err.println("Clipping!");
        }
        int stepSize = (int)((long)this.size / this.osamp);
        System.arraycopy(this.outputAccumulator, stepSize, this.outputAccumulator, 0, this.size);
        float[] audioBuffer = new float[audioEvent.getFloatBuffer().length];
        audioEvent.setFloatBuffer(audioBuffer);
        System.arraycopy(this.outputAccumulator, 0, audioBuffer, this.size - stepSize, stepSize);
        return true;
    }

    @Override
    public void processingFinished() {
    }
}

