/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp;

import be.tarsos.dsp.AudioDispatcher;
import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;

public class WaveformSimilarityBasedOverlapAdd
implements AudioProcessor {
    private int seekWindowLength;
    private int seekLength;
    private int overlapLength;
    private float[] pMidBuffer;
    private float[] pRefMidBuffer;
    private float[] outputFloatBuffer;
    private int intskip;
    private int sampleReq;
    private double tempo;
    private AudioDispatcher dispatcher;
    private Parameters newParameters;

    public WaveformSimilarityBasedOverlapAdd(Parameters params) {
        this.setParameters(params);
        this.applyNewParameters();
    }

    public void setParameters(Parameters params) {
        this.newParameters = params;
    }

    public void setDispatcher(AudioDispatcher newDispatcher) {
        this.dispatcher = newDispatcher;
    }

    private void applyNewParameters() {
        Parameters params = this.newParameters;
        int oldOverlapLength = this.overlapLength;
        this.overlapLength = (int)(params.getSampleRate() * params.getOverlapMs() / 1000.0);
        this.seekWindowLength = (int)(params.getSampleRate() * params.getSequenceMs() / 1000.0);
        this.seekLength = (int)(params.getSampleRate() * params.getSeekWindowMs() / 1000.0);
        this.tempo = params.getTempo();
        if (this.overlapLength > oldOverlapLength * 8 && this.pMidBuffer == null) {
            this.pMidBuffer = new float[this.overlapLength * 8];
            this.pRefMidBuffer = new float[this.overlapLength * 8];
        }
        double nominalSkip = this.tempo * (double)(this.seekWindowLength - this.overlapLength);
        this.intskip = (int)(nominalSkip + 0.5);
        this.sampleReq = Math.max(this.intskip + this.overlapLength, this.seekWindowLength) + this.seekLength;
        float[] prevOutputBuffer = this.outputFloatBuffer;
        this.outputFloatBuffer = new float[this.getOutputBufferSize()];
        if (prevOutputBuffer != null) {
            System.out.println("Copy outputFloatBuffer contents");
            for (int i = 0; i < prevOutputBuffer.length && i < this.outputFloatBuffer.length; ++i) {
                this.outputFloatBuffer[i] = prevOutputBuffer[i];
            }
        }
        this.newParameters = null;
    }

    public int getInputBufferSize() {
        return this.sampleReq;
    }

    private int getOutputBufferSize() {
        return this.seekWindowLength - this.overlapLength;
    }

    public int getOverlap() {
        return this.sampleReq - this.intskip;
    }

    private void overlap(float[] output, int outputOffset, float[] input, int inputOffset) {
        for (int i = 0; i < this.overlapLength; ++i) {
            int itemp = this.overlapLength - i;
            output[i + outputOffset] = (input[i + inputOffset] * (float)i + this.pMidBuffer[i] * (float)itemp) / (float)this.overlapLength;
        }
    }

    private int seekBestOverlapPosition(float[] inputBuffer, int postion) {
        this.precalcCorrReferenceMono();
        double bestCorrelation = -10.0;
        int bestOffset = 0;
        for (int tempOffset = 0; tempOffset < this.seekLength; ++tempOffset) {
            int comparePosition = postion + tempOffset;
            double currentCorrelation = this.calcCrossCorr(this.pRefMidBuffer, inputBuffer, comparePosition);
            double tmp = (double)(2 * tempOffset - this.seekLength) / (double)this.seekLength;
            if (!((currentCorrelation = (currentCorrelation + 0.1) * (1.0 - 0.25 * tmp * tmp)) > bestCorrelation)) continue;
            bestCorrelation = currentCorrelation;
            bestOffset = tempOffset;
        }
        return bestOffset;
    }

    void precalcCorrReferenceMono() {
        for (int i = 0; i < this.overlapLength; ++i) {
            float temp = i * (this.overlapLength - i);
            this.pRefMidBuffer[i] = this.pMidBuffer[i] * temp;
        }
    }

    double calcCrossCorr(float[] mixingPos, float[] compare, int offset) {
        double corr = 0.0;
        double norm = 0.0;
        for (int i = 1; i < this.overlapLength; ++i) {
            corr += (double)(mixingPos[i] * compare[i + offset]);
            norm += (double)(mixingPos[i] * mixingPos[i]);
        }
        if (norm < 1.0E-8) {
            norm = 1.0;
        }
        return corr / Math.pow(norm, 0.5);
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        int sequenceLength;
        float[] audioFloatBuffer = audioEvent.getFloatBuffer();
        assert (audioFloatBuffer.length == this.getInputBufferSize());
        int offset = this.seekBestOverlapPosition(audioFloatBuffer, 0);
        this.overlap(this.outputFloatBuffer, 0, audioFloatBuffer, offset);
        int copyMax1 = sequenceLength = this.seekWindowLength - 2 * this.overlapLength;
        if (audioFloatBuffer.length < offset + this.overlapLength + sequenceLength) {
            sequenceLength = copyMax1 = sequenceLength - (offset + this.overlapLength + sequenceLength - audioFloatBuffer.length);
        }
        System.arraycopy(audioFloatBuffer, offset + this.overlapLength, this.outputFloatBuffer, this.overlapLength, sequenceLength);
        int copyMax = this.overlapLength;
        if (audioFloatBuffer.length < offset + sequenceLength + this.overlapLength * 2) {
            for (int i = copyMax = this.overlapLength - (offset + sequenceLength + this.overlapLength * 2 - audioFloatBuffer.length); i < this.overlapLength; ++i) {
                this.pMidBuffer[i] = 0.0f;
            }
        }
        System.arraycopy(audioFloatBuffer, offset + sequenceLength + this.overlapLength, this.pMidBuffer, 0, copyMax);
        assert (this.outputFloatBuffer.length == this.getOutputBufferSize());
        audioEvent.setFloatBuffer(this.outputFloatBuffer);
        audioEvent.setOverlap(0);
        if (this.newParameters != null) {
            this.applyNewParameters();
            this.dispatcher.setStepSizeAndOverlap(this.getInputBufferSize(), this.getOverlap());
        }
        return true;
    }

    @Override
    public void processingFinished() {
    }

    public static class Parameters {
        private final int sequenceMs;
        private final int seekWindowMs;
        private final int overlapMs;
        private final double tempo;
        private final double sampleRate;

        public Parameters(double tempo, double sampleRate, int newSequenceMs, int newSeekWindowMs, int newOverlapMs) {
            this.tempo = tempo;
            this.sampleRate = sampleRate;
            this.overlapMs = newOverlapMs;
            this.seekWindowMs = newSeekWindowMs;
            this.sequenceMs = newSequenceMs;
        }

        public static Parameters speechDefaults(double tempo, double sampleRate) {
            int sequenceMs = 40;
            int seekWindowMs = 15;
            int overlapMs = 12;
            return new Parameters(tempo, sampleRate, sequenceMs, seekWindowMs, overlapMs);
        }

        public static Parameters musicDefaults(double tempo, double sampleRate) {
            int sequenceMs = 82;
            int seekWindowMs = 28;
            int overlapMs = 12;
            return new Parameters(tempo, sampleRate, sequenceMs, seekWindowMs, overlapMs);
        }

        public static Parameters slowdownDefaults(double tempo, double sampleRate) {
            int sequenceMs = 100;
            int seekWindowMs = 35;
            int overlapMs = 20;
            return new Parameters(tempo, sampleRate, sequenceMs, seekWindowMs, overlapMs);
        }

        public static Parameters automaticDefaults(double tempo, double sampleRate) {
            double tempoLow = 0.5;
            double tempoHigh = 2.0;
            double sequenceMsLow = 125.0;
            double sequenceMsHigh = 50.0;
            double sequenceK = (sequenceMsHigh - sequenceMsLow) / (tempoHigh - tempoLow);
            double sequenceC = sequenceMsLow - sequenceK * tempoLow;
            double seekLow = 25.0;
            double seekHigh = 15.0;
            double seekK = (seekHigh - seekLow) / (tempoHigh - tempoLow);
            double seekC = seekLow - seekK * seekLow;
            int sequenceMs = (int)(sequenceC + sequenceK * tempo + 0.5);
            int seekWindowMs = (int)(seekC + seekK * tempo + 0.5);
            int overlapMs = 12;
            return new Parameters(tempo, sampleRate, sequenceMs, seekWindowMs, overlapMs);
        }

        public double getOverlapMs() {
            return this.overlapMs;
        }

        public double getSequenceMs() {
            return this.sequenceMs;
        }

        public double getSeekWindowMs() {
            return this.seekWindowMs;
        }

        public double getSampleRate() {
            return this.sampleRate;
        }

        public double getTempo() {
            return this.tempo;
        }
    }
}

