/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.beatroot;

import be.tarsos.dsp.beatroot.AgentList;
import be.tarsos.dsp.beatroot.Event;
import be.tarsos.dsp.beatroot.EventList;
import be.tarsos.dsp.beatroot.Induction;
import java.util.ListIterator;

public class Agent {
    public static boolean debug = false;
    public static double POST_MARGIN_FACTOR = 0.3;
    public static double PRE_MARGIN_FACTOR = 0.15;
    public static final double INNER_MARGIN = 0.04;
    public static double MAX_CHANGE = 0.2;
    public static double CONF_FACTOR = 0.5;
    public static final double DEFAULT_CORRECTION_FACTOR = 50.0;
    public static final double DEFAULT_EXPIRY_TIME = 10.0;
    protected static int idCounter = 0;
    protected static double innerMargin;
    protected static double correctionFactor;
    protected static double expiryTime;
    protected static double decayFactor;
    public double preMargin;
    public double postMargin;
    protected int idNumber;
    public double tempoScore;
    public double phaseScore;
    public double topScoreTime;
    public int beatCount;
    public double beatInterval;
    public double initialBeatInterval;
    public double beatTime;
    public EventList events;

    public Agent(double ibi) {
        this.init(ibi);
    }

    public Agent(Agent clone) {
        this.idNumber = idCounter++;
        this.phaseScore = clone.phaseScore;
        this.tempoScore = clone.tempoScore;
        this.topScoreTime = clone.topScoreTime;
        this.beatCount = clone.beatCount;
        this.beatInterval = clone.beatInterval;
        this.initialBeatInterval = clone.initialBeatInterval;
        this.beatTime = clone.beatTime;
        this.events = new EventList(clone.events);
        this.postMargin = clone.postMargin;
        this.preMargin = clone.preMargin;
    }

    protected void init(double ibi) {
        innerMargin = 0.04;
        correctionFactor = 50.0;
        expiryTime = 10.0;
        decayFactor = 0.0;
        this.beatInterval = ibi;
        this.initialBeatInterval = ibi;
        this.postMargin = ibi * POST_MARGIN_FACTOR;
        this.preMargin = ibi * PRE_MARGIN_FACTOR;
        this.idNumber = idCounter++;
        this.phaseScore = 0.0;
        this.tempoScore = 0.0;
        this.topScoreTime = 0.0;
        this.beatCount = 0;
        this.beatTime = -1.0;
        this.events = new EventList();
    }

    public void print() {
        this.print(100);
    }

    public void print(int level) {
        System.out.printf("\tAg#%4d: %5.3f", this.idNumber, this.beatInterval);
        if (level >= 1) {
            System.out.printf("  Beat#%3d  Time=%7.3f  Score=%4.2f:P%4.2f:%3.1f", this.beatCount, this.beatTime, this.tempoScore, this.phaseScore, this.topScoreTime);
        }
        if (level >= 2) {
            System.out.println();
        }
        if (level >= 3) {
            this.events.print();
        }
    }

    protected void accept(Event e, double err, int beats) {
        this.beatTime = e.keyDown;
        this.events.add(e);
        if (Math.abs(this.initialBeatInterval - this.beatInterval - err / correctionFactor) < MAX_CHANGE * this.initialBeatInterval) {
            this.beatInterval += err / correctionFactor;
        }
        this.beatCount += beats;
        double conFactor = 1.0 - CONF_FACTOR * err / (err > 0.0 ? this.postMargin : -this.preMargin);
        if (decayFactor > 0.0) {
            double memFactor = 1.0 - 1.0 / this.threshold(this.beatCount, 1.0, decayFactor);
            this.phaseScore = memFactor * this.phaseScore + (1.0 - memFactor) * conFactor * e.salience;
        } else {
            this.phaseScore += conFactor * e.salience;
        }
        if (debug) {
            this.print(1);
            System.out.printf("  Err=" + (err < 0.0 ? "" : "+") + "%5.3f" + (Math.abs(err) > innerMargin ? (char)'*' : ' ') + "%5.3f\n", err, conFactor);
        }
    }

    private double threshold(double value, double min, double max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public boolean considerAsBeat(Event e, AgentList a) {
        if (this.beatTime < 0.0) {
            this.accept(e, 0.0, 1);
            return true;
        }
        if (e.keyDown - this.events.l.getLast().keyDown > expiryTime) {
            this.phaseScore = -1.0;
            return false;
        }
        double beats = Math.round((e.keyDown - this.beatTime) / this.beatInterval);
        double err = e.keyDown - this.beatTime - beats * this.beatInterval;
        if (beats > 0.0 && -this.preMargin <= err && err <= this.postMargin) {
            if (Math.abs(err) > innerMargin) {
                a.add(new Agent(this));
            }
            this.accept(e, err, (int)beats);
            return true;
        }
        return false;
    }

    protected void fillBeats() {
        this.fillBeats(-1.0);
    }

    public void fillBeats(double start) {
        double prevBeat = 0.0;
        ListIterator<Event> list2 = this.events.listIterator();
        if (list2.hasNext()) {
            prevBeat = list2.next().keyDown;
            list2.previous();
        }
        while (list2.hasNext()) {
            double beats;
            double nextBeat = list2.next().keyDown;
            list2.previous();
            double currentInterval = (nextBeat - prevBeat) / beats;
            for (beats = (double)Math.round((nextBeat - prevBeat) / this.beatInterval - 0.01); nextBeat > start && beats > 1.5; beats -= 1.0) {
                prevBeat += currentInterval;
                if (debug) {
                    System.out.printf("Insert beat at: %8.3f (n=%1.0f)\n", prevBeat, beats - 1.0);
                }
                list2.add(this.newBeat(prevBeat, 0));
            }
            prevBeat = nextBeat;
            list2.next();
        }
    }

    private Event newBeat(double time, int beatNum) {
        return new Event(time, time, time, 56, 64, beatNum, 0.0, 1);
    }

    public void showTracking(EventList allEvents) {
        this.showTracking(allEvents, 1.0);
    }

    public void showTracking(EventList allEvents, double level) {
        int count = 1;
        ListIterator<Event> beats = this.events.listIterator();
        ListIterator<Event> all = allEvents.listIterator();
        if (!beats.hasNext()) {
            System.err.println("No beats found");
            return;
        }
        double prevBeat = this.events.l.getFirst().keyDown;
        System.out.print("Beat  (IBI)   BeatTime   Other Events");
        boolean first = true;
        while (all.hasNext()) {
            double nextBeat;
            int j;
            int gapCount;
            double gap;
            Event currentEvent = all.next();
            Event currentBeat = null;
            while (beats.hasNext()) {
                currentBeat = beats.next();
                if (currentBeat.keyDown > currentEvent.keyDown + Induction.clusterWidth) break;
                gap = currentBeat.keyDown - prevBeat;
                gapCount = (int)Math.round(gap / this.beatInterval);
                for (j = 1; j < gapCount; ++j) {
                    nextBeat = prevBeat + gap / (double)gapCount;
                    System.out.printf("\n%4d (%5.3f) [%7.3f ]", count++, nextBeat - prevBeat, nextBeat);
                    prevBeat = nextBeat;
                }
                System.out.printf("\n%4d (%5.3f) ", count++, currentEvent.keyDown - prevBeat);
                prevBeat = currentBeat.keyDown;
                currentBeat = null;
                first = false;
            }
            if (currentBeat != null && currentBeat.keyDown > currentEvent.keyDown) {
                gap = currentBeat.keyDown - prevBeat;
                gapCount = (int)Math.round(gap / this.beatInterval);
                for (j = 1; j < gapCount && !((nextBeat = prevBeat + gap / (double)gapCount) >= currentEvent.keyDown); ++j) {
                    System.out.printf("\n%4d (%5.3f) [%7.3f ]", count++, nextBeat - prevBeat, nextBeat);
                    prevBeat = nextBeat;
                }
                first = false;
            }
            if (first) {
                System.out.print("\n                       ");
            }
            System.out.printf("%8.3f%c ", currentEvent.keyDown, Character.valueOf(Math.abs(currentEvent.scoreBeat / level - (double)Math.round(currentEvent.scoreBeat / level)) < 0.001 ? (char)'*' : ' '));
            first = false;
        }
        System.out.println();
    }
}

