/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.beatroot;

import be.tarsos.dsp.beatroot.Event;
import be.tarsos.dsp.beatroot.Flags;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;

public class EventList {
    public LinkedList<Event> l = new LinkedList();
    protected static boolean timingCorrection = false;
    protected static double timingDisplacement = 0.0;
    protected static int clockUnits = 480;
    protected static int clockRate = 500000;
    protected static double metricalLevel = 0.0;
    public static final double UNKNOWN = Double.NaN;
    protected static boolean noMelody = false;
    protected static boolean onlyMelody = false;
    protected static Flags flags = new Flags();

    public EventList() {
    }

    public EventList(EventList e) {
        this();
        ListIterator<Event> it = e.listIterator();
        while (it.hasNext()) {
            this.add(it.next());
        }
    }

    public EventList(Event[] e) {
        this();
        for (int i = 0; i < e.length; ++i) {
            this.add(e[i]);
        }
    }

    public void add(Event e) {
        this.l.add(e);
    }

    public void add(EventList ev) {
        this.l.addAll(ev.l);
    }

    public void insert(Event newEvent, boolean uniqueTimes) {
        ListIterator<Event> li = this.l.listIterator();
        while (li.hasNext()) {
            int sgn = newEvent.compareTo((Event)li.next());
            if (sgn < 0) {
                li.previous();
                break;
            }
            if (!uniqueTimes || sgn != 0) continue;
            li.remove();
            break;
        }
        li.add(newEvent);
    }

    public ListIterator<Event> listIterator() {
        return this.l.listIterator();
    }

    public Iterator<Event> iterator() {
        return this.l.iterator();
    }

    public int size() {
        return this.l.size();
    }

    public Event[] toArray() {
        return this.toArray(0);
    }

    public double[] toOnsetArray() {
        double[] d = new double[this.l.size()];
        int i = 0;
        Iterator it = this.l.iterator();
        while (it.hasNext()) {
            d[i] = ((Event)it.next()).keyDown;
            ++i;
        }
        return d;
    }

    public Event[] toArray(int match) {
        int count = 0;
        for (Event e : this.l) {
            if (match != 0 && e.midiCommand != match) continue;
            ++count;
        }
        Event[] a = new Event[count];
        int i = 0;
        for (Event e : this.l) {
            if (match != 0 && e.midiCommand != match) continue;
            a[i++] = e;
        }
        return a;
    }

    public void writeBinary(String fileName) {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(fileName));
            oos.writeObject(this);
            oos.close();
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    public static EventList readBinary(String fileName) {
        try {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(fileName));
            EventList e = (EventList)ois.readObject();
            ois.close();
            return e;
        }
        catch (IOException e) {
            System.err.println(e);
            return null;
        }
        catch (ClassNotFoundException e) {
            System.err.println(e);
            return null;
        }
    }

    public void print() {
        Iterator i = this.l.iterator();
        while (i.hasNext()) {
            ((Event)i.next()).print(flags);
        }
    }

    public static void setTimingCorrection(double corr) {
        timingCorrection = corr >= 0.0;
        timingDisplacement = corr;
    }
}

