/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.beatroot;

import be.tarsos.dsp.beatroot.Agent;
import be.tarsos.dsp.beatroot.AgentList;
import be.tarsos.dsp.beatroot.Event;
import be.tarsos.dsp.beatroot.EventList;
import java.util.ListIterator;

public class Induction {
    public static double clusterWidth = 0.025;
    public static double minIOI = 0.07;
    public static double maxIOI = 2.5;
    public static double minIBI = 0.3;
    public static double maxIBI = 1.0;
    public static int topN = 10;
    public static boolean debug = false;

    public static AgentList beatInduction(EventList events) {
        double err;
        int degree;
        double ratio;
        int j;
        int i;
        int b;
        int intervals = 0;
        int[] bestn = new int[topN];
        int maxClusterCount = (int)Math.ceil((maxIOI - minIOI) / clusterWidth);
        double[] clusterMean = new double[maxClusterCount];
        int[] clusterSize = new int[maxClusterCount];
        int[] clusterScore = new int[maxClusterCount];
        ListIterator<Event> ptr1 = events.listIterator();
        block0: while (ptr1.hasNext()) {
            Event e1 = ptr1.next();
            ListIterator<Event> ptr2 = events.listIterator();
            Event e2 = ptr2.next();
            while (e2 != e1) {
                e2 = ptr2.next();
            }
            while (ptr2.hasNext()) {
                e2 = ptr2.next();
                double ioi = e2.keyDown - e1.keyDown;
                if (ioi < minIOI) continue;
                if (ioi > maxIOI) continue block0;
                for (b = 0; b < intervals; ++b) {
                    if (!(Math.abs(clusterMean[b] - ioi) < clusterWidth)) continue;
                    if (b < intervals - 1 && Math.abs(clusterMean[b + 1] - ioi) < Math.abs(clusterMean[b] - ioi)) {
                        ++b;
                    }
                    clusterMean[b] = (clusterMean[b] * (double)clusterSize[b] + ioi) / (double)(clusterSize[b] + 1);
                    int n = b;
                    clusterSize[n] = clusterSize[n] + 1;
                    break;
                }
                if (b != intervals) continue;
                if (intervals == maxClusterCount) {
                    System.err.println("Warning: Too many clusters");
                    continue;
                }
                ++intervals;
                while (b > 0 && clusterMean[b - 1] > ioi) {
                    clusterMean[b] = clusterMean[b - 1];
                    clusterSize[b] = clusterSize[b - 1];
                    --b;
                }
                clusterMean[b] = ioi;
                clusterSize[b] = 1;
            }
        }
        if (debug) {
            System.out.println("Inter-onset interval histogram:\nStartMatlabCode\nioi = [");
            for (b = 0; b < intervals; ++b) {
                System.out.printf("%4d %7.3f %7d\n", b, clusterMean[b], clusterSize[b]);
            }
            System.out.println("]; ioiclusters(ioi, name);\nEndMatlabCode\n");
        }
        for (b = 0; b < intervals; ++b) {
            for (i = b + 1; i < intervals; ++i) {
                if (!(Math.abs(clusterMean[b] - clusterMean[i]) < clusterWidth)) continue;
                clusterMean[b] = (clusterMean[b] * (double)clusterSize[b] + clusterMean[i] * (double)clusterSize[i]) / (double)(clusterSize[b] + clusterSize[i]);
                clusterSize[b] = clusterSize[b] + clusterSize[i];
                --intervals;
                for (j = i + 1; j <= intervals; ++j) {
                    clusterMean[j - 1] = clusterMean[j];
                    clusterSize[j - 1] = clusterSize[j];
                }
            }
        }
        if (intervals == 0) {
            return new AgentList();
        }
        for (b = 0; b < intervals; ++b) {
            clusterScore[b] = 10 * clusterSize[b];
        }
        bestn[0] = 0;
        int bestCount = 1;
        block10: for (b = 0; b < intervals; ++b) {
            for (i = 0; i <= bestCount; ++i) {
                if (i >= topN || i != bestCount && clusterScore[b] <= clusterScore[bestn[i]]) continue;
                if (bestCount < topN) {
                    ++bestCount;
                }
                for (j = bestCount - 1; j > i; --j) {
                    bestn[j] = bestn[j - 1];
                }
                bestn[i] = b;
                continue block10;
            }
        }
        if (debug) {
            System.out.println("Best " + bestCount + " clusters (before):");
            for (b = 0; b < bestCount; ++b) {
                System.out.printf("%5.3f : %5d\n", clusterMean[bestn[b]], clusterScore[bestn[b]]);
            }
        }
        for (b = 0; b < intervals; ++b) {
            for (i = b + 1; i < intervals; ++i) {
                ratio = clusterMean[b] / clusterMean[i];
                boolean submult = ratio < 1.0;
                degree = submult ? (int)Math.round(1.0 / ratio) : (int)Math.round(ratio);
                if (degree < 2 || degree > 8) continue;
                err = submult ? Math.abs(clusterMean[b] * (double)degree - clusterMean[i]) : Math.abs(clusterMean[b] - clusterMean[i] * (double)degree);
                double d = submult ? clusterWidth : clusterWidth * (double)degree;
                if (!(err < d)) continue;
                degree = degree >= 5 ? 1 : 6 - degree;
                int n = b;
                clusterScore[n] = clusterScore[n] + degree * clusterSize[i];
                int n2 = i;
                clusterScore[n2] = clusterScore[n2] + degree * clusterSize[b];
            }
        }
        if (debug) {
            System.out.println("Best " + bestCount + " clusters (after):");
            for (b = 0; b < bestCount; ++b) {
                System.out.printf("%5.3f : %5d\n", clusterMean[bestn[b]], clusterScore[bestn[b]]);
            }
        }
        if (debug) {
            System.out.println("Inter-onset interval histogram 2:");
            for (b = 0; b < intervals; ++b) {
                System.out.printf("%3d: %5.3f : %3d (score: %5d)\n", b, clusterMean[b], clusterSize[b], clusterScore[b]);
            }
        }
        AgentList a = new AgentList();
        for (int index = 0; index < bestCount; ++index) {
            double beat;
            b = bestn[index];
            double newSum = clusterMean[b] * (double)clusterScore[b];
            int newWeight = clusterScore[b];
            for (i = 0; i < intervals; ++i) {
                if (i == b) continue;
                ratio = clusterMean[b] / clusterMean[i];
                if (ratio < 1.0) {
                    degree = (int)Math.round(1.0 / ratio);
                    if (degree < 2 || degree > 8 || !((err = Math.abs(clusterMean[b] * (double)degree - clusterMean[i])) < clusterWidth)) continue;
                    newSum += clusterMean[i] / (double)degree * (double)clusterScore[i];
                    newWeight += clusterScore[i];
                    continue;
                }
                degree = (int)Math.round(ratio);
                if (degree < 2 || degree > 8 || !((err = Math.abs(clusterMean[b] - (double)degree * clusterMean[i])) < clusterWidth * (double)degree)) continue;
                newSum += clusterMean[i] * (double)degree * (double)clusterScore[i];
                newWeight += clusterScore[i];
            }
            for (beat = newSum / (double)newWeight; beat < minIBI; beat *= 2.0) {
            }
            while (beat > maxIBI) {
                beat /= 2.0;
            }
            if (!(beat >= minIBI)) continue;
            a.add(new Agent(beat));
            if (!debug) continue;
            System.out.printf(" %5.3f", beat);
        }
        if (debug) {
            System.out.println(" IBI");
        }
        return a;
    }

    protected static int top(int low) {
        return low + 25;
    }

    public static void newInduction(EventList events) {
        int MAX_MS = 2500;
        int[] count = new int[2500];
        for (int i = 0; i < 2500; ++i) {
            count[i] = 0;
        }
        ListIterator<Event> ptr1 = events.listIterator();
        block1: while (ptr1.hasNext()) {
            Event e1 = ptr1.next();
            ListIterator<Event> ptr2 = events.listIterator();
            Event e2 = ptr2.next();
            while (e2 != e1) {
                e2 = ptr2.next();
            }
            while (ptr2.hasNext()) {
                e2 = ptr2.next();
                int diff = (int)Math.round((e1.keyDown - e2.keyDown) * 1000.0);
                if (diff >= 2500) continue block1;
                int n = diff;
                count[n] = count[n] + 1;
            }
        }
        int MAX_CL = 10;
        int[] cluster = new int[10];
        int[] csize = new int[10];
        for (int clnum = 0; clnum < 10; ++clnum) {
            int hi;
            int sum = 0;
            int max = 0;
            int maxp = 0;
            int lo = hi = 70;
            while (hi < 2500) {
                if (hi >= Induction.top(lo)) {
                    sum -= count[lo++];
                    continue;
                }
                if ((sum += count[hi++]) <= max) continue;
                max = sum;
                maxp = lo;
            }
            if (max == 0) break;
            hi = Induction.top(maxp);
            if (hi > 2500) {
                hi = 2500;
            }
            sum = 0;
            int cnt = 0;
            for (lo = maxp; lo < hi; ++lo) {
                sum += lo * count[lo];
                cnt += count[lo];
                count[lo] = 0;
            }
            if (cnt != max) {
                System.err.println("Rounding error in newInduction");
            }
            cluster[clnum] = sum / cnt;
            csize[clnum] = cnt;
            System.out.printf(" %5.3f", (double)sum / 1000.0 / (double)cnt);
        }
        System.out.println(" IBI");
    }
}

