/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.beatroot;

import java.util.LinkedList;

public class Peaks {
    public static boolean debug = false;
    public static int pre = 3;
    public static int post = 1;

    public static int findPeaks(double[] data2, int[] peaks, int width) {
        int peakCount = 0;
        int maxp = 0;
        int end2 = data2.length;
        for (int mid = 0; mid < end2; ++mid) {
            int j;
            int stop;
            int i = mid - width;
            if (i < 0) {
                i = 0;
            }
            if ((stop = mid + width + 1) > data2.length) {
                stop = data2.length;
            }
            maxp = i++;
            while (i < stop) {
                if (data2[i] > data2[maxp]) {
                    maxp = i;
                }
                ++i;
            }
            if (maxp != mid) continue;
            for (j = peakCount; j > 0 && !(data2[maxp] <= data2[peaks[j - 1]]); --j) {
                if (j >= peaks.length) continue;
                peaks[j] = peaks[j - 1];
            }
            if (j != peaks.length) {
                peaks[j] = maxp;
            }
            if (peakCount == peaks.length) continue;
            ++peakCount;
        }
        return peakCount;
    }

    public static LinkedList<Integer> findPeaks(double[] data2, int width, double threshold) {
        return Peaks.findPeaks(data2, width, threshold, 0.0, false);
    }

    public static LinkedList<Integer> findPeaks(double[] data2, int width, double threshold, double decayRate, boolean isRelative) {
        LinkedList<Integer> peaks = new LinkedList<Integer>();
        int maxp = 0;
        int end2 = data2.length;
        double av = data2[0];
        for (int mid = 0; mid < end2; ++mid) {
            int stop;
            int i;
            if ((av = decayRate * av + (1.0 - decayRate) * data2[mid]) < data2[mid]) {
                av = data2[mid];
            }
            if ((i = mid - width) < 0) {
                i = 0;
            }
            if ((stop = mid + width + 1) > data2.length) {
                stop = data2.length;
            }
            maxp = i++;
            while (i < stop) {
                if (data2[i] > data2[maxp]) {
                    maxp = i;
                }
                ++i;
            }
            if (maxp != mid) continue;
            if (Peaks.overThreshold(data2, maxp, width, threshold, isRelative, av)) {
                if (debug) {
                    System.out.println(" peak");
                }
                peaks.add(new Integer(maxp));
                continue;
            }
            if (!debug) continue;
            System.out.println();
        }
        return peaks;
    }

    public static double expDecayWithHold(double av, double decayRate, double[] data2, int start, int stop) {
        while (start < stop) {
            if ((av = decayRate * av + (1.0 - decayRate) * data2[start]) < data2[start]) {
                av = data2[start];
            }
            ++start;
        }
        return av;
    }

    public static boolean overThreshold(double[] data2, int index, int width, double threshold, boolean isRelative, double av) {
        if (debug) {
            System.out.printf("%4d : %6.3f     Av1: %6.3f    ", index, data2[index], av);
        }
        if (data2[index] < av) {
            return false;
        }
        if (isRelative) {
            int iStop;
            int iStart = index - pre * width;
            if (iStart < 0) {
                iStart = 0;
            }
            if ((iStop = index + post * width) > data2.length) {
                iStop = data2.length;
            }
            double sum = 0.0;
            int count = iStop - iStart;
            while (iStart < iStop) {
                sum += data2[iStart++];
            }
            if (debug) {
                System.out.printf("    %6.3f    %6.3f   ", sum / (double)count, data2[index] - sum / (double)count - threshold);
            }
            return data2[index] > sum / (double)count + threshold;
        }
        return data2[index] > threshold;
    }

    public static void normalise(double[] data2) {
        double sx = 0.0;
        double sxx = 0.0;
        for (int i = 0; i < data2.length; ++i) {
            sx += data2[i];
            sxx += data2[i] * data2[i];
        }
        double mean = sx / (double)data2.length;
        double sd = Math.sqrt((sxx - sx * mean) / (double)data2.length);
        if (sd == 0.0) {
            sd = 1.0;
        }
        for (int i = 0; i < data2.length; ++i) {
            data2[i] = (data2[i] - mean) / sd;
        }
    }

    public static void getSlope(double[] data2, double hop, int n, double[] slope) {
        int i;
        int j = 0;
        double sx = 0.0;
        double sxx = 0.0;
        double sy = 0.0;
        double sxy = 0.0;
        for (i = 0; i < n; ++i) {
            double t = (double)i * hop;
            sx += t;
            sxx += t * t;
            sy += data2[i];
            sxy += t * data2[i];
        }
        double delta = (double)n * sxx - sx * sx;
        while (j < n / 2) {
            slope[j] = ((double)n * sxy - sx * sy) / delta;
            ++j;
        }
        while (j < data2.length - (n + 1) / 2) {
            slope[j] = ((double)n * sxy - sx * sy) / delta;
            sxy += hop * ((double)n * data2[i] - (sy += data2[i] - data2[i - n]));
            ++j;
            ++i;
        }
        while (j < data2.length) {
            slope[j] = ((double)n * sxy - sx * sy) / delta;
            ++j;
        }
    }

    public static double min(double[] arr) {
        return arr[Peaks.imin(arr)];
    }

    public static double max(double[] arr) {
        return arr[Peaks.imax(arr)];
    }

    public static int imin(double[] arr) {
        int i = 0;
        for (int j = 1; j < arr.length; ++j) {
            if (!(arr[j] < arr[i])) continue;
            i = j;
        }
        return i;
    }

    public static int imax(double[] arr) {
        int i = 0;
        for (int j = 1; j < arr.length; ++j) {
            if (!(arr[j] > arr[i])) continue;
            i = j;
        }
        return i;
    }
}

