/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.effects;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;

public class DelayEffect
implements AudioProcessor {
    private double sampleRate;
    private float[] echoBuffer;
    private int position;
    private float decay;
    private double newEchoLength;

    public DelayEffect(double echoLength, double decay, double sampleRate) {
        this.sampleRate = sampleRate;
        this.setDecay(decay);
        this.setEchoLength(echoLength);
        this.applyNewEchoLength();
    }

    public void setEchoLength(double newEchoLength) {
        this.newEchoLength = newEchoLength;
    }

    private void applyNewEchoLength() {
        if (this.newEchoLength != -1.0) {
            float[] newEchoBuffer = new float[(int)(this.sampleRate * this.newEchoLength)];
            if (this.echoBuffer != null) {
                for (int i = 0; i < newEchoBuffer.length; ++i) {
                    if (this.position >= this.echoBuffer.length) {
                        this.position = 0;
                    }
                    newEchoBuffer[i] = this.echoBuffer[this.position];
                    ++this.position;
                }
            }
            this.echoBuffer = newEchoBuffer;
            this.newEchoLength = -1.0;
        }
    }

    public void setDecay(double newDecay) {
        this.decay = (float)newDecay;
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        int overlap;
        float[] audioFloatBuffer = audioEvent.getFloatBuffer();
        for (int i = overlap = audioEvent.getOverlap(); i < audioFloatBuffer.length; ++i) {
            if (this.position >= this.echoBuffer.length) {
                this.position = 0;
            }
            audioFloatBuffer[i] = audioFloatBuffer[i] + this.echoBuffer[this.position] * this.decay;
            this.echoBuffer[this.position] = audioFloatBuffer[i];
            ++this.position;
        }
        this.applyNewEchoLength();
        return true;
    }

    @Override
    public void processingFinished() {
    }
}

