/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.filters;

import be.tarsos.dsp.filters.IIRFilter;

public class BandPass
extends IIRFilter {
    private float bw;

    public BandPass(float freq, float bandWidth, float sampleRate) {
        super(freq, sampleRate);
        this.setBandWidth(bandWidth);
    }

    public void setBandWidth(float bandWidth) {
        this.bw = bandWidth / this.getSampleRate();
        this.calcCoeff();
    }

    public float getBandWidth() {
        return this.bw * this.getSampleRate();
    }

    @Override
    protected void calcCoeff() {
        float R = 1.0f - 3.0f * this.bw;
        float fracFreq = this.getFrequency() / this.getSampleRate();
        float T = 2.0f * (float)Math.cos(Math.PI * 2 * (double)fracFreq);
        float K = (1.0f - R * T + R * R) / (2.0f - T);
        this.a = new float[]{1.0f - K, (K - R) * T, R * R - K};
        this.b = new float[]{R * T, -R * R};
    }
}

