/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.io;

import be.tarsos.dsp.io.TarsosDSPAudioFormat;
import be.tarsos.dsp.io.TarsosDSPAudioInputStream;
import java.io.IOException;
import java.io.InputStream;

public class UniversalAudioInputStream
implements TarsosDSPAudioInputStream {
    private final InputStream underlyingStream;
    private final TarsosDSPAudioFormat format;

    public UniversalAudioInputStream(InputStream underlyingInputStream, TarsosDSPAudioFormat format) {
        this.underlyingStream = underlyingInputStream;
        this.format = format;
    }

    @Override
    public long skip(long bytesToSkip) throws IOException {
        int bytesSkipped = 0;
        int i = 0;
        while ((long)i < bytesToSkip) {
            int theByte = this.underlyingStream.read();
            if (theByte != -1) {
                ++bytesSkipped;
            }
            ++i;
        }
        return bytesSkipped;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.underlyingStream.read(b, off, len);
    }

    @Override
    public void close() throws IOException {
        this.underlyingStream.close();
    }

    @Override
    public TarsosDSPAudioFormat getFormat() {
        return this.format;
    }

    @Override
    public long getFrameLength() {
        return -1L;
    }
}

