/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.io.jvm;

import be.tarsos.dsp.AudioDispatcher;
import be.tarsos.dsp.io.PipedAudioStream;
import be.tarsos.dsp.io.TarsosDSPAudioFloatConverter;
import be.tarsos.dsp.io.TarsosDSPAudioInputStream;
import be.tarsos.dsp.io.jvm.JVMAudioInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;

public class AudioDispatcherFactory {
    public static AudioDispatcher fromDefaultMicrophone(int audioBufferSize, int bufferOverlap) throws LineUnavailableException {
        return AudioDispatcherFactory.fromDefaultMicrophone(44100, audioBufferSize, bufferOverlap);
    }

    public static AudioDispatcher fromDefaultMicrophone(int sampleRate, int audioBufferSize, int bufferOverlap) throws LineUnavailableException {
        AudioFormat format = new AudioFormat(sampleRate, 16, 1, true, true);
        TargetDataLine line = AudioSystem.getTargetDataLine(format);
        line.open(format, audioBufferSize);
        line.start();
        AudioInputStream stream = new AudioInputStream(line);
        JVMAudioInputStream audioStream = new JVMAudioInputStream(stream);
        return new AudioDispatcher(audioStream, audioBufferSize, bufferOverlap);
    }

    public static AudioDispatcher fromByteArray(byte[] byteArray, AudioFormat audioFormat, int audioBufferSize, int bufferOverlap) throws UnsupportedAudioFileException {
        ByteArrayInputStream bais = new ByteArrayInputStream(byteArray);
        long length = byteArray.length / audioFormat.getFrameSize();
        AudioInputStream stream = new AudioInputStream(bais, audioFormat, length);
        JVMAudioInputStream audioStream = new JVMAudioInputStream(stream);
        return new AudioDispatcher(audioStream, audioBufferSize, bufferOverlap);
    }

    public static AudioDispatcher fromURL(URL audioURL, int audioBufferSize, int bufferOverlap) throws UnsupportedAudioFileException, IOException {
        AudioInputStream stream = AudioSystem.getAudioInputStream(audioURL);
        JVMAudioInputStream audioStream = new JVMAudioInputStream(stream);
        return new AudioDispatcher(audioStream, audioBufferSize, bufferOverlap);
    }

    public static AudioDispatcher fromPipe(String source, int targetSampleRate, int audioBufferSize, int bufferOverlap) {
        if (new File(source).exists() && new File(source).isFile() && new File(source).canRead()) {
            PipedAudioStream f = new PipedAudioStream(source);
            TarsosDSPAudioInputStream audioStream = f.getMonoStream(targetSampleRate);
            return new AudioDispatcher(audioStream, audioBufferSize, bufferOverlap);
        }
        throw new IllegalArgumentException("The file " + source + " is not a readable file. Does it exist?");
    }

    public static AudioDispatcher fromFile(File audioFile, int audioBufferSize, int bufferOverlap) throws UnsupportedAudioFileException, IOException {
        AudioInputStream stream = AudioSystem.getAudioInputStream(audioFile);
        JVMAudioInputStream audioStream = new JVMAudioInputStream(stream);
        return new AudioDispatcher(audioStream, audioBufferSize, bufferOverlap);
    }

    public static AudioDispatcher fromFloatArray(float[] floatArray, int sampleRate, int audioBufferSize, int bufferOverlap) throws UnsupportedAudioFileException {
        AudioFormat audioFormat = new AudioFormat(sampleRate, 16, 1, true, false);
        TarsosDSPAudioFloatConverter converter = TarsosDSPAudioFloatConverter.getConverter(JVMAudioInputStream.toTarsosDSPFormat(audioFormat));
        byte[] byteArray = new byte[floatArray.length * audioFormat.getFrameSize()];
        converter.toByteArray(floatArray, byteArray);
        return AudioDispatcherFactory.fromByteArray(byteArray, audioFormat, audioBufferSize, bufferOverlap);
    }
}

