/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.onsets;

import be.tarsos.dsp.AudioDispatcher;
import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;
import be.tarsos.dsp.beatroot.Peaks;
import be.tarsos.dsp.onsets.OnsetDetector;
import be.tarsos.dsp.onsets.OnsetHandler;
import be.tarsos.dsp.onsets.PrintOnsetHandler;
import be.tarsos.dsp.util.fft.FFT;
import be.tarsos.dsp.util.fft.ScaledHammingWindow;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;

public class BeatRootSpectralFluxOnsetDetector
implements AudioProcessor,
OnsetDetector {
    private double frameRMS;
    private int frameCount;
    private double ltAverage;
    private float[] reBuffer;
    private float[] imBuffer;
    private double[] spectralFlux;
    private int[] freqMap;
    private int freqMapSize;
    private float[] prevFrame;
    private double[] newFrame;
    private double[][] frames;
    private double[] energy;
    protected int hopSize;
    protected int fftSize;
    private int totalFrames;
    public static double silenceThreshold = 4.0E-4;
    public static double rangeThreshold = 10.0;
    public static int normaliseMode = 2;
    public static int energyOversampleFactor = 2;
    private OnsetHandler handler;
    private double hopTime;
    private final FFT fft;

    public BeatRootSpectralFluxOnsetDetector(AudioDispatcher d, int fftSize, int hopSize) {
        this.hopSize = hopSize;
        this.hopTime = (float)hopSize / d.getFormat().getSampleRate();
        this.fftSize = fftSize;
        System.err.println("Please use the ComplexOnset detector: BeatRootSpectralFluxOnsetDetector does currenlty not support streaming");
        int durationInFrames = -1000;
        this.totalFrames = durationInFrames / hopSize + 4;
        this.energy = new double[this.totalFrames * energyOversampleFactor];
        this.spectralFlux = new double[this.totalFrames];
        this.reBuffer = new float[fftSize / 2];
        this.imBuffer = new float[fftSize / 2];
        this.prevFrame = new float[fftSize / 2];
        this.makeFreqMap(fftSize, d.getFormat().getSampleRate());
        this.newFrame = new double[this.freqMapSize];
        this.frames = new double[this.totalFrames][this.freqMapSize];
        this.handler = new PrintOnsetHandler();
        this.fft = new FFT(fftSize, new ScaledHammingWindow());
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        int i;
        int i2;
        this.frameRMS = audioEvent.getRMS() / 2.0;
        float[] audioBuffer = (float[])audioEvent.getFloatBuffer().clone();
        Arrays.fill(this.imBuffer, 0.0f);
        this.fft.powerPhaseFFTBeatRootOnset(audioBuffer, this.reBuffer, this.imBuffer);
        Arrays.fill(this.newFrame, 0.0);
        double flux = 0.0;
        for (i2 = 0; i2 < this.fftSize / 2; ++i2) {
            if (this.reBuffer[i2] > this.prevFrame[i2]) {
                flux += (double)(this.reBuffer[i2] - this.prevFrame[i2]);
            }
            int n = this.freqMap[i2];
            this.newFrame[n] = this.newFrame[n] + (double)this.reBuffer[i2];
        }
        this.spectralFlux[this.frameCount] = flux;
        for (i2 = 0; i2 < this.freqMapSize; ++i2) {
            this.frames[this.frameCount][i2] = this.newFrame[i2];
        }
        int sz = (this.fftSize - this.hopSize) / energyOversampleFactor;
        int index = this.hopSize;
        for (int j = 0; j < energyOversampleFactor; ++j) {
            double newEnergy = 0.0;
            for (int i3 = 0; i3 < sz; ++i3) {
                newEnergy += (double)(audioBuffer[index] * audioBuffer[index]);
                if (++index != this.fftSize) continue;
                index = 0;
            }
            this.energy[this.frameCount * BeatRootSpectralFluxOnsetDetector.energyOversampleFactor + j] = newEnergy / (double)sz <= 1.0E-6 ? 0.0 : Math.log(newEnergy / (double)sz) + 13.816;
        }
        double decay = this.frameCount >= 200 ? 0.99 : (this.frameCount < 100 ? 0.0 : (double)(this.frameCount - 100) / 100.0);
        this.ltAverage = this.ltAverage == 0.0 ? this.frameRMS : this.ltAverage * decay + this.frameRMS * (1.0 - decay);
        if (this.frameRMS <= silenceThreshold) {
            for (i = 0; i < this.freqMapSize; ++i) {
                this.frames[this.frameCount][i] = 0.0;
            }
        } else {
            if (normaliseMode == 1) {
                i = 0;
                while (i < this.freqMapSize) {
                    double[] dArray = this.frames[this.frameCount];
                    int n = i++;
                    dArray[n] = dArray[n] / this.frameRMS;
                }
            } else if (normaliseMode == 2) {
                i = 0;
                while (i < this.freqMapSize) {
                    double[] dArray = this.frames[this.frameCount];
                    int n = i++;
                    dArray[n] = dArray[n] / this.ltAverage;
                }
            }
            for (i = 0; i < this.freqMapSize; ++i) {
                this.frames[this.frameCount][i] = Math.log(this.frames[this.frameCount][i]) + rangeThreshold;
                if (!(this.frames[this.frameCount][i] < 0.0)) continue;
                this.frames[this.frameCount][i] = 0.0;
            }
        }
        float[] tmp = this.prevFrame;
        this.prevFrame = this.reBuffer;
        this.reBuffer = tmp;
        ++this.frameCount;
        return true;
    }

    protected void makeFreqMap(int fftSize, float sampleRate) {
        this.freqMap = new int[fftSize / 2 + 1];
        double binWidth = sampleRate / (float)fftSize;
        int crossoverBin = (int)(2.0 / (Math.pow(2.0, 0.08333333333333333) - 1.0));
        int crossoverMidi = (int)Math.round(Math.log((double)crossoverBin * binWidth / 440.0) / Math.log(2.0) * 12.0 + 69.0);
        int i = 0;
        while (i <= crossoverBin) {
            this.freqMap[i++] = i;
        }
        while (i <= fftSize / 2) {
            double midi = Math.log((double)i * binWidth / 440.0) / Math.log(2.0) * 12.0 + 69.0;
            if (midi > 127.0) {
                midi = 127.0;
            }
            this.freqMap[i++] = crossoverBin + (int)Math.round(midi) - crossoverMidi;
        }
        this.freqMapSize = this.freqMap[i - 1] + 1;
    }

    private void findOnsets(double p1, double p2) {
        LinkedList<Integer> peaks = Peaks.findPeaks(this.spectralFlux, (int)Math.round(0.06 / this.hopTime), p1, p2, true);
        Iterator it = peaks.iterator();
        double minSalience = Peaks.min(this.spectralFlux);
        for (int i = 0; i < peaks.size(); ++i) {
            int index = (Integer)it.next();
            double time = (double)index * this.hopTime;
            double salience = this.spectralFlux[index] - minSalience;
            this.handler.handleOnset(time, salience);
        }
    }

    @Override
    public void setHandler(OnsetHandler handler) {
        this.handler = handler;
    }

    @Override
    public void processingFinished() {
        double p1 = 0.35;
        double p2 = 0.84;
        Peaks.normalise(this.spectralFlux);
        this.findOnsets(p1, p2);
    }
}

