/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.onsets;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;
import be.tarsos.dsp.onsets.OnsetDetector;
import be.tarsos.dsp.onsets.OnsetHandler;
import be.tarsos.dsp.onsets.PrintOnsetHandler;
import be.tarsos.dsp.util.PeakPicker;
import be.tarsos.dsp.util.fft.FFT;
import be.tarsos.dsp.util.fft.HannWindow;

public class ComplexOnsetDetector
implements AudioProcessor,
OnsetDetector {
    private final double silenceThreshold;
    private final double minimumInterOnsetInterval;
    private double lastOnset;
    private double lastOnsetValue;
    private final PeakPicker peakPicker;
    private OnsetHandler handler;
    private final FFT fft;
    private final float[] theta1;
    private final float[] theta2;
    private final float[] oldmag;
    private final float[] dev1;

    public ComplexOnsetDetector(int fftSize, double peakThreshold, double minimumInterOnsetInterval, double silenceThreshold) {
        this.fft = new FFT(fftSize, new HannWindow());
        this.silenceThreshold = silenceThreshold;
        this.minimumInterOnsetInterval = minimumInterOnsetInterval;
        this.peakPicker = new PeakPicker(peakThreshold);
        int rsize = fftSize / 2 + 1;
        this.oldmag = new float[rsize];
        this.dev1 = new float[rsize];
        this.theta1 = new float[rsize];
        this.theta2 = new float[rsize];
        this.handler = new PrintOnsetHandler();
    }

    public ComplexOnsetDetector(int fftSize) {
        this(fftSize, 0.3);
    }

    public ComplexOnsetDetector(int fftSize, double peakThreshold) {
        this(fftSize, peakThreshold, 0.03);
    }

    public ComplexOnsetDetector(int fftSize, double peakThreshold, double minimumInterOnsetInterval) {
        this(fftSize, peakThreshold, minimumInterOnsetInterval, -70.0);
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        this.onsetDetection(audioEvent);
        return true;
    }

    private void onsetDetection(AudioEvent audioEvent) {
        float[] data2 = (float[])audioEvent.getFloatBuffer().clone();
        float[] power = new float[data2.length / 2];
        float[] phase = new float[data2.length / 2];
        this.fft.powerPhaseFFT(data2, power, phase);
        float onsetValue = 0.0f;
        for (int j = 0; j < power.length; ++j) {
            this.dev1[j] = 2.0f * this.theta1[j] - this.theta2[j];
            onsetValue = (float)((double)onsetValue + Math.sqrt(Math.abs(Math.pow(this.oldmag[j], 2.0) + Math.pow(power[j], 2.0) - 2.0 * (double)this.oldmag[j] * (double)power[j] * Math.cos(this.dev1[j] - phase[j]))));
            this.theta2[j] = this.theta1[j];
            this.theta1[j] = phase[j];
            this.oldmag[j] = power[j];
        }
        this.lastOnsetValue = onsetValue;
        boolean isOnset = this.peakPicker.pickPeak(onsetValue);
        if (isOnset) {
            if (audioEvent.isSilence(this.silenceThreshold)) {
                isOnset = false;
            } else {
                double delay = (double)audioEvent.getOverlap() * 4.3 / (double)audioEvent.getSampleRate();
                double onsetTime = audioEvent.getTimeStamp() - delay;
                if (onsetTime - this.lastOnset > this.minimumInterOnsetInterval) {
                    this.handler.handleOnset(onsetTime, this.peakPicker.getLastPeekValue());
                    this.lastOnset = onsetTime;
                }
            }
        }
    }

    @Override
    public void setHandler(OnsetHandler handler) {
        this.handler = handler;
    }

    public void setThreshold(double threshold) {
        this.peakPicker.setThreshold(threshold);
    }

    @Override
    public void processingFinished() {
    }
}

