/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.pitch;

import be.tarsos.dsp.pitch.PitchDetectionResult;
import be.tarsos.dsp.pitch.PitchDetector;
import be.tarsos.dsp.util.fft.FloatFFT;

public final class FastYin
implements PitchDetector {
    private static final double DEFAULT_THRESHOLD = 0.2;
    public static final int DEFAULT_BUFFER_SIZE = 2048;
    public static final int DEFAULT_OVERLAP = 1536;
    private final double threshold;
    private final float sampleRate;
    private final float[] yinBuffer;
    private final PitchDetectionResult result;
    private final float[] audioBufferFFT;
    private final float[] kernel;
    private final float[] yinStyleACF;
    private final FloatFFT fft;

    public FastYin(float audioSampleRate, int bufferSize) {
        this(audioSampleRate, bufferSize, 0.2);
    }

    public FastYin(float audioSampleRate, int bufferSize, double yinThreshold) {
        this.sampleRate = audioSampleRate;
        this.threshold = yinThreshold;
        this.yinBuffer = new float[bufferSize / 2];
        this.audioBufferFFT = new float[2 * bufferSize];
        this.kernel = new float[2 * bufferSize];
        this.yinStyleACF = new float[2 * bufferSize];
        this.fft = new FloatFFT(bufferSize);
        this.result = new PitchDetectionResult();
    }

    @Override
    public PitchDetectionResult getPitch(float[] audioBuffer) {
        float pitchInHertz;
        this.difference(audioBuffer);
        this.cumulativeMeanNormalizedDifference();
        int tauEstimate = this.absoluteThreshold();
        if (tauEstimate != -1) {
            float betterTau = this.parabolicInterpolation(tauEstimate);
            pitchInHertz = this.sampleRate / betterTau;
        } else {
            pitchInHertz = -1.0f;
        }
        this.result.setPitch(pitchInHertz);
        return this.result;
    }

    private void difference(float[] audioBuffer) {
        int j;
        float[] powerTerms = new float[this.yinBuffer.length];
        for (j = 0; j < this.yinBuffer.length; ++j) {
            powerTerms[0] = powerTerms[0] + audioBuffer[j] * audioBuffer[j];
        }
        for (int tau = 1; tau < this.yinBuffer.length; ++tau) {
            powerTerms[tau] = powerTerms[tau - 1] - audioBuffer[tau - 1] * audioBuffer[tau - 1] + audioBuffer[tau + this.yinBuffer.length] * audioBuffer[tau + this.yinBuffer.length];
        }
        for (j = 0; j < audioBuffer.length; ++j) {
            this.audioBufferFFT[2 * j] = audioBuffer[j];
            this.audioBufferFFT[2 * j + 1] = 0.0f;
        }
        this.fft.complexForward(this.audioBufferFFT);
        for (j = 0; j < this.yinBuffer.length; ++j) {
            this.kernel[2 * j] = audioBuffer[this.yinBuffer.length - 1 - j];
            this.kernel[2 * j + 1] = 0.0f;
            this.kernel[2 * j + audioBuffer.length] = 0.0f;
            this.kernel[2 * j + audioBuffer.length + 1] = 0.0f;
        }
        this.fft.complexForward(this.kernel);
        for (j = 0; j < audioBuffer.length; ++j) {
            this.yinStyleACF[2 * j] = this.audioBufferFFT[2 * j] * this.kernel[2 * j] - this.audioBufferFFT[2 * j + 1] * this.kernel[2 * j + 1];
            this.yinStyleACF[2 * j + 1] = this.audioBufferFFT[2 * j + 1] * this.kernel[2 * j] + this.audioBufferFFT[2 * j] * this.kernel[2 * j + 1];
        }
        this.fft.complexInverse(this.yinStyleACF, true);
        for (j = 0; j < this.yinBuffer.length; ++j) {
            this.yinBuffer[j] = powerTerms[0] + powerTerms[j] - 2.0f * this.yinStyleACF[2 * (this.yinBuffer.length - 1 + j)];
        }
    }

    private void cumulativeMeanNormalizedDifference() {
        this.yinBuffer[0] = 1.0f;
        float runningSum = 0.0f;
        for (int tau = 1; tau < this.yinBuffer.length; ++tau) {
            int n = tau;
            this.yinBuffer[n] = this.yinBuffer[n] * ((float)tau / (runningSum += this.yinBuffer[tau]));
        }
    }

    private int absoluteThreshold() {
        int tau;
        for (tau = 2; tau < this.yinBuffer.length; ++tau) {
            if (!((double)this.yinBuffer[tau] < this.threshold)) continue;
            while (tau + 1 < this.yinBuffer.length && this.yinBuffer[tau + 1] < this.yinBuffer[tau]) {
                ++tau;
            }
            this.result.setProbability(1.0f - this.yinBuffer[tau]);
            break;
        }
        if (tau == this.yinBuffer.length || (double)this.yinBuffer[tau] >= this.threshold || (double)this.result.getProbability() > 1.0) {
            tau = -1;
            this.result.setProbability(0.0f);
            this.result.setPitched(false);
        } else {
            this.result.setPitched(true);
        }
        return tau;
    }

    private float parabolicInterpolation(int tauEstimate) {
        float betterTau;
        int x0 = tauEstimate < 1 ? tauEstimate : tauEstimate - 1;
        int x2 = tauEstimate + 1 < this.yinBuffer.length ? tauEstimate + 1 : tauEstimate;
        if (x0 == tauEstimate) {
            betterTau = this.yinBuffer[tauEstimate] <= this.yinBuffer[x2] ? (float)tauEstimate : (float)x2;
        } else if (x2 == tauEstimate) {
            betterTau = this.yinBuffer[tauEstimate] <= this.yinBuffer[x0] ? (float)tauEstimate : (float)x0;
        } else {
            float s0 = this.yinBuffer[x0];
            float s1 = this.yinBuffer[tauEstimate];
            float s2 = this.yinBuffer[x2];
            betterTau = (float)tauEstimate + (s2 - s0) / (2.0f * (2.0f * s1 - s2 - s0));
        }
        return betterTau;
    }
}

