/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.pitch;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;
import be.tarsos.dsp.pitch.Goertzel;
import be.tarsos.dsp.util.Complex;
import be.tarsos.dsp.util.fft.HammingWindow;

public class GeneralizedGoertzel
implements AudioProcessor {
    private final double[] frequenciesToDetect;
    private final double[] indvec;
    private final double[] precalculatedCosines;
    private final double[] precalculatedWnk;
    private final double[] calculatedPowers;
    private final Complex[] calculatedComplex;
    private final Goertzel.FrequenciesDetectedHandler handler;

    public GeneralizedGoertzel(float audioSampleRate, int bufferSize, double[] frequencies, Goertzel.FrequenciesDetectedHandler handler) {
        this.frequenciesToDetect = frequencies;
        this.indvec = new double[this.frequenciesToDetect.length];
        for (int j = 0; j < this.frequenciesToDetect.length; ++j) {
            this.indvec[j] = this.frequenciesToDetect[j] / (double)(audioSampleRate / (float)bufferSize);
        }
        this.precalculatedCosines = new double[frequencies.length];
        this.precalculatedWnk = new double[frequencies.length];
        this.handler = handler;
        this.calculatedPowers = new double[frequencies.length];
        this.calculatedComplex = new Complex[frequencies.length];
        for (int i = 0; i < this.frequenciesToDetect.length; ++i) {
            this.precalculatedCosines[i] = 2.0 * Math.cos(Math.PI * 2 * this.frequenciesToDetect[i] / (double)audioSampleRate);
            this.precalculatedWnk[i] = Math.exp(Math.PI * -2 * this.frequenciesToDetect[i] / (double)audioSampleRate);
        }
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        float[] x = audioEvent.getFloatBuffer();
        HammingWindow f = new HammingWindow();
        f.apply(x);
        for (int j = 0; j < this.frequenciesToDetect.length; ++j) {
            double pik_term = Math.PI * 2 * this.indvec[j] / (double)audioEvent.getBufferSize();
            double cos_pik_term2 = Math.cos(pik_term) * 2.0;
            Complex cc = new Complex(0.0, -1.0 * pik_term).exp();
            double s0 = 0.0;
            double s1 = 0.0;
            double s2 = 0.0;
            for (int i = 0; i < audioEvent.getBufferSize(); ++i) {
                s0 = (double)x[i] + cos_pik_term2 * s1 - s2;
                s2 = s1;
                s1 = s0;
            }
            s0 = cos_pik_term2 * s1 - s2;
            this.calculatedComplex[j] = cc.times(new Complex(-s1, 0.0)).plus(new Complex(s0, 0.0));
            this.calculatedPowers[j] = this.calculatedComplex[j].mod();
        }
        this.handler.handleDetectedFrequencies(audioEvent.getTimeStamp(), (double[])this.frequenciesToDetect.clone(), (double[])this.calculatedPowers.clone(), (double[])this.frequenciesToDetect.clone(), (double[])this.calculatedPowers.clone());
        return true;
    }

    @Override
    public void processingFinished() {
    }
}

