/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.pitch;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;
import be.tarsos.dsp.pitch.AMDF;
import be.tarsos.dsp.pitch.DynamicWavelet;
import be.tarsos.dsp.pitch.FFTPitch;
import be.tarsos.dsp.pitch.FastYin;
import be.tarsos.dsp.pitch.McLeodPitchMethod;
import be.tarsos.dsp.pitch.PitchDetectionHandler;
import be.tarsos.dsp.pitch.PitchDetectionResult;
import be.tarsos.dsp.pitch.PitchDetector;
import be.tarsos.dsp.pitch.Yin;

public class PitchProcessor
implements AudioProcessor {
    private final PitchDetector detector;
    private final PitchDetectionHandler handler;

    public PitchProcessor(PitchEstimationAlgorithm algorithm, float sampleRate, int bufferSize, PitchDetectionHandler handler) {
        this.detector = algorithm.getDetector(sampleRate, bufferSize);
        this.handler = handler;
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        float[] audioFloatBuffer = audioEvent.getFloatBuffer();
        PitchDetectionResult result = this.detector.getPitch(audioFloatBuffer);
        this.handler.handlePitch(result, audioEvent);
        return true;
    }

    @Override
    public void processingFinished() {
    }

    public static enum PitchEstimationAlgorithm {
        YIN,
        MPM,
        FFT_YIN,
        DYNAMIC_WAVELET,
        FFT_PITCH,
        AMDF;


        public PitchDetector getDetector(float sampleRate, int bufferSize) {
            PitchDetector detector = this == MPM ? new McLeodPitchMethod(sampleRate, bufferSize) : (this == DYNAMIC_WAVELET ? new DynamicWavelet(sampleRate, bufferSize) : (this == FFT_YIN ? new FastYin(sampleRate, bufferSize) : (this == AMDF ? new AMDF(sampleRate, bufferSize) : (this == FFT_PITCH ? new FFTPitch(Math.round(sampleRate), bufferSize) : new Yin(sampleRate, bufferSize)))));
            return detector;
        }
    }
}

