/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.resample;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;
import be.tarsos.dsp.resample.Resampler;

public class RateTransposer
implements AudioProcessor {
    private double factor;
    private Resampler r;

    public RateTransposer(double factor) {
        this.factor = factor;
        this.r = new Resampler(false, 0.1, 4.0);
    }

    public void setFactor(double tempo) {
        this.factor = tempo;
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        float[] src = audioEvent.getFloatBuffer();
        float[] out = new float[(int)((double)src.length * this.factor)];
        this.r.process(this.factor, src, 0, src.length, false, out, 0, out.length);
        audioEvent.setFloatBuffer(out);
        return true;
    }

    @Override
    public void processingFinished() {
    }
}

