/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.resample;

import be.tarsos.dsp.AudioDispatcher;
import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;

public class SoundTouchRateTransposer
implements AudioProcessor {
    private double rate;
    int slopeCount;
    double prevSample;
    private AudioDispatcher dispatcher;

    public void setDispatcher(AudioDispatcher newDispatcher) {
        this.dispatcher = newDispatcher;
    }

    public SoundTouchRateTransposer(double d) {
        this.rate = d;
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        float[] src = audioEvent.getFloatBuffer();
        float[] dest = new float[(int)Math.round((double)audioEvent.getBufferSize() / this.rate)];
        int used = 0;
        int i = 0;
        while ((float)this.slopeCount <= 1.0f) {
            dest[i] = (float)((double)(1.0f - (float)this.slopeCount) * this.prevSample + (double)((float)this.slopeCount * src[0]));
            ++i;
            this.slopeCount = (int)((double)this.slopeCount + this.rate);
        }
        this.slopeCount = (int)((float)this.slopeCount - 1.0f);
        while (true) {
            if ((float)this.slopeCount > 1.0f) {
                this.slopeCount = (int)((float)this.slopeCount - 1.0f);
                if (++used < src.length - 1) continue;
                break;
            }
            if (i < dest.length) {
                dest[i] = (1.0f - (float)this.slopeCount) * src[used] + (float)this.slopeCount * src[used + 1];
            }
            ++i;
            this.slopeCount = (int)((double)this.slopeCount + this.rate);
        }
        this.prevSample = src[src.length - 1];
        this.dispatcher.setStepSizeAndOverlap(dest.length, 0);
        audioEvent.setFloatBuffer(dest);
        return true;
    }

    @Override
    public void processingFinished() {
    }
}

