/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.synthesis;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.EnvelopeFollower;
import be.tarsos.dsp.pitch.PitchDetectionHandler;
import be.tarsos.dsp.pitch.PitchDetectionResult;
import java.util.Arrays;

public class PitchResyntheziser
implements PitchDetectionHandler {
    private double phase = 0.0;
    private double phaseFirst = 0.0;
    private double phaseSecond = 0.0;
    private double prevFrequency = 0.0;
    private float samplerate;
    private final EnvelopeFollower envelopeFollower;
    private boolean usePureSine;
    private boolean followEnvelope;
    private final double[] previousFrequencies;
    private int previousFrequencyIndex;

    public PitchResyntheziser(float samplerate) {
        this(samplerate, true, false);
    }

    public PitchResyntheziser(float samplerate, boolean followEnvelope, boolean pureSine) {
        this(samplerate, followEnvelope, pureSine, 5);
    }

    public PitchResyntheziser(float samplerate, boolean followEnvelope, boolean pureSine, int filterSize) {
        this.envelopeFollower = new EnvelopeFollower(samplerate, 0.005, 0.01);
        this.followEnvelope = followEnvelope;
        this.usePureSine = pureSine;
        this.samplerate = samplerate;
        this.previousFrequencies = new double[filterSize];
        this.previousFrequencyIndex = 0;
    }

    @Override
    public void handlePitch(PitchDetectionResult pitchDetectionResult, AudioEvent audioEvent) {
        double frequency = pitchDetectionResult.getPitch();
        if (frequency == -1.0) {
            frequency = this.prevFrequency;
        } else {
            if (this.previousFrequencies.length != 0) {
                this.previousFrequencies[this.previousFrequencyIndex] = frequency;
                ++this.previousFrequencyIndex;
                this.previousFrequencyIndex %= this.previousFrequencies.length;
                double[] frequenciesCopy = (double[])this.previousFrequencies.clone();
                Arrays.sort(frequenciesCopy);
                frequency = frequenciesCopy[frequenciesCopy.length / 2];
            }
            this.prevFrequency = frequency;
        }
        double twoPiF = Math.PI * 2 * frequency;
        float[] audioBuffer = audioEvent.getFloatBuffer();
        float[] envelope = null;
        if (this.followEnvelope) {
            envelope = (float[])audioBuffer.clone();
            this.envelopeFollower.calculateEnvelope(envelope);
        }
        for (int sample = 0; sample < audioBuffer.length; ++sample) {
            double time = (float)sample / this.samplerate;
            double wave = Math.sin(twoPiF * time + this.phase);
            if (!this.usePureSine) {
                wave += 0.05 * Math.sin(twoPiF * 4.0 * time + this.phaseFirst);
                wave += 0.01 * Math.sin(twoPiF * 8.0 * time + this.phaseSecond);
            }
            audioBuffer[sample] = (float)wave;
            if (!this.followEnvelope) continue;
            audioBuffer[sample] = audioBuffer[sample] * envelope[sample];
        }
        double timefactor = twoPiF * (double)audioBuffer.length / (double)this.samplerate;
        this.phase = timefactor + this.phase;
        if (!this.usePureSine) {
            this.phaseFirst = 4.0 * timefactor + this.phaseFirst;
            this.phaseSecond = 8.0 * timefactor + this.phaseSecond;
        }
    }
}

