/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.ui;

import be.tarsos.dsp.ui.Axis;
import be.tarsos.dsp.ui.AxisUnit;
import be.tarsos.dsp.ui.CoordinateSystem;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;

public class ViewPort {
    private final List<ViewPortChangedListener> listeners;
    private final CoordinateSystem cs;
    private int xMinPref = Integer.MAX_VALUE;
    private int xMaxPref = Integer.MAX_VALUE;
    private int yMinPref = Integer.MAX_VALUE;
    private int yMaxPref = Integer.MAX_VALUE;
    private boolean onlyZoomXWithMouseWheel = false;

    public ViewPort(CoordinateSystem cs) {
        this.listeners = new ArrayList<ViewPortChangedListener>();
        this.cs = cs;
    }

    public void addViewPortChangedListener(ViewPortChangedListener listener) {
        this.listeners.add(listener);
    }

    private void viewPortChanged() {
        for (ViewPortChangedListener listener : this.listeners) {
            listener.viewPortChanged(this);
        }
    }

    public void setPreferredZoomWindow(int xMin, int xMax, int yMin, int yMax) {
        this.xMinPref = xMin;
        this.xMaxPref = xMax;
        this.yMinPref = yMin;
        this.yMaxPref = yMax;
    }

    public void setOnlyZoomXAxisWithMouseWheel(boolean onlyZoomX) {
        this.onlyZoomXWithMouseWheel = onlyZoomX;
    }

    public void zoom(int amount, Point zoomPoint) {
        float yDelta;
        float newYDelta;
        float xDelta = this.cs.getDelta(Axis.X);
        float newXDelta = xDelta + (float)(amount * 1000);
        if (newXDelta > 2.0f && newXDelta < 600000.0f) {
            this.cs.setMax(Axis.X, this.cs.getMin(Axis.X) + newXDelta);
        }
        if (this.cs.getUnitsForAxis(Axis.Y) == AxisUnit.FREQUENCY && !this.onlyZoomXWithMouseWheel && (newYDelta = (yDelta = this.cs.getDelta(Axis.Y)) + (float)(amount * 10)) > 50.0f && newXDelta < 150000.0f) {
            this.cs.setMax(Axis.Y, this.cs.getMin(Axis.Y) + newYDelta);
        }
        this.viewPortChanged();
    }

    public void resetZoom() {
        if (this.xMinPref != Integer.MAX_VALUE) {
            this.cs.setMin(Axis.X, this.xMinPref);
            this.cs.setMax(Axis.X, this.xMaxPref);
        }
        if (this.yMinPref != Integer.MAX_VALUE) {
            this.cs.setMin(Axis.Y, this.yMinPref);
            this.cs.setMax(Axis.Y, this.yMaxPref);
        }
        if (this.xMinPref == Integer.MAX_VALUE && this.yMinPref == Integer.MAX_VALUE) {
            if (this.cs.getUnitsForAxis(Axis.Y) == AxisUnit.FREQUENCY) {
                this.cs.setMin(Axis.Y, 3600.0f);
                this.cs.setMax(Axis.Y, 12800.0f);
            }
            this.cs.setMin(Axis.X, 0.0f);
            this.cs.setMax(Axis.X, 30000.0f);
        }
        this.viewPortChanged();
    }

    public void zoomToSelection() {
        double temp;
        if (!this.cs.hasStartPoint() || this.cs.getEndX() == Double.MAX_VALUE) {
            this.cs.clearPoints();
            return;
        }
        double startX = this.cs.getStartX();
        double startY = this.cs.getStartY();
        double endX = this.cs.getEndX();
        double endY = this.cs.getEndY();
        this.cs.clearPoints();
        if (startX > endX) {
            temp = startX;
            startX = endX;
            endX = temp;
        }
        if (startY > endY) {
            temp = startY;
            startY = endY;
            endY = temp;
        }
        int minTimeDiff = 10;
        int minCentsDiff = 50;
        if (endX - startX <= (double)minTimeDiff) {
            endX = startX + (double)minTimeDiff;
        }
        if (endY - startY <= (double)minCentsDiff) {
            endY = startY + (double)minCentsDiff;
        }
        this.cs.setMin(Axis.X, (float)startX);
        this.cs.setMax(Axis.X, (float)endX);
        if (this.cs.getUnitsForAxis(Axis.Y) == AxisUnit.FREQUENCY) {
            this.cs.setMin(Axis.Y, (float)startY);
            this.cs.setMax(Axis.Y, (float)endY);
        }
        this.viewPortChanged();
    }

    public void drag(float xAmount, float yAmount) {
        this.cs.setMin(Axis.X, this.cs.getMin(Axis.X) + xAmount);
        this.cs.setMax(Axis.X, this.cs.getMax(Axis.X) + xAmount);
        this.cs.setMin(Axis.Y, this.cs.getMin(Axis.Y) + yAmount);
        this.cs.setMax(Axis.Y, this.cs.getMax(Axis.Y) + yAmount);
        this.viewPortChanged();
    }

    public static interface ViewPortChangedListener {
        public void viewPortChanged(ViewPort var1);
    }
}

