/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.ui.layers;

import be.tarsos.dsp.ui.Axis;
import be.tarsos.dsp.ui.AxisUnit;
import be.tarsos.dsp.ui.CoordinateSystem;
import be.tarsos.dsp.ui.layers.Layer;
import be.tarsos.dsp.ui.layers.LayerUtilities;
import java.awt.Color;
import java.awt.Graphics2D;

public class AmplitudeAxisLayer
implements Layer {
    CoordinateSystem cs;

    public AmplitudeAxisLayer(CoordinateSystem cs) {
        this.cs = cs;
    }

    @Override
    public void draw(Graphics2D graphics) {
        if (this.cs.getUnitsForAxis(Axis.Y) == AxisUnit.AMPLITUDE) {
            this.drawAmplitudeXAxis(graphics);
        }
    }

    public void drawAmplitudeXAxis(Graphics2D graphics) {
        graphics.setColor(Color.black);
        int minX = Math.round(this.cs.getMin(Axis.X));
        int maxY = Math.round(this.cs.getMax(Axis.Y));
        int lineWidthFourPixels = Math.round(LayerUtilities.pixelsToUnits(graphics, 4, true));
        int textOffset = Math.round(LayerUtilities.pixelsToUnits(graphics, 14, true));
        int textLabelOffset = Math.round(LayerUtilities.pixelsToUnits(graphics, 20, false));
        int lineWidthTwoPixels = Math.round(LayerUtilities.pixelsToUnits(graphics, 2, true));
        int i = (int)this.cs.getMin(Axis.Y);
        while ((float)i < this.cs.getMax(Axis.Y)) {
            if (i % 100 == 0) {
                graphics.drawLine(minX, i, minX + lineWidthFourPixels, i);
                String text = String.format("%.0f", (double)i / 10.0);
                LayerUtilities.drawString(graphics, text, minX + textOffset, i, true, true, null);
            } else if (i % 10 == 0) {
                graphics.drawLine(minX, i, minX + lineWidthTwoPixels, i);
            }
            ++i;
        }
        graphics.drawLine(minX, 0, minX, maxY);
        LayerUtilities.drawString(graphics, "Amplitude (%)", minX + textOffset, maxY - textLabelOffset, false, true, Color.white);
    }

    @Override
    public String getName() {
        return "Amplitude Axis";
    }
}

