/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.ui.layers;

import be.tarsos.dsp.AudioDispatcher;
import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;
import be.tarsos.dsp.beatroot.BeatRootOnsetEventHandler;
import be.tarsos.dsp.io.jvm.AudioDispatcherFactory;
import be.tarsos.dsp.onsets.ComplexOnsetDetector;
import be.tarsos.dsp.onsets.OnsetHandler;
import be.tarsos.dsp.ui.Axis;
import be.tarsos.dsp.ui.CoordinateSystem;
import be.tarsos.dsp.ui.layers.Layer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.UnsupportedAudioFileException;

public class BeatLayer
implements Layer {
    private final List<Double> onsets = new ArrayList<Double>();
    private final List<Double> beats = new ArrayList<Double>();
    private final CoordinateSystem cs;
    private final Color onsetColor;
    private final Color beatColor;
    private final int frameSize;
    private final int overlap;
    private final File audioFile;
    private final boolean showBeats;
    private final boolean showOnsets;

    public BeatLayer(CoordinateSystem cs, File audioFile, boolean showBeats, boolean showOnsets) {
        this.cs = cs;
        this.frameSize = 256;
        this.overlap = 0;
        this.onsetColor = Color.blue;
        this.beatColor = Color.red;
        this.showBeats = showBeats;
        this.showOnsets = showOnsets;
        this.audioFile = audioFile;
        this.initialise();
    }

    @Override
    public void draw(Graphics2D graphics) {
        int maxY = Math.round(this.cs.getMax(Axis.Y));
        int minY = Math.round(this.cs.getMin(Axis.Y));
        if (!this.onsets.isEmpty() && this.showOnsets) {
            graphics.setColor(this.onsetColor);
            for (Double onset : this.onsets) {
                int onsetTime = (int)Math.round(onset * 1000.0);
                graphics.drawLine(onsetTime, minY, onsetTime, maxY);
            }
        }
        if (!this.beats.isEmpty() && this.showBeats) {
            graphics.setColor(this.beatColor);
            for (Double beat : this.beats) {
                int beatTime = (int)Math.round(beat * 1000.0);
                graphics.drawLine(beatTime, minY, beatTime, maxY);
            }
        }
    }

    public void initialise() {
        try {
            AudioDispatcher adp = AudioDispatcherFactory.fromFile(this.audioFile, this.frameSize, this.overlap);
            float sampleRate = adp.getFormat().getSampleRate();
            final double lag = (double)((float)this.frameSize / sampleRate) / 2.0;
            ComplexOnsetDetector detector = new ComplexOnsetDetector(this.frameSize);
            final BeatRootOnsetEventHandler broeh = new BeatRootOnsetEventHandler();
            adp.addAudioProcessor(detector);
            adp.addAudioProcessor(new AudioProcessor(){

                @Override
                public void processingFinished() {
                    broeh.trackBeats(new OnsetHandler(){

                        @Override
                        public void handleOnset(double time, double salience) {
                            BeatLayer.this.beats.add(time - lag);
                        }
                    });
                }

                @Override
                public boolean process(AudioEvent audioEvent) {
                    return true;
                }
            });
            detector.setHandler(new OnsetHandler(){

                @Override
                public void handleOnset(double time, double salience) {
                    BeatLayer.this.onsets.add(time - lag);
                    broeh.handleOnset(time - lag, salience);
                }
            });
            new Thread(adp).start();
        }
        catch (UnsupportedAudioFileException e) {
            e.printStackTrace();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public String getName() {
        return "Beats Layer";
    }
}

