/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.ui.layers;

import be.tarsos.dsp.ui.CoordinateSystem;
import be.tarsos.dsp.ui.LinkedPanel;
import be.tarsos.dsp.ui.layers.Layer;
import be.tarsos.dsp.ui.layers.LayerUtilities;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.SwingUtilities;

public class DragMouseListenerLayer
extends MouseAdapter
implements Layer {
    private final boolean onlyHorizontal;
    private Point previousPoint;
    private final CoordinateSystem cs;

    public DragMouseListenerLayer(CoordinateSystem cs) {
        this.onlyHorizontal = cs.isWrapping();
        this.previousPoint = null;
        this.cs = cs;
    }

    @Override
    public void draw(Graphics2D graphics) {
    }

    @Override
    public String getName() {
        return "Listen to drag events.";
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.previousPoint = e.getPoint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!SwingUtilities.isLeftMouseButton(e)) {
            this.previousPoint = null;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!SwingUtilities.isLeftMouseButton(e) && this.previousPoint != null) {
            if (this.onlyHorizontal) {
                this.dragHorizontally(e);
            } else {
                this.dragBoth(e);
            }
        }
    }

    private void dragBoth(MouseEvent e) {
        LinkedPanel panel = (LinkedPanel)e.getComponent();
        Graphics2D graphics = (Graphics2D)panel.getGraphics();
        graphics.setTransform(panel.getTransform());
        Point2D unitsCurrent = LayerUtilities.pixelsToUnits(graphics, e.getX(), e.getY());
        Point2D unitsPrevious = LayerUtilities.pixelsToUnits(graphics, (int)this.previousPoint.getX(), (int)this.previousPoint.getY());
        float millisecondAmount = (float)(unitsPrevious.getX() - unitsCurrent.getX());
        float centAmount = (float)(unitsPrevious.getY() - unitsCurrent.getY());
        this.previousPoint = e.getPoint();
        panel.getViewPort().drag(millisecondAmount, centAmount);
        graphics.dispose();
    }

    private void dragHorizontally(MouseEvent e) {
        LinkedPanel panel = (LinkedPanel)e.getComponent();
        Graphics2D graphics = (Graphics2D)panel.getGraphics();
        graphics.setTransform(panel.getTransform());
        Point2D unitsCurrent = LayerUtilities.pixelsToUnits(graphics, e.getX(), (int)this.previousPoint.getY());
        Point2D unitsPrevious = LayerUtilities.pixelsToUnits(graphics, (int)this.previousPoint.getX(), (int)this.previousPoint.getY());
        float millisecondAmount = (float)(unitsPrevious.getX() - unitsCurrent.getX());
        this.previousPoint = e.getPoint();
        if (this.cs.isWrapping()) {
            this.cs.setWrappingOrigin(this.cs.getWrappingOrigin() + millisecondAmount);
            panel.getViewPort().drag(0.0f, 0.0f);
        } else {
            panel.getViewPort().drag(millisecondAmount, 0.0f);
        }
        graphics.dispose();
    }
}

