/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.ui.layers;

import be.tarsos.dsp.AudioDispatcher;
import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;
import be.tarsos.dsp.io.jvm.AudioDispatcherFactory;
import be.tarsos.dsp.ui.Axis;
import be.tarsos.dsp.ui.CoordinateSystem;
import be.tarsos.dsp.ui.layers.Layer;
import be.tarsos.dsp.ui.layers.TooltipLayer;
import be.tarsos.dsp.util.PitchConverter;
import be.tarsos.dsp.util.fft.FFT;
import be.tarsos.dsp.util.fft.HammingWindow;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.sound.sampled.UnsupportedAudioFileException;

public class FFTLayer
implements Layer,
TooltipLayer.TooltipTextGenerator {
    private TreeMap<Double, FFTFrame> features;
    private final CoordinateSystem cs;
    private final int frameSize;
    private final int overlap;
    private final File audioFile;
    private float binWith;
    private float maxSpectralEnergy = 0.0f;
    private float minSpectralEnergy = 100000.0f;
    private float[] binStartingPointsInCents;
    private float[] binHeightsInCents;
    private int increment;

    public FFTLayer(CoordinateSystem cs, File audioFile, int frameSize, int overlap) {
        this.increment = frameSize - overlap;
        this.features = new TreeMap();
        this.cs = cs;
        this.audioFile = audioFile;
        this.frameSize = frameSize;
        this.overlap = overlap;
        this.initialise();
    }

    @Override
    public void draw(Graphics2D graphics) {
        if (this.features != null) {
            SortedMap<Double, FFTFrame> spectralInfoSubMap = this.features.subMap((double)this.cs.getMin(Axis.X) / 1000.0, (double)this.cs.getMax(Axis.X) / 1000.0);
            for (Map.Entry frameEntry : spectralInfoSubMap.entrySet()) {
                double timeStart = (Double)frameEntry.getKey();
                FFTFrame frame = (FFTFrame)frameEntry.getValue();
                for (int i = 0; i < frame.magnitudes.length; ++i) {
                    Color color = Color.black;
                    float centsStartingPoint = this.binStartingPointsInCents[i];
                    if (!(centsStartingPoint >= this.cs.getMin(Axis.Y)) || !(centsStartingPoint <= this.cs.getMax(Axis.Y))) continue;
                    float factor = (frame.magnitudes[i] - frame.getMinMagnitude()) / (frame.getMaxMagnitude() - frame.getMinMagnitude());
                    int greyValue = 255 - (int)(factor * 255.0f);
                    greyValue = Math.max(0, greyValue);
                    color = new Color(greyValue, greyValue, greyValue);
                    graphics.setColor(color);
                    graphics.fillRect((int)Math.round(timeStart * 1000.0), Math.round(centsStartingPoint), Math.round(this.binWith * 1000.0f), (int)Math.ceil(this.binHeightsInCents[i]));
                }
            }
        }
    }

    public void initialise() {
        try {
            AudioDispatcher adp = AudioDispatcherFactory.fromFile(this.audioFile, this.frameSize, this.overlap);
            final float sampleRate = adp.getFormat().getSampleRate();
            final TreeMap fe = new TreeMap();
            this.binWith = (float)this.increment / sampleRate;
            final FFT fft = new FFT(this.frameSize, new HammingWindow());
            this.binStartingPointsInCents = new float[this.frameSize];
            this.binHeightsInCents = new float[this.frameSize];
            for (int i = 1; i < this.frameSize; ++i) {
                this.binStartingPointsInCents[i] = (float)PitchConverter.hertzToAbsoluteCent(fft.binToHz(i, sampleRate));
                this.binHeightsInCents[i] = this.binStartingPointsInCents[i] - this.binStartingPointsInCents[i - 1];
            }
            final double lag = (double)((float)this.frameSize / sampleRate) - (double)this.binWith / 2.0;
            adp.addAudioProcessor(new AudioProcessor(){
                float[] previousPhaseOffsets = null;

                @Override
                public boolean process(AudioEvent audioEvent) {
                    float[] buffer = (float[])audioEvent.getFloatBuffer().clone();
                    float[] amplitudes = new float[buffer.length / 2];
                    float[] phases = new float[buffer.length / 2];
                    fft.powerPhaseFFT(buffer, amplitudes, phases);
                    FFTFrame frame = new FFTFrame(fft, FFTLayer.this.frameSize, FFTLayer.this.overlap, sampleRate, amplitudes, phases, this.previousPhaseOffsets);
                    this.previousPhaseOffsets = phases;
                    fe.put(audioEvent.getTimeStamp() - lag, frame);
                    return true;
                }

                @Override
                public void processingFinished() {
                    float decay = 0.99f;
                    float ramp = 1.01f;
                    for (FFTFrame frame : fe.values()) {
                        FFTLayer.this.maxSpectralEnergy = Math.max(frame.calculateMaxMagnitude(), FFTLayer.this.maxSpectralEnergy);
                        frame.setMaxMagnitude(FFTLayer.this.maxSpectralEnergy);
                        FFTLayer.this.minSpectralEnergy = Math.min(frame.calculateMinMagnitude(), FFTLayer.this.minSpectralEnergy);
                        frame.setMinMagnitude(FFTLayer.this.minSpectralEnergy);
                        FFTLayer.this.maxSpectralEnergy = FFTLayer.this.maxSpectralEnergy * decay;
                        FFTLayer.this.minSpectralEnergy = FFTLayer.this.minSpectralEnergy * ramp;
                    }
                    FFTLayer.this.features = fe;
                }
            });
            new Thread((Runnable)adp, "Calculate FFT").start();
        }
        catch (UnsupportedAudioFileException e) {
            e.printStackTrace();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public String getName() {
        return "FFT Layer";
    }

    @Override
    public String generateTooltip(CoordinateSystem cs, Point2D point) {
        String tooltip = "";
        if (this.features != null) {
            double timestampInSeconds = point.getX() / 1000.0;
            Map.Entry<Double, FFTFrame> ceilingEntry = this.features.ceilingEntry(timestampInSeconds);
            Map.Entry<Double, FFTFrame> floorEntry = this.features.floorEntry(timestampInSeconds);
            double diffToFloor = Math.abs(floorEntry.getKey() - timestampInSeconds);
            double diffToCeil = Math.abs(floorEntry.getKey() - timestampInSeconds);
            Map.Entry<Double, FFTFrame> entry = diffToCeil > diffToFloor ? floorEntry : ceilingEntry;
            FFTFrame frame = entry.getValue();
            int binIndex = 0;
            for (int i = 0; i < this.binStartingPointsInCents.length; ++i) {
                if (!((double)this.binStartingPointsInCents[i] > point.getY()) || binIndex != 0) continue;
                binIndex = i - 1;
            }
            float frequency = frame.getFrequencyForBin(binIndex);
            tooltip = String.format("Bin: %d  Estimated Frequency: %.02fHz  Time: %.03fs  ", binIndex, Float.valueOf(frequency), timestampInSeconds);
        }
        return tooltip;
    }

    private static class FFTFrame {
        private float[] magnitudes;
        private float[] currentPhaseOffsets;
        private float[] previousPhaseOffsets;
        private FFT fft;
        private float[] frequencyEstimates;
        private final double dt;
        private final double cbin;
        private final double inv_2pi;
        private final double inv_deltat;
        private final double inv_2pideltat;
        private float sampleRate;
        private float minMagnitude;
        private float maxMagnitude;

        public FFTFrame(FFT fft, int bufferSize, int overlap, float sampleRate, float[] magnitudes, float[] currentPhaseOffsets, float[] previousPhaseOffsets) {
            this.fft = fft;
            this.magnitudes = magnitudes;
            this.currentPhaseOffsets = currentPhaseOffsets;
            this.previousPhaseOffsets = previousPhaseOffsets;
            this.frequencyEstimates = new float[magnitudes.length];
            this.dt = (double)(bufferSize - overlap) / (double)sampleRate;
            this.cbin = this.dt * (double)sampleRate / (double)bufferSize;
            this.sampleRate = sampleRate;
            this.inv_2pi = 0.15915494309189535;
            this.inv_deltat = 1.0 / this.dt;
            this.inv_2pideltat = this.inv_deltat * this.inv_2pi;
            this.calculateFrequencyEstimates();
            this.convertMagnitudesToDecibel();
        }

        private void convertMagnitudesToDecibel() {
            float minValue = 5.0E-6f;
            for (int i = 0; i < this.magnitudes.length; ++i) {
                double value = 1.0f + this.magnitudes[i];
                if (value <= 0.0) {
                    value = 1.0f + minValue;
                }
                this.magnitudes[i] = (float)Math.abs(20.0 * Math.log10(value));
            }
        }

        private void calculateFrequencyEstimates() {
            for (int i = 0; i < this.frequencyEstimates.length; ++i) {
                this.frequencyEstimates[i] = this.getFrequencyForBin(i);
            }
        }

        public float calculateMinMagnitude() {
            float minMag = 4654654.0f;
            for (int i = 0; i < this.magnitudes.length; ++i) {
                minMag = Math.min(minMag, this.magnitudes[i]);
            }
            return minMag;
        }

        public float calculateMaxMagnitude() {
            float maxMag = -1654654.0f;
            for (int i = 0; i < this.magnitudes.length; ++i) {
                maxMag = Math.max(maxMag, this.magnitudes[i]);
            }
            return maxMag;
        }

        public float getMaxMagnitude() {
            return this.maxMagnitude;
        }

        public void setMaxMagnitude(float maxMagnitude) {
            this.maxMagnitude = maxMagnitude;
        }

        public float getMinMagnitude() {
            return this.minMagnitude;
        }

        public void setMinMagnitude(float minMagnitude) {
            this.minMagnitude = minMagnitude;
        }

        private float getFrequencyForBin(int binIndex) {
            float frequencyInHertz;
            if (this.previousPhaseOffsets != null) {
                float phaseDelta = this.currentPhaseOffsets[binIndex] - this.previousPhaseOffsets[binIndex];
                long k = Math.round(this.cbin * (double)binIndex - this.inv_2pi * (double)phaseDelta);
                frequencyInHertz = (float)(this.inv_2pideltat * (double)phaseDelta + this.inv_deltat * (double)k);
            } else {
                frequencyInHertz = (float)this.fft.binToHz(binIndex, this.sampleRate);
            }
            return frequencyInHertz;
        }
    }
}

