/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.ui.layers;

import be.tarsos.dsp.AudioDispatcher;
import be.tarsos.dsp.StopAudioProcessor;
import be.tarsos.dsp.io.jvm.AudioDispatcherFactory;
import be.tarsos.dsp.pitch.GeneralizedGoertzel;
import be.tarsos.dsp.pitch.Goertzel;
import be.tarsos.dsp.ui.Axis;
import be.tarsos.dsp.ui.CoordinateSystem;
import be.tarsos.dsp.ui.layers.Layer;
import be.tarsos.dsp.util.PitchConverter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.sound.sampled.UnsupportedAudioFileException;

public class GeneralizedGoertzelLayer
implements Layer {
    private TreeMap<Double, double[]> features;
    private final CoordinateSystem cs;
    private final File audioFile;
    private double maxSpectralEnergy = 0.0;
    private double minSpectralEnergy = 100000.0;
    private float[] binStartingPointsInCents;
    private float binWith;
    private float binHeight;

    public GeneralizedGoertzelLayer(CoordinateSystem cs, File audioFile, int binHeightInCents) {
        this.cs = cs;
        this.audioFile = audioFile;
    }

    @Override
    public void draw(Graphics2D graphics) {
        this.calculateFeatures();
        if (this.features != null) {
            SortedMap<Double, double[]> spectralInfoSubMap = this.features.subMap((double)this.cs.getMin(Axis.X) / 1000.0, (double)this.cs.getMax(Axis.X) / 1000.0);
            for (Map.Entry column : spectralInfoSubMap.entrySet()) {
                double timeStart = (Double)column.getKey();
                double[] spectralEnergy = (double[])column.getValue();
                for (int i = 0; i < spectralEnergy.length; ++i) {
                    Color color = Color.black;
                    float centsStartingPoint = this.binStartingPointsInCents[i];
                    if (!(centsStartingPoint >= this.cs.getMin(Axis.Y)) || !(centsStartingPoint <= this.cs.getMax(Axis.Y))) continue;
                    double factor = spectralEnergy[i] / this.maxSpectralEnergy;
                    int greyValue = 255 - (int)(factor * 255.0);
                    greyValue = Math.max(0, greyValue);
                    color = new Color(greyValue, greyValue, greyValue);
                    graphics.setColor(color);
                    graphics.fillRect((int)Math.round(timeStart * 1000.0), Math.round(centsStartingPoint), Math.round(this.binWith * 1000.0f), (int)Math.ceil(this.binHeight));
                }
            }
        }
    }

    public void calculateFeatures() {
        try {
            int blockSize = 8000;
            int overlap = 7500;
            AudioDispatcher adp = AudioDispatcherFactory.fromFile(this.audioFile, blockSize, overlap);
            adp.skip(Math.max(0.0, (double)this.cs.getMin(Axis.X) / 1000.0));
            adp.addAudioProcessor(new StopAudioProcessor((double)this.cs.getMax(Axis.X) / 1000.0));
            float sampleRate = adp.getFormat().getFrameRate();
            double lowFrequencyInCents = this.cs.getMin(Axis.Y);
            double highFrequencyInCents = this.cs.getMax(Axis.Y);
            int steps = 50;
            double stepInCents = (highFrequencyInCents - lowFrequencyInCents) / (double)steps;
            this.binWith = (float)(blockSize - overlap) / sampleRate;
            this.binHeight = (float)stepInCents;
            double[] frequencies = new double[steps];
            this.binStartingPointsInCents = new float[steps];
            for (int i = 0; i < steps; ++i) {
                double valueInCents = (double)i * stepInCents + lowFrequencyInCents;
                frequencies[i] = PitchConverter.absoluteCentToHertz(valueInCents);
                this.binStartingPointsInCents[i] = (float)valueInCents;
            }
            final TreeMap fe = new TreeMap();
            Goertzel.FrequenciesDetectedHandler handler = new Goertzel.FrequenciesDetectedHandler(){
                int i = 0;

                @Override
                public void handleDetectedFrequencies(double time, double[] frequencies, double[] powers, double[] allFrequencies, double[] allPowers) {
                    double timeStamp = Math.max(0.0, (double)GeneralizedGoertzelLayer.this.cs.getMin(Axis.X) / 1000.0) + (double)((float)this.i * GeneralizedGoertzelLayer.this.binWith);
                    ++this.i;
                    fe.put(timeStamp, allPowers.clone());
                }
            };
            GeneralizedGoertzel goertzel = new GeneralizedGoertzel(sampleRate, blockSize, frequencies, handler);
            adp.addAudioProcessor(goertzel);
            adp.run();
            for (double[] magnitudes : fe.values()) {
                for (int i = 0; i < magnitudes.length; ++i) {
                    if (magnitudes[i] == 0.0) {
                        magnitudes[i] = 1.0E-10;
                    }
                    magnitudes[i] = 20.0 * Math.log(1.0 + Math.abs(magnitudes[i])) / Math.log(10.0);
                    this.maxSpectralEnergy = Math.max(magnitudes[i], this.maxSpectralEnergy);
                    this.minSpectralEnergy = Math.min(magnitudes[i], this.minSpectralEnergy);
                }
            }
            this.minSpectralEnergy = Math.abs(this.minSpectralEnergy);
            this.features = fe;
        }
        catch (UnsupportedAudioFileException e) {
            e.printStackTrace();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public String getName() {
        return "Generalized Goertzel Layer";
    }
}

