/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.ui.layers;

import be.tarsos.dsp.ui.Axis;
import be.tarsos.dsp.ui.CoordinateSystem;
import be.tarsos.dsp.ui.layers.Layer;
import be.tarsos.dsp.ui.layers.LayerUtilities;
import java.awt.Color;
import java.awt.Graphics2D;

public class HorizontalFrequencyAxisLayer
implements Layer {
    CoordinateSystem cs;

    public HorizontalFrequencyAxisLayer(CoordinateSystem cs) {
        this.cs = cs;
    }

    @Override
    public void draw(Graphics2D graphics) {
        graphics.setColor(Color.black);
        int minY = Math.round(this.cs.getMin(Axis.Y) + 1.0f);
        int minX = Math.round(this.cs.getMin(Axis.X));
        int maxX = Math.round(this.cs.getMax(Axis.X));
        int wideMarkHeight = Math.round(LayerUtilities.pixelsToUnits(graphics, 8, false));
        int smallMarkHeight = Math.round(LayerUtilities.pixelsToUnits(graphics, 6, false));
        int verySmallMarkHeight = Math.round(LayerUtilities.pixelsToUnits(graphics, 2, false));
        int textOffset = Math.round(LayerUtilities.pixelsToUnits(graphics, 12, false));
        int textLabelOffset = Math.round(LayerUtilities.pixelsToUnits(graphics, 120, true));
        float widthOf100CentsInPixels = LayerUtilities.unitsToPixels(graphics, 100.0f, true);
        int i = (int)this.cs.getMin(Axis.X);
        while ((float)i < this.cs.getMax(Axis.X)) {
            if (i % 1200 == 0) {
                graphics.drawLine(i, minY, i, minY + wideMarkHeight);
                String text = String.valueOf(i);
                LayerUtilities.drawString(graphics, text, i, minY + textOffset, true, false, null);
            } else if (i % 600 == 0) {
                graphics.drawLine(i, minY, i, minY + smallMarkHeight);
            } else if (widthOf100CentsInPixels > 10.0f && i % 100 == 0) {
                graphics.drawLine(i, minY, i, minY + verySmallMarkHeight);
            }
            ++i;
        }
        graphics.drawLine(minX, minY, maxX, minY);
        LayerUtilities.drawString(graphics, "Frequency (cents)", maxX - textLabelOffset, minY + 4 * wideMarkHeight, false, true, Color.white);
    }

    @Override
    public String getName() {
        return "Frequency Axis";
    }
}

