/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.ui.layers;

import be.tarsos.dsp.ui.Axis;
import be.tarsos.dsp.ui.CoordinateSystem;
import be.tarsos.dsp.ui.layers.Layer;
import be.tarsos.dsp.ui.layers.LayerUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class MouseCursorLayer
implements Layer,
MouseMotionListener,
MouseListener {
    private boolean drawCursor = false;
    private Point lastPoint = null;
    private Component component = null;
    boolean onlyDrawVertical = false;
    CoordinateSystem cs;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public MouseCursorLayer(CoordinateSystem cs) {
        this.cs = cs;
    }

    @Override
    public void draw(Graphics2D graphics) {
        if (this.drawCursor) {
            Point2D unitPoint = LayerUtilities.pixelsToUnits(graphics, (int)this.lastPoint.getX(), (int)this.lastPoint.getY());
            graphics.setColor(Color.blue);
            if (!this.onlyDrawVertical) {
                graphics.drawLine(Math.round(this.cs.getMax(Axis.X)), Math.round((float)unitPoint.getY()), Math.round(this.cs.getMin(Axis.X)), Math.round((float)unitPoint.getY()));
                this.pcs.firePropertyChange("cursor", null, this.lastPoint);
            }
            graphics.drawLine(Math.round((float)unitPoint.getX()), (int)Math.floor(this.cs.getMin(Axis.Y)), Math.round((float)unitPoint.getX()), (int)Math.ceil(this.cs.getMax(Axis.Y)));
        }
    }

    @Override
    public String getName() {
        return "Cursor Layer";
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.lastPoint = e.getPoint();
        this.component = e.getComponent();
        this.component.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.drawCursor = false;
        this.component = e.getComponent();
        this.component.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.lastPoint = e.getPoint();
        this.drawCursor = true;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.lastPoint = e.getPoint();
        this.drawCursor = true;
        this.onlyDrawVertical = false;
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.drawCursor = false;
        this.component = e.getComponent();
        this.component.repaint();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void setPoint(Point newPosition) {
        this.drawCursor = true;
        this.onlyDrawVertical = true;
        this.lastPoint = newPosition;
        if (this.component != null) {
            this.component.repaint();
        }
    }
}

