/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.ui.layers;

import be.tarsos.dsp.AudioDispatcher;
import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;
import be.tarsos.dsp.io.jvm.AudioDispatcherFactory;
import be.tarsos.dsp.pitch.PitchDetectionHandler;
import be.tarsos.dsp.pitch.PitchDetectionResult;
import be.tarsos.dsp.pitch.PitchProcessor;
import be.tarsos.dsp.ui.Axis;
import be.tarsos.dsp.ui.CoordinateSystem;
import be.tarsos.dsp.ui.layers.Layer;
import be.tarsos.dsp.ui.layers.LayerUtilities;
import be.tarsos.dsp.util.PitchConverter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.sound.sampled.UnsupportedAudioFileException;

public class PitchContourLayer
implements Layer {
    private TreeMap<Double, float[]> features = new TreeMap();
    private final CoordinateSystem cs;
    private final Color color;
    private final int frameSize;
    private final int overlap;
    private final File audioFile;

    public PitchContourLayer(CoordinateSystem cs, File audioFile, Color color, int frameSize, int overlap) {
        this.cs = cs;
        this.color = color;
        this.audioFile = audioFile;
        this.frameSize = frameSize;
        this.overlap = overlap;
        this.initialise();
    }

    @Override
    public void draw(Graphics2D graphics) {
        graphics.setColor(this.color);
        int ovalWidth = Math.round(LayerUtilities.pixelsToUnits(graphics, 4, true));
        int ovalHeight = Math.round(LayerUtilities.pixelsToUnits(graphics, 4, false));
        if (this.features != null) {
            SortedMap<Double, float[]> submap = this.features.subMap((double)this.cs.getMin(Axis.X) / 1000.0, (double)this.cs.getMax(Axis.X) / 1000.0);
            for (Map.Entry entry : submap.entrySet()) {
                double time = (Double)entry.getKey();
                double pitch = ((float[])entry.getValue())[0];
                if (!(pitch > (double)this.cs.getMin(Axis.Y)) || !(pitch < (double)this.cs.getMax(Axis.Y))) continue;
                graphics.drawOval((int)(time * 1000.0), (int)pitch, ovalWidth, ovalHeight);
            }
        }
    }

    public void initialise() {
        try {
            AudioDispatcher adp = AudioDispatcherFactory.fromFile(this.audioFile, this.frameSize, this.overlap);
            final double timeLag = (double)this.frameSize / 44100.0;
            final TreeMap fe = new TreeMap();
            adp.addAudioProcessor(new PitchProcessor(PitchProcessor.PitchEstimationAlgorithm.FFT_YIN, 44100.0f, this.frameSize, new PitchDetectionHandler(){

                @Override
                public void handlePitch(PitchDetectionResult pitchDetectionResult, AudioEvent audioEvent) {
                    if (pitchDetectionResult.isPitched()) {
                        float[] pitch = new float[]{(float)PitchConverter.hertzToAbsoluteCent(pitchDetectionResult.getPitch())};
                        fe.put(audioEvent.getTimeStamp() - timeLag, pitch);
                    }
                }
            }));
            adp.addAudioProcessor(new AudioProcessor(){

                @Override
                public void processingFinished() {
                    PitchContourLayer.this.features = fe;
                }

                @Override
                public boolean process(AudioEvent audioEvent) {
                    return true;
                }
            });
            new Thread(adp).start();
        }
        catch (UnsupportedAudioFileException e) {
            e.printStackTrace();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public String getName() {
        return "Pitch contour layer";
    }
}

