/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.ui.layers;

import be.tarsos.dsp.ui.Axis;
import be.tarsos.dsp.ui.CoordinateSystem;
import be.tarsos.dsp.ui.layers.Layer;
import be.tarsos.dsp.ui.layers.LayerUtilities;
import be.tarsos.dsp.util.PitchConverter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;

public class SpectrumLayer
implements Layer {
    private float[] spectrum;
    private List<Integer> peaksInBins;
    private float multiplier = 10.0f;
    private int sampleRate;
    private int fftSize;
    private CoordinateSystem cs;
    private final Color color;

    public SpectrumLayer(CoordinateSystem cs, int fftSize, int sampleRate, Color color) {
        this.cs = cs;
        this.sampleRate = sampleRate;
        this.fftSize = fftSize;
        this.color = color;
        this.peaksInBins = new ArrayList<Integer>();
    }

    @Override
    public void draw(Graphics2D graphics) {
        if (this.spectrum != null) {
            graphics.setColor(this.color);
            int prevFreqInCents = 0;
            int prevMagnitude = 0;
            for (int i = 1; i < this.spectrum.length; ++i) {
                float hertzValue = (float)(i * this.sampleRate) / (float)this.fftSize;
                int frequencyInCents = (int)Math.round(PitchConverter.hertzToAbsoluteCent(hertzValue));
                int magintude = Math.round(this.spectrum[i] * this.multiplier);
                if (!(this.cs.getMin(Axis.X) < (float)frequencyInCents) || !((float)frequencyInCents < this.cs.getMax(Axis.X))) continue;
                graphics.drawLine(prevFreqInCents, prevMagnitude, frequencyInCents, magintude);
                prevFreqInCents = frequencyInCents;
                prevMagnitude = magintude;
            }
            int markerWidth = Math.round(LayerUtilities.pixelsToUnits(graphics, 7, true));
            int markerheight = Math.round(LayerUtilities.pixelsToUnits(graphics, 7, false));
            graphics.setColor(Color.blue);
            for (int i = 0; i < this.peaksInBins.size(); ++i) {
                int bin = this.peaksInBins.get(i);
                float hertzValue = (float)(bin * this.sampleRate) / (float)this.fftSize;
                int frequencyInCents = (int)Math.round(PitchConverter.hertzToAbsoluteCent(hertzValue) - (double)((float)markerWidth / 2.0f));
                if (!(this.cs.getMin(Axis.X) < (float)frequencyInCents) || !((float)frequencyInCents < this.cs.getMax(Axis.X))) continue;
                int magintude = Math.round(this.spectrum[bin] * this.multiplier - (float)markerheight / 2.0f);
                graphics.drawOval(Math.round(frequencyInCents), magintude, markerWidth, markerheight);
            }
        }
    }

    @Override
    public String getName() {
        return "Spectrum";
    }

    public void setSpectrum(float[] spectrum) {
        this.spectrum = spectrum;
    }

    public void setPeak(int binIndex) {
        this.peaksInBins.add(binIndex);
    }

    public void clearPeaks() {
        this.peaksInBins.clear();
    }

    public void setSampleRate(int sampleRate) {
        this.sampleRate = sampleRate;
    }

    public void setFFTSize(int fftSize) {
        this.fftSize = fftSize;
    }
}

