/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.ui.layers;

import be.tarsos.dsp.ui.Axis;
import be.tarsos.dsp.ui.AxisUnit;
import be.tarsos.dsp.ui.CoordinateSystem;
import be.tarsos.dsp.ui.layers.Layer;
import be.tarsos.dsp.ui.layers.LayerUtilities;
import java.awt.Color;
import java.awt.Graphics2D;

public class TimeAxisLayer
implements Layer {
    private int[] intervals = new int[]{1, 2, 5, 10, 20, 50, 100, 200, 500, 1000};
    private int intervalIndex;
    CoordinateSystem cs;

    public TimeAxisLayer(CoordinateSystem cs) {
        this.cs = cs;
    }

    @Override
    public void draw(Graphics2D graphics) {
        if (this.cs.getUnitsForAxis(Axis.X) == AxisUnit.TIME) {
            int i;
            graphics.setColor(Color.black);
            int minY = Math.round(this.cs.getMin(Axis.Y));
            int maxX = Math.round(this.cs.getMax(Axis.X));
            int beginDrawInterval = 1000;
            this.intervalIndex = 0;
            int smallDrawInterval = beginDrawInterval * this.intervals[this.intervalIndex];
            int markerHeight = Math.round(LayerUtilities.pixelsToUnits(graphics, 9, false));
            int textOffset = Math.round(LayerUtilities.pixelsToUnits(graphics, 12, false));
            int smallMarkerheight = Math.round(LayerUtilities.pixelsToUnits(graphics, 4, false));
            int smallTextOffset = Math.round(LayerUtilities.pixelsToUnits(graphics, 9, false));
            int smallestMarkerheight = Math.round(LayerUtilities.pixelsToUnits(graphics, 2, false));
            int minValue = (int)this.cs.getMin(Axis.X);
            int maxValue = (int)this.cs.getMax(Axis.X);
            int differenceInMs = maxValue - minValue;
            if (differenceInMs >= 240000) {
                for (i = minValue; i < maxValue; ++i) {
                    if (i % (smallDrawInterval * 60) != 0) continue;
                    graphics.drawLine(i, minY, i, minY + markerHeight);
                    String text = String.valueOf(i / 1000);
                    LayerUtilities.drawString(graphics, text, i, minY + textOffset, true, false, null);
                }
            } else if (differenceInMs >= 120000 && differenceInMs < 240000) {
                for (i = minValue; i < maxValue; ++i) {
                    if (i % (smallDrawInterval * 10) != 0) continue;
                    graphics.drawLine(i, minY, i, minY + markerHeight);
                    String text = String.valueOf(i / 1000);
                    LayerUtilities.drawString(graphics, text, i, minY + textOffset, true, false, null);
                }
            } else if (differenceInMs >= 30000 && differenceInMs < 120000) {
                for (i = minValue; i < maxValue; ++i) {
                    if (i % (smallDrawInterval * 5) == 0) {
                        graphics.drawLine(i, minY, i, minY + markerHeight);
                        String text = String.valueOf(i / 1000);
                        LayerUtilities.drawString(graphics, text, i, minY + textOffset, true, false, null);
                        continue;
                    }
                    if (i % smallDrawInterval != 0) continue;
                    graphics.drawLine(i, minY, i, minY + smallMarkerheight);
                }
            } else if (differenceInMs > 10000 && differenceInMs < 30000) {
                for (i = minValue; i < maxValue; ++i) {
                    String text;
                    if (i % (smallDrawInterval * 5) == 0) {
                        graphics.drawLine(i, minY, i, minY + markerHeight);
                        text = String.valueOf(i / 1000);
                        LayerUtilities.drawString(graphics, text, i, minY + textOffset, true, false, null);
                        continue;
                    }
                    if (i % smallDrawInterval != 0) continue;
                    graphics.drawLine(i, minY, i, minY + smallMarkerheight);
                    text = String.valueOf(i / 1000);
                    LayerUtilities.drawString(graphics, text, i, minY + smallTextOffset, true, false, null);
                }
            } else {
                for (i = minValue; i < maxValue; ++i) {
                    String text;
                    if (i % (smallDrawInterval * 5) == 0) {
                        graphics.drawLine(i, minY, i, minY + markerHeight);
                        text = String.valueOf(i / 1000);
                        LayerUtilities.drawString(graphics, text, i, minY + textOffset, true, false, null);
                        continue;
                    }
                    if (i % smallDrawInterval == 0) {
                        graphics.drawLine(i, minY, i, minY + smallMarkerheight);
                        text = String.valueOf(i / 1000);
                        LayerUtilities.drawString(graphics, text, i, minY + smallTextOffset, true, false, null);
                        continue;
                    }
                    if (i % 100 != 0) continue;
                    graphics.drawLine(i, minY, i, minY + smallestMarkerheight);
                }
            }
            int axisLabelOffset = Math.round(LayerUtilities.pixelsToUnits(graphics, 26, true));
            textOffset = Math.round(LayerUtilities.pixelsToUnits(graphics, 14, false));
            LayerUtilities.drawString(graphics, "Time (s)", maxX - axisLabelOffset, minY + textOffset, true, true, Color.white);
        }
    }

    @Override
    public String getName() {
        return "Time axis";
    }
}

