/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.ui.layers;

import be.tarsos.dsp.ui.Axis;
import be.tarsos.dsp.ui.CoordinateSystem;
import be.tarsos.dsp.ui.layers.Layer;
import be.tarsos.dsp.ui.layers.LayerUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;

public class TooltipLayer
implements Layer,
MouseMotionListener,
MouseListener {
    private boolean enableTooltip = false;
    private int millisecondsBeforAppearance = 1000;
    private long mouseStoppedAtMilliseconds = System.currentTimeMillis();
    private Point lastPoint = null;
    private Point lastDrawnPoint = null;
    private Component component = null;
    private final CoordinateSystem cs;
    private final TooltipTextGenerator tooltipTextGenerator;
    private static final TooltipTextGenerator defaultTooltipGenerator = new TooltipTextGenerator(){

        @Override
        public String generateTooltip(CoordinateSystem cs, Point2D point) {
            return String.format("[%.03f%s , %.02f%s]", point.getX() / 1000.0, cs.getUnitsForAxis(Axis.X).getUnit(), point.getY(), cs.getUnitsForAxis(Axis.Y).getUnit());
        }
    };

    public TooltipLayer(CoordinateSystem cs) {
        this(cs, defaultTooltipGenerator);
    }

    public TooltipLayer(CoordinateSystem cs, TooltipTextGenerator tooltipTextGenerator) {
        this.cs = cs;
        this.tooltipTextGenerator = tooltipTextGenerator;
        Thread checkToolTipNeededThread = new Thread(new Runnable(){

            private void sleep() {
                try {
                    Thread.sleep(30L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }

            @Override
            public void run() {
                while (true) {
                    this.sleep();
                    long diff = System.currentTimeMillis() - TooltipLayer.this.mouseStoppedAtMilliseconds;
                    if (TooltipLayer.this.component == null || diff <= (long)TooltipLayer.this.millisecondsBeforAppearance || TooltipLayer.this.lastDrawnPoint == TooltipLayer.this.lastPoint) continue;
                    TooltipLayer.this.component.repaint();
                }
            }
        }, "Tooltip Repaint Check");
        checkToolTipNeededThread.start();
    }

    @Override
    public void draw(Graphics2D graphics) {
        long diff = System.currentTimeMillis() - this.mouseStoppedAtMilliseconds;
        if (this.enableTooltip && diff > (long)this.millisecondsBeforAppearance) {
            Point2D unitPoint = LayerUtilities.pixelsToUnits(graphics, (int)this.lastPoint.getX(), (int)this.lastPoint.getY());
            int textYOffset = Math.round(LayerUtilities.pixelsToUnits(graphics, 10, false));
            int textXOffset = Math.round(LayerUtilities.pixelsToUnits(graphics, 10, true));
            String text = this.tooltipTextGenerator.generateTooltip(this.cs, unitPoint);
            LayerUtilities.drawString(graphics, text, unitPoint.getX() + (double)textXOffset, unitPoint.getY() + (double)textYOffset, false, true, Color.white, Color.black);
            this.lastDrawnPoint = this.lastPoint;
        }
    }

    @Override
    public String getName() {
        return "Tooltip Layer";
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.enableTooltip = false;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.lastPoint = e.getPoint();
        this.component = e.getComponent();
        this.mouseStoppedAtMilliseconds = System.currentTimeMillis();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.enableTooltip = false;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.enableTooltip = true;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.lastPoint = e.getPoint();
        this.component = e.getComponent();
        this.enableTooltip = true;
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.enableTooltip = false;
    }

    public static interface TooltipTextGenerator {
        public String generateTooltip(CoordinateSystem var1, Point2D var2);
    }
}

