/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.ui.layers.pch;

import be.tarsos.dsp.ui.Axis;
import be.tarsos.dsp.ui.CoordinateSystem;
import be.tarsos.dsp.ui.LinkedPanel;
import be.tarsos.dsp.ui.layers.Layer;
import be.tarsos.dsp.ui.layers.LayerUtilities;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.util.Arrays;

public class ScaleLayer
extends MouseAdapter
implements Layer,
MouseMotionListener,
KeyListener {
    private double movingElement = -1.0;
    private double[] scale;
    private final CoordinateSystem cs;
    private final boolean enableEditor;

    public ScaleLayer(CoordinateSystem cs, boolean enableEditor) {
        this.cs = cs;
        double[] scale = new double[]{0.0, 100.0, 200.0, 400.0, 1000.0, 1100.0};
        this.scale = scale;
        this.enableEditor = enableEditor;
    }

    @Override
    public String getName() {
        return "Scale Editor Layer";
    }

    public void setScale(double[] newScale) {
        this.scale = newScale;
    }

    @Override
    public void draw(Graphics2D graphics) {
        graphics.setColor(Color.black);
        int minY = Math.round(this.cs.getMin(Axis.Y));
        int maxY = Math.round(this.cs.getMax(Axis.Y));
        int maxX = Math.round(this.cs.getMax(Axis.X));
        int textOffset = Math.round(LayerUtilities.pixelsToUnits(graphics, 20, false));
        int i = (int)this.cs.getMin(Axis.X);
        while ((float)i < this.cs.getMax(Axis.X)) {
            int realValue = (int)this.cs.getRealXValue(i);
            for (double scaleEntry : this.scale) {
                if (realValue != (int)scaleEntry) continue;
                if (scaleEntry == this.movingElement) {
                    graphics.setColor(Color.RED);
                } else if (this.enableEditor) {
                    graphics.setColor(Color.GRAY);
                } else {
                    graphics.setColor(Color.LIGHT_GRAY);
                }
                graphics.drawLine(i, minY + (int)(1.5 * (double)textOffset), i, maxY - (int)(1.5 * (double)textOffset));
                String text = String.valueOf(realValue);
                if (this.enableEditor) {
                    LayerUtilities.drawString(graphics, text, i, minY + textOffset, true, false, null);
                    continue;
                }
                LayerUtilities.drawString(graphics, text, i, maxY - textOffset, true, false, null);
            }
            ++i;
        }
        int axisLabelOffset = Math.round(LayerUtilities.pixelsToUnits(graphics, 60, true));
        textOffset = Math.round(LayerUtilities.pixelsToUnits(graphics, 10, false));
        LayerUtilities.drawString(graphics, "Frequency (cents)", maxX - axisLabelOffset, maxY - textOffset, true, true, Color.white);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.enableEditor) {
            return;
        }
        if (this.movingElement != -1.0) {
            Arrays.sort(this.scale);
        }
        this.movingElement = -1.0;
        e.getComponent().repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!this.enableEditor) {
            return;
        }
        e.getComponent().requestFocus();
        if (e.isAltDown() || e.isAltGraphDown()) {
            e.getComponent().requestFocus();
            if (this.movingElement != -1.0) {
                int index = -1;
                for (int i = 0; i < this.scale.length; ++i) {
                    if (this.scale[i] != this.movingElement) continue;
                    index = i;
                }
                if (index == -1) {
                    this.movingElement = -1.0;
                } else {
                    this.scale[index] = this.getCents(e);
                    this.movingElement = this.scale[index];
                }
                e.getComponent().repaint();
            } else {
                double[] newScale = new double[this.scale.length + 1];
                for (int i = 0; i < this.scale.length; ++i) {
                    newScale[i] = this.scale[i];
                }
                newScale[newScale.length - 1] = this.getCents(e);
                this.movingElement = newScale[newScale.length - 1];
                Arrays.sort(newScale);
                this.scale = newScale;
                e.getComponent().repaint();
            }
        } else if (e.isControlDown() && this.scale.length > 0) {
            if (this.movingElement == -1.0) {
                int index = this.closestIndex(this.getCents(e));
                this.movingElement = this.scale[index];
            }
            for (int i = 0; i < this.scale.length; ++i) {
                if (this.scale[i] != this.movingElement) continue;
                this.scale[i] = this.getCents(e);
                this.movingElement = this.scale[i];
            }
            e.getComponent().repaint();
        }
    }

    private double getCents(MouseEvent e) {
        LinkedPanel panel = (LinkedPanel)e.getComponent();
        Graphics2D graphics = (Graphics2D)panel.getGraphics();
        graphics.setTransform(panel.getTransform());
        Point2D unitsCurrent = LayerUtilities.pixelsToUnits(graphics, e.getX(), e.getY());
        return this.cs.getRealXValue((float)unitsCurrent.getX());
    }

    private int closestIndex(double key) {
        double distance = Double.MAX_VALUE;
        int index = -1;
        for (int i = 0; i < this.scale.length; ++i) {
            double wrappedDistance;
            double currentDistance = Math.abs(key - this.scale[i]);
            if (!(Math.min(currentDistance, wrappedDistance = Math.abs(key - (this.scale[i] + 1200.0))) < distance)) continue;
            distance = Math.min(currentDistance, wrappedDistance);
            index = i;
        }
        return index;
    }

    @Override
    public void keyTyped(KeyEvent e) {
        boolean deleteKeyPressed;
        if (!this.enableEditor) {
            return;
        }
        boolean elementSelected = this.movingElement != -1.0;
        boolean bl = deleteKeyPressed = e.getKeyChar() == 'd' || e.getKeyCode() == 127 || e.getKeyChar() == '\u007f';
        if (elementSelected && deleteKeyPressed) {
            double[] newScale = new double[this.scale.length - 1];
            int j = 0;
            for (int i = 0; i < this.scale.length; ++i) {
                if (this.scale[i] == this.movingElement) continue;
                newScale[j] = this.scale[i];
                ++j;
            }
            Arrays.sort(newScale);
            this.scale = newScale;
            this.movingElement = -1.0;
            e.getComponent().repaint();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

