/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;

public class AudioResourceUtils {
    private AudioResourceUtils() {
    }

    public static String sanitizeResource(String inputResource) {
        if (inputResource.toLowerCase().endsWith("pls")) {
            inputResource = AudioResourceUtils.parsePLS(inputResource);
        } else if (inputResource.toLowerCase().endsWith("m3u")) {
            inputResource = AudioResourceUtils.parseM3U(inputResource);
        } else if (inputResource.toLowerCase().endsWith("asx")) {
            inputResource = AudioResourceUtils.parseASX(inputResource);
        } else if (inputResource.toLowerCase().endsWith("xspf")) {
            inputResource = AudioResourceUtils.parseXSPF(inputResource);
        }
        return inputResource;
    }

    private static String parseXSPF(String inputResource) {
        String inputFile = "";
        try {
            String contents = AudioResourceUtils.readTextFromUrl(new URL(inputResource));
            for (String line : contents.split("\n")) {
                if (!line.toLowerCase().contains("href")) continue;
                String pattern = "(?i)<location>(.*)</location>.*";
                inputFile = line.replaceAll(pattern, "$1");
                break;
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return inputFile;
    }

    private static String parseASX(String inputResource) {
        String inputFile = "";
        try {
            String contents = AudioResourceUtils.readTextFromUrl(new URL(inputResource));
            for (String line : contents.split("\n")) {
                if (!line.toLowerCase().contains("href")) continue;
                String pattern = "(?i).*href=\"(.*)\".*";
                inputFile = line.replaceAll(pattern, "$1");
                break;
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return inputFile;
    }

    public static String parsePLS(String inputUrl) {
        String inputFile = "";
        try {
            String plsContents = AudioResourceUtils.readTextFromUrl(new URL(inputUrl));
            for (String line : plsContents.split("\n")) {
                if (!line.startsWith("File1=")) continue;
                inputFile = line.replace("File1=", "").trim();
                break;
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return inputFile;
    }

    public static String parseM3U(String inputUrl) {
        String inputFile = "";
        try {
            String plsContents = AudioResourceUtils.readTextFromUrl(new URL(inputUrl));
            for (String line : plsContents.split("\n")) {
                if (line.trim().isEmpty() || line.trim().startsWith("#")) continue;
                inputFile = line.trim();
                break;
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return inputFile;
    }

    public static String readTextFromUrl(URL url) {
        StringBuffer fubber = new StringBuffer();
        try {
            String inputLine;
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            while ((inputLine = in.readLine()) != null) {
                fubber.append(inputLine).append("\n");
            }
            in.close();
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        return fubber.toString();
    }
}

