/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.logging.Logger;

public class FFMPEGDownloader {
    private static String url = "http://0110.be/releases/TarsosDSP/TarsosDSP-static-ffmpeg/";
    private final String ffmpegBinary;
    private static final Logger LOG = Logger.getLogger(FFMPEGDownloader.class.getName());

    public FFMPEGDownloader() {
        String filename = this.operatingSystemName() + "_" + this.processorArchitecture() + "_ffmpeg" + this.suffix();
        url = url + filename;
        String tempDirectory = System.getProperty("java.io.tmpdir");
        String saveTo = new File(tempDirectory, filename).getAbsolutePath();
        if (new File(saveTo).exists()) {
            LOG.info("Found an already download ffmpeg static binary: " + saveTo);
            this.ffmpegBinary = saveTo;
        } else {
            LOG.info("Started downloading an ffmpeg static binary from  " + url);
            this.downloadExecutable(saveTo);
            if (new File(saveTo).exists()) {
                LOG.info("Downloaded an ffmpeg static binary. Stored at: " + saveTo);
                new File(saveTo).setExecutable(true);
                this.ffmpegBinary = saveTo;
            } else {
                LOG.warning("Unable to find or download an ffmpeg static binary.  " + filename);
                this.ffmpegBinary = null;
            }
        }
    }

    public String ffmpegBinary() {
        if (this.ffmpegBinary != null) {
            return this.ffmpegBinary.replace(this.suffix(), "");
        }
        return null;
    }

    private void downloadExecutable(String saveTo) {
        try {
            URL website = new URL(url);
            ReadableByteChannel rbc = Channels.newChannel(website.openStream());
            FileOutputStream fos = new FileOutputStream(saveTo);
            fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
            fos.close();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String operatingSystemName() {
        String operatingSystem = System.getProperty("os.name").toLowerCase();
        String name = operatingSystem.indexOf("indows") > 0 ? "windows" : (operatingSystem.indexOf("nux") >= 0 ? "linux" : (operatingSystem.indexOf("mac") >= 0 ? "mac_os_x" : null));
        return name;
    }

    private String processorArchitecture() {
        boolean is64bit = false;
        if (System.getProperty("os.name").contains("Windows")) {
            is64bit = System.getenv("ProgramFiles(x86)") != null;
        } else {
            boolean bl = is64bit = System.getProperty("os.arch").indexOf("64") != -1;
        }
        if (is64bit) {
            return "64_bits";
        }
        return "32_bits";
    }

    private String suffix() {
        String suffix = "";
        if (System.getProperty("os.name").contains("Windows")) {
            suffix = ".exe";
        }
        return suffix;
    }

    public static void main(String ... strings) {
        new FFMPEGDownloader();
    }
}

